/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.remote;

import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.commons.api.query.Query;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.util.concurrent.WithinThreadExecutor;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.query.LoginFailureQueries;
import org.keycloak.models.sessions.infinispan.query.QueryHelper;
import org.keycloak.models.sessions.infinispan.remote.transaction.LoginFailureChangeLogTransaction;
import org.keycloak.models.sessions.infinispan.stream.ValueIdentityBiFunction;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;

public class RemoteUserLoginFailureProvider
implements UserLoginFailureProvider {
    private static final Logger log = Logger.getLogger(MethodHandles.lookup().lookupClass());
    private final LoginFailureChangeLogTransaction transaction;

    public RemoteUserLoginFailureProvider(LoginFailureChangeLogTransaction transaction) {
        this.transaction = Objects.requireNonNull(transaction);
    }

    public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        if (log.isTraceEnabled()) {
            log.tracef("getUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        }
        return (UserLoginFailureModel)this.transaction.get(new LoginFailureKey(realm.getId(), userId));
    }

    public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        if (log.isTraceEnabled()) {
            log.tracef("addUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        }
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        LoginFailureEntity entity = new LoginFailureEntity(realm.getId(), userId);
        return (UserLoginFailureModel)this.transaction.create(key, entity);
    }

    public void removeUserLoginFailure(RealmModel realm, String userId) {
        if (log.isTraceEnabled()) {
            log.tracef("removeUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        }
        this.transaction.remove(new LoginFailureKey(realm.getId(), userId));
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        if (log.isTraceEnabled()) {
            log.tracef("removeAllUserLoginFailures(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        }
        this.transaction.removeByRealmId(realm.getId());
    }

    public void updateWithLatestRealmSettings(RealmModel realm) {
        if (!realm.isBruteForceProtected()) {
            this.removeAllUserLoginFailures(realm);
            return;
        }
        RemoteCache cache = this.transaction.getCache();
        long maxDeltaTimeMillis = (long)realm.getMaxDeltaTimeSeconds() * 1000L;
        boolean isPermanentLockout = realm.isPermanentLockout();
        int maxTemporaryLockouts = realm.getMaxTemporaryLockouts();
        Query<LoginFailureEntity> query = LoginFailureQueries.searchByRealmId(cache, realm.getId());
        CompletionStages.performConcurrently(QueryHelper.streamAll(query, 20, Function.identity()), (int)20, (Scheduler)Schedulers.from((Executor)new WithinThreadExecutor()), entry -> RemoteUserLoginFailureProvider.updateLifetimeOfCacheEntry(entry, (RemoteCache<LoginFailureKey, LoginFailureEntity>)cache, isPermanentLockout, maxTemporaryLockouts, maxDeltaTimeMillis));
    }

    private static CompletionStage<?> updateLifetimeOfCacheEntry(LoginFailureEntity entry, RemoteCache<LoginFailureKey, LoginFailureEntity> cache, boolean isPermanentLockout, int maxTemporaryLockouts, long maxDeltaTimeMillis) {
        long lifespan = SessionTimeouts.getLoginFailuresLifespanMs(isPermanentLockout, maxTemporaryLockouts, maxDeltaTimeMillis, entry);
        return cache.computeIfPresentAsync((Object)new LoginFailureKey(entry.getRealmId(), entry.getUserId()), ValueIdentityBiFunction.getInstance(), lifespan, TimeUnit.MILLISECONDS);
    }

    public void close() {
    }
}

