/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import io.reactivex.rxjava3.core.Flowable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.exceptions.HotRodClientException;
import org.infinispan.commons.api.AsyncCache;
import org.infinispan.commons.api.BasicCache;
import org.infinispan.commons.util.ByRef;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.commons.util.concurrent.CompletionStages;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.persistence.manager.PersistenceManager;
import org.jboss.logging.Logger;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.common.util.Retry;
import org.keycloak.common.util.Time;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.ModelException;
import org.keycloak.models.OfflineUserSessionModel;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserProvider;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.UserSessionProvider;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.models.session.PersistentUserSessionAdapter;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.AuthenticatedClientSessionAdapter;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.ClientSessionManager;
import org.keycloak.models.sessions.infinispan.SessionFunction;
import org.keycloak.models.sessions.infinispan.SessionRefreshStore;
import org.keycloak.models.sessions.infinispan.UserSessionAdapter;
import org.keycloak.models.sessions.infinispan.changes.ClientSessionPersistentChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.JpaChangesPerformer;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.PersistentSessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.changes.UserSessionPersistentChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.sessions.PersisterLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.EmbeddedClientSessionKey;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.sessions.infinispan.events.RealmRemovedSessionEvent;
import org.keycloak.models.sessions.infinispan.events.RemoveUserSessionsEvent;
import org.keycloak.models.sessions.infinispan.events.SessionEventsSenderTransaction;
import org.keycloak.models.sessions.infinispan.stream.ClientSessionFilterByUser;
import org.keycloak.models.sessions.infinispan.stream.MapEntryToKeyMapper;
import org.keycloak.models.sessions.infinispan.stream.Mappers;
import org.keycloak.models.sessions.infinispan.stream.RemoveKeyConsumer;
import org.keycloak.models.sessions.infinispan.stream.SessionWrapperPredicate;
import org.keycloak.models.sessions.infinispan.stream.UserSessionPredicate;
import org.keycloak.models.sessions.infinispan.util.FuturesHelper;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;
import org.keycloak.models.utils.KeycloakModelUtils;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.utils.StreamsUtil;
import org.reactivestreams.Publisher;

public class PersistentUserSessionProvider
implements UserSessionProvider,
SessionRefreshStore,
ClientSessionManager {
    private static final Logger log = Logger.getLogger(PersistentUserSessionProvider.class);
    protected final KeycloakSession session;
    protected final UserSessionPersistentChangelogBasedTransaction sessionTx;
    protected final ClientSessionPersistentChangelogBasedTransaction clientSessionTx;
    protected final SessionEventsSenderTransaction clusterEventsSenderTx;
    protected final UserSessionPersisterProvider userSessionPersister;

    public PersistentUserSessionProvider(KeycloakSession session, UserSessionPersistentChangelogBasedTransaction sessionTx, ClientSessionPersistentChangelogBasedTransaction clientSessionTx) {
        if (!MultiSiteUtils.isPersistentSessionsEnabled()) {
            throw new IllegalStateException("Persistent user sessions are not enabled");
        }
        this.session = session;
        this.sessionTx = sessionTx;
        this.clientSessionTx = clientSessionTx;
        this.clusterEventsSenderTx = new SessionEventsSenderTransaction(session);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clusterEventsSenderTx);
        this.userSessionPersister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
    }

    protected Cache<String, SessionEntityWrapper<UserSessionEntity>> getCache(boolean offline) {
        return this.sessionTx.getCache(offline);
    }

    protected Cache<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> getClientSessionCache(boolean offline) {
        return this.clientSessionTx.getCache(offline);
    }

    @Override
    public PersisterLastSessionRefreshStore getPersisterLastSessionRefreshStore() {
        throw new IllegalStateException("PersisterLastSessionRefreshStore is not supported in PersistentUserSessionProvider");
    }

    public KeycloakSession getKeycloakSession() {
        return this.session;
    }

    public AuthenticatedClientSessionModel createClientSession(RealmModel realm, ClientModel client, UserSessionModel userSession) {
        EmbeddedClientSessionKey cacheKey = new EmbeddedClientSessionKey(userSession.getId(), client.getId());
        AuthenticatedClientSessionEntity entity = new AuthenticatedClientSessionEntity();
        entity.setRealmId(realm.getId());
        entity.setClientId(client.getId());
        entity.setUserSessionId(userSession.getId());
        entity.setUserId(userSession.getUser().getId());
        entity.setTimestamp(Time.currentTime());
        entity.getNotes().put("startedAt", String.valueOf(entity.getTimestamp()));
        entity.getNotes().put("userSessionStartedAt", String.valueOf(userSession.getStarted()));
        if (userSession.isRememberMe()) {
            entity.getNotes().put("userSessionRememberMe", "true");
        }
        boolean offline = userSession.isOffline();
        AuthenticatedClientSessionAdapter adapter = new AuthenticatedClientSessionAdapter(this.session, entity, client, userSession, this, cacheKey, false);
        if (offline && this.sessionTx.get(realm, userSession.getId(), userSession, false) == null) {
            return adapter;
        }
        UserSessionModel.SessionPersistenceState persistenceState = userSession.getPersistenceState() != null ? userSession.getPersistenceState() : UserSessionModel.SessionPersistenceState.PERSISTENT;
        SessionUpdateTask createClientSessionTask = Tasks.addIfAbsentSync();
        this.clientSessionTx.addTask(cacheKey, createClientSessionTask, entity, persistenceState);
        this.addClientSessionToUserSession(cacheKey, offline);
        return adapter;
    }

    public UserSessionModel createUserSession(String id, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId, UserSessionModel.SessionPersistenceState persistenceState) {
        if (id == null) {
            id = (String)this.sessionTx.generateKey();
        }
        UserSessionEntity entity = new UserSessionEntity(id);
        this.updateSessionEntity(entity, realm, user, loginUsername, ipAddress, authMethod, rememberMe, brokerSessionId, brokerUserId);
        SessionUpdateTask createSessionTask = Tasks.addIfAbsentSync();
        this.sessionTx.addTask(id, createSessionTask, entity, persistenceState);
        UserSessionAdapter<?> adapter = user instanceof LightweightUserAdapter ? this.wrap(realm, entity, false, user) : this.wrap(realm, entity, false);
        adapter.setPersistenceState(persistenceState);
        return adapter;
    }

    void updateSessionEntity(UserSessionEntity entity, RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
        entity.setRealmId(realm.getId());
        entity.setUser(user.getId());
        entity.setLoginUsername(loginUsername);
        entity.setIpAddress(ipAddress);
        entity.setAuthMethod(authMethod);
        entity.setRememberMe(rememberMe);
        entity.setBrokerSessionId(brokerSessionId);
        entity.setBrokerUserId(brokerUserId);
        int currentTime = Time.currentTime();
        entity.setStarted(currentTime);
        entity.setLastSessionRefresh(currentTime);
    }

    public UserSessionModel getUserSession(RealmModel realm, String id) {
        return this.getUserSession(realm, id, null, false);
    }

    private UserSessionAdapter<?> getUserSession(RealmModel realm, String id, UserSessionModel userSession, boolean offline) {
        SessionEntityWrapper<UserSessionEntity> entityWrapper = this.sessionTx.get(realm, id, userSession, offline);
        return entityWrapper != null ? this.wrap(realm, entityWrapper.getEntity(), offline) : null;
    }

    private UserSessionEntity getUserSessionEntity(RealmModel realm, String id, boolean offline) {
        SessionEntityWrapper<UserSessionEntity> entityWrapper = this.sessionTx.get(realm, id, null, offline);
        return entityWrapper != null ? entityWrapper.getEntity() : null;
    }

    private Stream<UserSessionModel> getUserSessionsFromPersistenceProviderStream(RealmModel realm, UserModel user) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        return persister.loadUserSessionsStream(realm, user, true, Integer.valueOf(0), null).map(persistentUserSession -> this.getUserSession(realm, persistentUserSession.getId(), (UserSessionModel)persistentUserSession, true)).filter(Objects::nonNull);
    }

    protected Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, final UserSessionPredicate predicate, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (predicate.getUserId() != null) {
            Object user = LightweightUserAdapter.isLightweightUser((String)predicate.getUserId()) ? new UserModelDelegate(null){

                public String getId() {
                    return predicate.getUserId();
                }
            } : this.session.users().getUserById(realm, predicate.getUserId());
            if (user != null) {
                return persister.loadUserSessionsStream(realm, (UserModel)user, offline, Integer.valueOf(0), null).filter(predicate.toModelPredicate()).map(s -> this.getUserSession(realm, s.getId(), (UserSessionModel)s, offline)).filter(Objects::nonNull);
            }
            return Stream.empty();
        }
        if (predicate.getBrokerUserId() != null) {
            int split = predicate.getBrokerUserId().indexOf(46);
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("keycloak.session.realm.users.query.idp_alias", predicate.getBrokerUserId().substring(0, split));
            attributes.put("keycloak.session.realm.users.query.idp_user_id", predicate.getBrokerUserId().substring(split + 1));
            UserProvider userProvider = (UserProvider)this.session.getProvider(UserProvider.class);
            UserModel userModel = userProvider.searchForUserStream(realm, attributes, Integer.valueOf(0), null).findFirst().orElse(null);
            return userModel != null ? persister.loadUserSessionsStream(realm, userModel, offline, Integer.valueOf(0), null).filter(predicate.toModelPredicate()).map(s -> this.getUserSession(realm, s.getId(), (UserSessionModel)s, offline)).filter(Objects::nonNull) : Stream.empty();
        }
        if (predicate.getClient() != null) {
            ClientModel client = this.session.clients().getClientById(realm, predicate.getClient());
            return persister.loadUserSessionsStream(realm, client, offline, Integer.valueOf(0), null).filter(predicate.toModelPredicate()).map(s -> this.getUserSession(realm, s.getId(), (UserSessionModel)s, offline)).filter(Objects::nonNull);
        }
        if (predicate.getBrokerSessionId() != null && !offline) {
            return Stream.of(persister.loadUserSessionsStreamByBrokerSessionId(realm, predicate.getBrokerSessionId(), false)).filter(predicate.toModelPredicate()).map(s -> this.getUserSession(realm, s.getId(), (UserSessionModel)s, false)).filter(Objects::nonNull);
        }
        throw new ModelException("For offline sessions, only lookup by userId, brokerUserId and client is supported");
    }

    public AuthenticatedClientSessionAdapter getClientSession(UserSessionModel userSession, ClientModel client, boolean offline) {
        EmbeddedClientSessionKey key = new EmbeddedClientSessionKey(userSession.getId(), client.getId());
        SessionEntityWrapper<AuthenticatedClientSessionEntity> clientSessionEntity = this.clientSessionTx.get(client.getRealm(), client, userSession, key, offline);
        if (clientSessionEntity != null) {
            return new AuthenticatedClientSessionAdapter(this.session, clientSessionEntity.getEntity(), client, userSession, this, key, offline);
        }
        return null;
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, UserModel user) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), false);
    }

    public Stream<UserSessionModel> getUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), false);
    }

    public UserSessionModel getUserSessionByBrokerSessionId(RealmModel realm, String brokerSessionId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerSessionId(brokerSessionId), false).findFirst().orElse(null);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client) {
        return this.getUserSessionsStream(realm, client, -1, -1);
    }

    public Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults) {
        return this.getUserSessionsStream(realm, client, firstResult, maxResults, false);
    }

    protected Stream<UserSessionModel> getUserSessionsStream(RealmModel realm, ClientModel client, Integer firstResult, Integer maxResults, boolean offline) {
        UserSessionPredicate predicate = UserSessionPredicate.create(realm.getId()).client(client.getId());
        return StreamsUtil.paginatedStream(this.getUserSessionsStream(realm, predicate, offline), (Integer)firstResult, (Integer)maxResults);
    }

    public UserSessionModel getUserSessionWithPredicate(RealmModel realm, String id, boolean offline, Predicate<UserSessionModel> predicate) {
        UserSessionAdapter<?> userSession = this.getUserSession(realm, id, null, offline);
        if (userSession == null) {
            return null;
        }
        if (predicate.test(userSession)) {
            log.debugf("getUserSessionWithPredicate(%s): found in local cache", (Object)id);
            return userSession;
        }
        return null;
    }

    public long getActiveUserSessions(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, false);
    }

    public Map<String, Long> getActiveClientSessionStats(RealmModel realm, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        return persister.getUserSessionsCountsByClients(realm, offline);
    }

    protected long getUserSessionsCount(RealmModel realm, ClientModel client, boolean offline) {
        UserSessionPersisterProvider persister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        return persister.getUserSessionsCount(realm, client, offline);
    }

    public void removeUserSession(RealmModel realm, UserSessionModel session) {
        UserSessionEntity entity = this.getUserSessionEntity(realm, session, false);
        if (entity != null) {
            this.removeUserSession(entity, false);
        }
    }

    public void removeUserSessions(RealmModel realm, UserModel user) {
        this.removeUserSessions(realm, user, false);
    }

    protected void removeUserSessions(RealmModel realm, UserModel user, boolean offline) {
        this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).user(user.getId()), offline).forEach(s -> this.removeUserSession(realm, (UserSessionModel)s));
    }

    public void removeUserSessions(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RemoveUserSessionsEvent.createEvent(RemoveUserSessionsEvent.class, "REMOVE_USER_SESSIONS_EVENT", this.session, realm.getId()));
        ((UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class)).removeUserSessions(realm);
    }

    protected void onRemoveUserSessionsEvent(String realmId) {
        this.removeLocalUserSessions(realmId, false);
        this.removeLocalUserSessions(realmId, true);
    }

    public void removeLocalUserSessions(String realmId, boolean offline) {
        AdvancedCache<String, SessionEntityWrapper<UserSessionEntity>> localCache = CacheDecorators.localCache(this.getCache(offline));
        AdvancedCache<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> localClientSessionCache = CacheDecorators.localCache(this.getClientSessionCache(offline));
        AtomicInteger userSessionsSize = new AtomicInteger();
        PersistentUserSessionProvider.removeEntriesByRealm(realmId, localCache, userSessionsSize, localClientSessionCache);
        log.debugf("Removed %d sessions in realm %s. Offline: %b", (Object)userSessionsSize.get(), (Object)realmId, (Object)offline);
    }

    private static void removeEntriesByRealm(String realmId, Cache<String, SessionEntityWrapper<UserSessionEntity>> sessionsCache, AtomicInteger userSessionsSize, Cache<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessions) {
        FuturesHelper futures = new FuturesHelper();
        sessionsCache.entrySet().stream().filter(SessionWrapperPredicate.create(realmId)).map(Mappers.userSessionEntity()).forEach(userSessionEntity -> {
            userSessionsSize.incrementAndGet();
            CompletableFuture future = sessionsCache.removeAsync((Object)userSessionEntity.getId());
            futures.addTask(future);
            userSessionEntity.getClientSessions().forEach(clientUUID -> {
                CompletableFuture f = clientSessions.removeAsync((Object)new EmbeddedClientSessionKey(userSessionEntity.getId(), (String)clientUUID));
                futures.addTask(f);
            });
        });
        futures.waitForAllToFinish();
    }

    public void onRealmRemoved(RealmModel realm) {
        this.clusterEventsSenderTx.addEvent(RealmRemovedSessionEvent.createEvent(RealmRemovedSessionEvent.class, "REALM_REMOVED_EVENT_SESSIONS", this.session, realm.getId()));
        UserSessionPersisterProvider sessionsPersister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (sessionsPersister != null) {
            sessionsPersister.onRealmRemoved(realm);
        }
    }

    protected void onRealmRemovedEvent(String realmId) {
        this.removeLocalUserSessions(realmId, true);
        this.removeLocalUserSessions(realmId, false);
    }

    public void onClientRemoved(RealmModel realm, ClientModel client) {
        UserSessionPersisterProvider sessionsPersister = (UserSessionPersisterProvider)this.session.getProvider(UserSessionPersisterProvider.class);
        if (sessionsPersister != null) {
            sessionsPersister.onClientRemoved(realm, client);
        }
    }

    protected void onUserRemoved(RealmModel realm, UserModel user) {
        this.userSessionPersister.onUserRemoved(realm, user);
        this.removeCachedUserAndClientSessionForUser(realm.getId(), user.getId(), true);
        this.removeCachedUserAndClientSessionForUser(realm.getId(), user.getId(), false);
    }

    public void close() {
    }

    public int getStartupTime(RealmModel realm) {
        return ((ClusterProvider)this.session.getProvider(ClusterProvider.class)).getClusterStartupTime();
    }

    protected void removeUserSession(UserSessionEntity sessionEntity, boolean offline) {
        sessionEntity.getClientSessions().forEach(clientUUID -> this.clientSessionTx.addTask(new EmbeddedClientSessionKey(sessionEntity.getId(), (String)clientUUID), Tasks.removeSync(offline)));
        PersistentSessionUpdateTask removeTask = Tasks.removeSync(offline);
        this.sessionTx.addTask(sessionEntity.getId(), removeTask);
    }

    UserSessionAdapter<?> wrap(RealmModel realm, UserSessionEntity entity, boolean offline, UserModel user) {
        if (entity == null) {
            return null;
        }
        return new UserSessionAdapter<PersistentUserSessionProvider>(this.session, user, this, this.sessionTx, this.clientSessionTx, realm, entity, offline);
    }

    UserSessionAdapter<?> wrap(RealmModel realm, UserSessionEntity entity, boolean offline) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.TRANSIENT_USERS) && entity.getNotes().containsKey("keycloak.userModel")) {
            LightweightUserAdapter lua = LightweightUserAdapter.fromString((KeycloakSession)this.session, (RealmModel)realm, (String)entity.getNotes().get("keycloak.userModel"));
            UserSessionAdapter<?> us = this.wrap(realm, entity, offline, (UserModel)lua);
            lua.setUpdateHandler(lua1 -> {
                if (lua == lua1) {
                    us.setNote("keycloak.userModel", lua1.serialize());
                }
            });
            return us;
        }
        UserModel user = this.session.users().getUserById(realm, entity.getUser());
        if (user == null) {
            this.removeUserSession(realm, this.wrap(realm, entity, offline, null));
            return null;
        }
        return this.wrap(realm, entity, offline, user);
    }

    UserSessionEntity getUserSessionEntity(RealmModel realm, UserSessionModel userSession, boolean offline) {
        if (userSession instanceof UserSessionAdapter) {
            UserSessionAdapter usa = (UserSessionAdapter)userSession;
            if (!userSession.getRealm().equals((Object)realm)) {
                return null;
            }
            return usa.getEntity();
        }
        return this.getUserSessionEntity(realm, userSession.getId(), offline);
    }

    public UserSessionModel createOfflineUserSession(UserSessionModel userSession) {
        UserSessionEntity entity = PersistentUserSessionProvider.createUserSessionEntityInstance(userSession);
        entity.setOffline(true);
        SessionUpdateTask importTask = Tasks.addIfAbsentSync();
        this.sessionTx.addTask(userSession.getId(), importTask, entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        UserSessionAdapter<?> offlineUserSession = this.wrap(userSession.getRealm(), entity, true);
        int currentTime = Time.currentTime();
        offlineUserSession.getEntity().setStarted(currentTime);
        offlineUserSession.getEntity().setLastSessionRefresh(currentTime);
        return offlineUserSession;
    }

    public UserSessionAdapter<?> getOfflineUserSession(RealmModel realm, String userSessionId) {
        return this.getUserSession(realm, userSessionId, null, true);
    }

    public Stream<UserSessionModel> getOfflineUserSessionByBrokerUserIdStream(RealmModel realm, String brokerUserId) {
        return this.getUserSessionsStream(realm, UserSessionPredicate.create(realm.getId()).brokerUserId(brokerUserId), true);
    }

    public void removeOfflineUserSession(RealmModel realm, UserSessionModel userSession) {
        UserSessionEntity userSessionEntity = this.getUserSessionEntity(realm, userSession, true);
        if (userSessionEntity != null) {
            this.removeUserSession(userSessionEntity, true);
        }
    }

    public AuthenticatedClientSessionModel createOfflineClientSession(AuthenticatedClientSessionModel clientSession, UserSessionModel offlineUserSession) {
        UserSessionAdapter ousa;
        UserSessionAdapter userSessionAdapter = offlineUserSession instanceof UserSessionAdapter ? (ousa = (UserSessionAdapter)offlineUserSession) : this.getOfflineUserSession(offlineUserSession.getRealm(), offlineUserSession.getId());
        AuthenticatedClientSessionAdapter offlineClientSession = this.importOfflineClientSession(userSessionAdapter, clientSession);
        offlineClientSession.setTimestamp(Time.currentTime());
        offlineClientSession.setNote("startedAt", String.valueOf(offlineClientSession.getTimestamp()));
        offlineClientSession.setNote("userSessionStartedAt", String.valueOf(offlineUserSession.getStarted()));
        return offlineClientSession;
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, UserModel user) {
        return this.getUserSessionsFromPersistenceProviderStream(realm, user);
    }

    public long getOfflineSessionsCount(RealmModel realm, ClientModel client) {
        return this.getUserSessionsCount(realm, client, true);
    }

    public Stream<UserSessionModel> getOfflineUserSessionsStream(RealmModel realm, ClientModel client, Integer first, Integer max) {
        return this.getUserSessionsStream(realm, client, first, max, true);
    }

    public void importUserSessions(Collection<UserSessionModel> persistentUserSessions, boolean offline) {
        if (persistentUserSessions == null || persistentUserSessions.isEmpty()) {
            return;
        }
        persistentUserSessions.forEach(userSessionModel -> this.importUserSession((UserSessionModel)userSessionModel, offline));
    }

    public SessionEntityWrapper<UserSessionEntity> importUserSession(UserSessionModel persistentUserSession, boolean offline) {
        long maxIdle;
        UserSessionEntity userSessionEntityToImport = PersistentUserSessionProvider.createUserSessionEntityInstance(persistentUserSession);
        String realmId = userSessionEntityToImport.getRealmId();
        String sessionId = userSessionEntityToImport.getId();
        String userId = userSessionEntityToImport.getUser();
        RealmModel realm = this.session.realms().getRealm(realmId);
        long lifespan = offline ? SessionTimeouts.getOfflineSessionLifespanMs(realm, null, userSessionEntityToImport) : SessionTimeouts.getUserSessionLifespanMs(realm, null, userSessionEntityToImport);
        long l = maxIdle = offline ? SessionTimeouts.getOfflineSessionMaxIdleMs(realm, null, userSessionEntityToImport) : SessionTimeouts.getUserSessionMaxIdleMs(realm, null, userSessionEntityToImport);
        if (lifespan == -2L || maxIdle == -2L) {
            log.debugf("Session has expired. Do not import user-session for sessionId=%s offline=%s", (Object)sessionId, (Object)offline);
            return null;
        }
        HashMap<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>> clientSessionsById = new HashMap<EmbeddedClientSessionKey, SessionEntityWrapper<AuthenticatedClientSessionEntity>>();
        for (Map.Entry entry : persistentUserSession.getAuthenticatedClientSessions().entrySet()) {
            String clientUUID = (String)entry.getKey();
            AuthenticatedClientSessionModel clientSession = (AuthenticatedClientSessionModel)entry.getValue();
            AuthenticatedClientSessionEntity clientSessionToImport = ClientSessionPersistentChangelogBasedTransaction.createAuthenticatedClientSessionInstance(sessionId, userId, clientSession, realmId, clientUUID, offline);
            if (offline) {
                clientSessionToImport.setTimestamp(userSessionEntityToImport.getLastSessionRefresh());
            }
            clientSessionsById.put(new EmbeddedClientSessionKey(persistentUserSession.getId(), clientUUID), new SessionEntityWrapper<AuthenticatedClientSessionEntity>(clientSessionToImport));
            userSessionEntityToImport.getClientSessions().add(clientUUID);
        }
        SessionEntityWrapper<UserSessionEntity> wrappedUserSessionEntity = new SessionEntityWrapper<UserSessionEntity>(userSessionEntityToImport);
        SessionEntityWrapper<UserSessionEntity> existingSession = this.sessionTx.importSession(realm, sessionId, wrappedUserSessionEntity, offline, lifespan, maxIdle);
        if (existingSession != null) {
            log.debugf("The user-session already imported by another transaction for sessionId=%s offline=%s", (Object)sessionId, (Object)offline);
            return existingSession;
        }
        if (!offline) {
            this.migrateRememberMe(persistentUserSession);
        }
        this.clientSessionTx.importSessionsConcurrently(realm, clientSessionsById, offline);
        this.clientSessionTx.setUserSessionId(clientSessionsById.keySet(), sessionId, offline);
        return wrappedUserSessionEntity;
    }

    @Deprecated(forRemoval=true, since="26.4")
    public <T extends SessionEntity, K> Map<K, SessionEntityWrapper<T>> importSessionsWithExpiration(Map<K, SessionEntityWrapper<T>> sessionsById, BasicCache<K, SessionEntityWrapper<T>> cache, SessionFunction<T> lifespanMsCalculator, SessionFunction<T> maxIdleTimeMsCalculator) {
        return sessionsById.entrySet().stream().map(entry -> {
            Object sessionEntity = ((SessionEntityWrapper)entry.getValue()).getEntity();
            RealmModel currentRealm = this.session.realms().getRealm(((SessionEntity)sessionEntity).getRealmId());
            ClientModel client = ((SessionEntityWrapper)entry.getValue()).getClientIfNeeded(currentRealm);
            long lifespan = lifespanMsCalculator.apply(currentRealm, client, sessionEntity);
            long maxIdle = maxIdleTimeMsCalculator.apply(currentRealm, client, sessionEntity);
            if (lifespan != -2L && maxIdle != -2L) {
                if (cache instanceof RemoteCache) {
                    Retry.executeWithBackoff(iteration -> {
                        try {
                            cache.putIfAbsent(entry.getKey(), (Object)((SessionEntityWrapper)entry.getValue()), lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
                        }
                        catch (HotRodClientException re) {
                            if (log.isDebugEnabled()) {
                                log.debugf((Throwable)re, "Failed to put import %d sessions to remoteCache. Iteration '%s'. Will try to retry the task", sessionsById.size(), iteration);
                            }
                            throw re;
                        }
                    }, (int)10, (int)10);
                } else {
                    cache.putIfAbsent(entry.getKey(), (Object)((SessionEntityWrapper)entry.getValue()), lifespan, TimeUnit.MILLISECONDS, maxIdle, TimeUnit.MILLISECONDS);
                }
                return entry;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static UserSessionEntity createUserSessionEntityInstance(UserSessionModel userSession) {
        UserSessionEntity entity = new UserSessionEntity(userSession.getId());
        entity.setRealmId(userSession.getRealm().getId());
        entity.setAuthMethod(userSession.getAuthMethod());
        entity.setBrokerSessionId(userSession.getBrokerSessionId());
        entity.setBrokerUserId(userSession.getBrokerUserId());
        entity.setIpAddress(userSession.getIpAddress());
        entity.setNotes(userSession.getNotes() == null ? new ConcurrentHashMap() : userSession.getNotes());
        entity.setRememberMe(userSession.isRememberMe());
        entity.setState(userSession.getState());
        if (userSession instanceof OfflineUserSessionModel) {
            OfflineUserSessionModel offlineUserSession = (OfflineUserSessionModel)userSession;
            entity.setUser(offlineUserSession.getUserId());
        } else {
            entity.setLoginUsername(userSession.getLoginUsername());
            entity.setUser(userSession.getUser().getId());
        }
        entity.setStarted(userSession.getStarted());
        entity.setLastSessionRefresh(userSession.getLastSessionRefresh());
        entity.setOffline(userSession.isOffline());
        return entity;
    }

    private AuthenticatedClientSessionAdapter importOfflineClientSession(UserSessionAdapter<?> sessionToImportInto, AuthenticatedClientSessionModel clientSession) {
        AuthenticatedClientSessionEntity entity = ClientSessionPersistentChangelogBasedTransaction.createAuthenticatedClientSessionInstance(sessionToImportInto.getId(), sessionToImportInto.getUser().getId(), clientSession, sessionToImportInto.getRealm().getId(), clientSession.getClient().getId(), true);
        entity.setTimestamp(sessionToImportInto.getLastSessionRefresh());
        String clientUUID = clientSession.getClient().getId();
        EmbeddedClientSessionKey key = new EmbeddedClientSessionKey(sessionToImportInto.getId(), clientUUID);
        this.clientSessionTx.addTask(key, Tasks.addIfAbsentSync(), entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        sessionToImportInto.getEntity().getClientSessions().add(clientUUID);
        this.sessionTx.registerClientSession(sessionToImportInto.getId(), clientUUID, true);
        return new AuthenticatedClientSessionAdapter(this.session, entity, clientSession.getClient(), sessionToImportInto, this, key, true);
    }

    public SessionEntityWrapper<UserSessionEntity> wrapPersistentEntity(RealmModel realm, boolean offline, UserSessionModel persistentUserSession) {
        UserSessionEntity userSessionEntity = PersistentUserSessionProvider.createUserSessionEntityInstance(persistentUserSession);
        if (this.isUserSessionExpired(realm, userSessionEntity, offline)) {
            return null;
        }
        this.sessionTx.addTask(userSessionEntity.getId(), null, userSessionEntity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        if (!offline) {
            this.migrateRememberMe(persistentUserSession);
        }
        for (Map.Entry entry : persistentUserSession.getAuthenticatedClientSessions().entrySet()) {
            ClientModel client;
            String clientUUID = (String)entry.getKey();
            AuthenticatedClientSessionEntity clientSession = ClientSessionPersistentChangelogBasedTransaction.createAuthenticatedClientSessionInstance(persistentUserSession.getId(), userSessionEntity.getUser(), (AuthenticatedClientSessionModel)entry.getValue(), userSessionEntity.getRealmId(), clientUUID, offline);
            if (offline) {
                clientSession.setTimestamp(userSessionEntity.getLastSessionRefresh());
            }
            if (this.isClientSessionExpired(realm, client = this.session.clients().getClientById(realm, clientSession.getClientId()), clientSession, offline)) continue;
            EmbeddedClientSessionKey key = new EmbeddedClientSessionKey(userSessionEntity.getId(), clientUUID);
            userSessionEntity.getClientSessions().add(key.clientId());
            this.clientSessionTx.addTask(key, null, clientSession, UserSessionModel.SessionPersistenceState.PERSISTENT);
        }
        return this.sessionTx.get(userSessionEntity.getId(), offline);
    }

    private void migrateRememberMe(UserSessionModel persistentUserSession) {
        PersistentUserSessionAdapter pusa;
        if (persistentUserSession instanceof PersistentUserSessionAdapter && (pusa = (PersistentUserSessionAdapter)persistentUserSession).requiresRememberMeMigration()) {
            final boolean rememberMe = pusa.isRememberMe();
            this.sessionTx.addTask(persistentUserSession.getId(), new PersistentSessionUpdateTask<UserSessionEntity>(){

                @Override
                public boolean isOffline() {
                    return false;
                }

                @Override
                public void runUpdate(UserSessionEntity entity) {
                    entity.setRememberMe(rememberMe);
                }

                @Override
                public SessionUpdateTask.CacheOperation getOperation() {
                    return SessionUpdateTask.CacheOperation.REPLACE;
                }
            });
        }
    }

    private boolean isClientSessionExpired(RealmModel realm, ClientModel client, AuthenticatedClientSessionEntity entity, boolean offline) {
        SessionFunction<AuthenticatedClientSessionEntity> idleChecker = offline ? SessionTimeouts::getOfflineClientSessionMaxIdleMs : SessionTimeouts::getClientSessionMaxIdleMs;
        SessionFunction<AuthenticatedClientSessionEntity> lifetimeChecker = offline ? SessionTimeouts::getOfflineClientSessionLifespanMs : SessionTimeouts::getClientSessionLifespanMs;
        return idleChecker.apply(realm, client, entity) == -2L || lifetimeChecker.apply(realm, client, entity) == -2L;
    }

    private boolean isUserSessionExpired(RealmModel realm, UserSessionEntity entity, boolean offline) {
        SessionFunction<UserSessionEntity> idleChecker = offline ? SessionTimeouts::getOfflineSessionMaxIdleMs : SessionTimeouts::getUserSessionMaxIdleMs;
        SessionFunction<UserSessionEntity> lifetimeChecker = offline ? SessionTimeouts::getOfflineSessionLifespanMs : SessionTimeouts::getUserSessionLifespanMs;
        return idleChecker.apply(realm, null, entity) == -2L || lifetimeChecker.apply(realm, null, entity) == -2L;
    }

    public void migrate(String modelVersion) {
        if ("26.0.0".equals(modelVersion)) {
            log.debug((Object)"Clear caches to migrate to Infinispan Protostream");
            CompletionStages.join(((InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class)).migrateToProtoStream());
        } else if ("26.4.0".equals(modelVersion)) {
            log.debug((Object)"Clear caches as client session entries are now outdated and are not migrated");
            AggregateCompletionStage stage = CompletionStages.aggregateCompletionStage();
            Stream.of("sessions", "offlineSessions", "clientSessions", "offlineClientSessions").map(s -> {
                InfinispanConnectionProvider provider = (InfinispanConnectionProvider)this.session.getProvider(InfinispanConnectionProvider.class);
                if (provider != null) {
                    return provider.getCache((String)s, false);
                }
                return null;
            }).filter(Objects::nonNull).map(AsyncCache::clearAsync).forEach(arg_0 -> ((AggregateCompletionStage)stage).dependsOn(arg_0));
            CompletionStages.join((CompletionStage)stage.freeze());
        }
    }

    @Deprecated(since="26.4", forRemoval=true)
    public void migrateNonPersistentSessionsToPersistentSessions() {
        Cache sessionCache = this.sessionTx.getCache(false);
        Cache clientSessionCache = this.clientSessionTx.getCache(false);
        JpaChangesPerformer userSessionPerformer = new JpaChangesPerformer(sessionCache.getName(), null);
        JpaChangesPerformer<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionPerformer = new JpaChangesPerformer<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity>(clientSessionCache.getName(), null);
        AtomicInteger currentBatch = new AtomicInteger(0);
        PersistenceManager persistence = (PersistenceManager)ComponentRegistry.componentOf(sessionCache, PersistenceManager.class);
        if (persistence != null && !persistence.getStoresAsString().isEmpty()) {
            ByRef ref = ByRef.create(null);
            Flowable.fromPublisher((Publisher)persistence.publishEntries(true, false)).blockingSubscribe(e -> this.processEntryFromCache((SessionEntityWrapper)e.getValue(), userSessionPerformer, clientSessionPerformer, currentBatch), arg_0 -> ((ByRef)ref).set(arg_0));
            if (ref.get() != null) {
                throw new RuntimeException("Unable to migrate sessions", (Throwable)ref.get());
            }
        } else {
            sessionCache.forEach((key, value) -> this.processEntryFromCache((SessionEntityWrapper<UserSessionEntity>)value, userSessionPerformer, clientSessionPerformer, currentBatch));
        }
        this.flush(userSessionPerformer, clientSessionPerformer);
        sessionCache.clear();
        clientSessionCache.clear();
        this.sessionTx.getCache(true).clear();
        this.clientSessionTx.getCache(true).clear();
        log.infof("Migrated %d user sessions total.", (Object)currentBatch.intValue());
    }

    private void processEntryFromCache(SessionEntityWrapper<UserSessionEntity> sessionEntityWrapper, JpaChangesPerformer<String, UserSessionEntity> userSessionPerformer, JpaChangesPerformer<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionPerformer, AtomicInteger count) {
        RealmModel realm = this.session.realms().getRealm(sessionEntityWrapper.getEntity().getRealmId());
        if (realm == null) {
            return;
        }
        Cache clientSessionCache = this.clientSessionTx.getCache(false);
        sessionEntityWrapper.getEntity().getClientSessions().forEach(clientId -> {
            EmbeddedClientSessionKey key = new EmbeddedClientSessionKey(((UserSessionEntity)sessionEntityWrapper.getEntity()).getId(), (String)clientId);
            SessionEntityWrapper clientSession = (SessionEntityWrapper)clientSessionCache.get((Object)key);
            if (clientSession != null) {
                if (((AuthenticatedClientSessionEntity)clientSession.getEntity()).getClientId() == null) {
                    ((AuthenticatedClientSessionEntity)clientSession.getEntity()).setClientId((String)clientId);
                }
                ((AuthenticatedClientSessionEntity)clientSession.getEntity()).setUserSessionId(((UserSessionEntity)sessionEntityWrapper.getEntity()).getId());
                ((AuthenticatedClientSessionEntity)clientSession.getEntity()).setUserId(((UserSessionEntity)sessionEntityWrapper.getEntity()).getUser());
                MergedUpdate merged = MergedUpdate.computeUpdate(Collections.singletonList(Tasks.addIfAbsentSync()), clientSession, 1L, 1L);
                clientSessionPerformer.registerChange(Map.entry(key, new SessionUpdatesList(realm, clientSession)), merged);
            }
        });
        MergedUpdate<UserSessionEntity> merged = MergedUpdate.computeUpdate(Collections.singletonList(Tasks.addIfAbsentSync()), sessionEntityWrapper, 1L, 1L);
        userSessionPerformer.registerChange(Map.entry(sessionEntityWrapper.getEntity().getId(), new SessionUpdatesList<UserSessionEntity>(realm, sessionEntityWrapper)), merged);
        if (count.incrementAndGet() % 100 == 0) {
            this.flush(userSessionPerformer, clientSessionPerformer);
        }
        if (count.intValue() % 1000 == 0) {
            log.infof("Migrated %d user sessions total, continuing...", (Object)count.intValue());
        }
    }

    private <E extends SessionEntity, K> void flush(JpaChangesPerformer<K, E> userSessionsPerformer, JpaChangesPerformer<EmbeddedClientSessionKey, AuthenticatedClientSessionEntity> clientSessionPerformer) {
        KeycloakModelUtils.runJobInTransaction((KeycloakSessionFactory)this.session.getKeycloakSessionFactory(), s -> {
            userSessionsPerformer.write(s);
            clientSessionPerformer.write(s);
        });
        userSessionsPerformer.clear();
        clientSessionPerformer.clear();
    }

    @Override
    public void addChange(EmbeddedClientSessionKey key, PersistentSessionUpdateTask<AuthenticatedClientSessionEntity> task) {
        this.clientSessionTx.addTask(key, task);
    }

    @Override
    public void restartEntity(EmbeddedClientSessionKey key, PersistentSessionUpdateTask<AuthenticatedClientSessionEntity> task) {
        this.clientSessionTx.restartEntity(key, task);
        this.addClientSessionToUserSession(key, task.isOffline());
    }

    private void addClientSessionToUserSession(EmbeddedClientSessionKey cacheKey, boolean offline) {
        this.sessionTx.registerClientSession(cacheKey.userSessionId(), cacheKey.clientId(), offline);
    }

    private void removeCachedUserAndClientSessionForUser(String realmId, String userId, boolean offline) {
        if (this.getCache(offline) == null) {
            return;
        }
        try (CacheStream stream = this.getCache(offline).getAdvancedCache().entrySet().stream().filter((Predicate)UserSessionPredicate.create(realmId).user(userId)).map(MapEntryToKeyMapper.getInstance());){
            stream.forEach(RemoveKeyConsumer.getInstance());
        }
        stream = this.getClientSessionCache(offline).getAdvancedCache().entrySet().stream().filter((Predicate)new ClientSessionFilterByUser(realmId, userId)).map(MapEntryToKeyMapper.getInstance());
        try {
            stream.forEach(RemoveKeyConsumer.getInstance());
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }
}

