/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.offheap;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.ObjIntConsumer;
import org.infinispan.commons.marshall.WrappedBytes;
import org.infinispan.commons.util.FilterIterator;
import org.infinispan.commons.util.FilterSpliterator;
import org.infinispan.commons.util.IntSet;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.AbstractInternalDataContainer;
import org.infinispan.container.impl.PeekableTouchableMap;
import org.infinispan.container.offheap.OffHeapConcurrentMap;
import org.infinispan.container.offheap.OffHeapEntryFactory;
import org.infinispan.container.offheap.OffHeapMemoryAllocator;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;

public class OffHeapDataContainer
extends AbstractInternalDataContainer<WrappedBytes, WrappedBytes> {
    @Inject
    protected OffHeapMemoryAllocator allocator;
    @Inject
    protected OffHeapEntryFactory offHeapEntryFactory;
    private OffHeapConcurrentMap map;

    @Start
    public void start() {
        this.map = new OffHeapConcurrentMap(this.allocator, this.offHeapEntryFactory, null);
    }

    @Stop
    public void stop() {
        this.clear();
        this.map.close();
    }

    @Override
    protected PeekableTouchableMap<WrappedBytes, WrappedBytes> getMapForSegment(int segment) {
        return this.map;
    }

    @Override
    protected int getSegmentForKey(Object key) {
        return -1;
    }

    @Override
    public Spliterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> spliterator() {
        return this.filterExpiredEntries(this.spliteratorIncludingExpired());
    }

    @Override
    public Spliterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> spliterator(IntSet segments) {
        return new FilterSpliterator(this.spliterator(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public Spliterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> spliteratorIncludingExpired() {
        return this.map.values().spliterator();
    }

    @Override
    public Spliterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> spliteratorIncludingExpired(IntSet segments) {
        return new FilterSpliterator(this.spliteratorIncludingExpired(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iterator() {
        return new AbstractInternalDataContainer.EntryIterator(this, this.iteratorIncludingExpired());
    }

    @Override
    public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iterator(IntSet segments) {
        return new FilterIterator(this.iterator(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iteratorIncludingExpired() {
        return this.map.values().iterator();
    }

    @Override
    public Iterator<InternalCacheEntry<WrappedBytes, WrappedBytes>> iteratorIncludingExpired(IntSet segments) {
        return new FilterIterator(this.iteratorIncludingExpired(), ice -> segments.contains(this.keyPartitioner.getSegment(ice.getKey())));
    }

    @Override
    public void addSegments(IntSet segments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSegments(IntSet segments) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int sizeIncludingExpired() {
        return this.map.size();
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public void forEachSegment(ObjIntConsumer<PeekableTouchableMap<WrappedBytes, WrappedBytes>> segmentMapConsumer) {
        segmentMapConsumer.accept(this.map, 0);
    }
}

