/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.cte;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.boot.spi.InFlightMetadataCollector;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.metamodel.mapping.AttributeMapping;
import org.hibernate.metamodel.mapping.DiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityDiscriminatorMapping;
import org.hibernate.metamodel.mapping.EntityIdentifierMapping;
import org.hibernate.metamodel.mapping.EntityMappingType;
import org.hibernate.metamodel.mapping.ModelPart;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.internal.SingleAttributeIdentifierMapping;
import org.hibernate.query.sqm.mutation.internal.SqmMutationStrategyHelper;
import org.hibernate.query.sqm.tuple.internal.AnonymousTupleTableGroupProducer;
import org.hibernate.query.sqm.tuple.internal.CteTupleTableGroupProducer;
import org.hibernate.sql.ast.tree.cte.CteColumn;

public class CteTable {
    public static final String ENTITY_ROW_NUMBER_COLUMN = "rn_";
    private final String cteName;
    private final AnonymousTupleTableGroupProducer tableGroupProducer;
    private final List<CteColumn> cteColumns;

    public CteTable(String cteName, List<CteColumn> cteColumns) {
        this(cteName, null, cteColumns);
    }

    public CteTable(String cteName, CteTupleTableGroupProducer tableGroupProducer) {
        this(cteName, tableGroupProducer, tableGroupProducer.determineCteColumns());
    }

    private CteTable(String cteName, AnonymousTupleTableGroupProducer tableGroupProducer, List<CteColumn> cteColumns) {
        assert (cteName != null);
        this.cteName = cteName;
        this.tableGroupProducer = tableGroupProducer;
        this.cteColumns = List.copyOf(cteColumns);
    }

    public String getTableExpression() {
        return this.cteName;
    }

    public AnonymousTupleTableGroupProducer getTableGroupProducer() {
        return this.tableGroupProducer;
    }

    public List<CteColumn> getCteColumns() {
        return this.cteColumns;
    }

    public CteTable withName(String name) {
        return new CteTable(name, this.tableGroupProducer, this.cteColumns);
    }

    @Deprecated(forRemoval=true, since="7.1")
    public static CteTable createIdTable(String cteName, EntityMappingType entityDescriptor) {
        int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(numberOfColumns);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        String idName = identifierMapping instanceof SingleAttributeIdentifierMapping ? identifierMapping.getAttributeName() : "id";
        CteTable.forEachCteColumn(idName, identifierMapping, columns::add);
        return new CteTable(cteName, columns);
    }

    @Deprecated(forRemoval=true, since="7.1")
    public static CteTable createEntityTable(String cteName, EntityMappingType entityDescriptor) {
        int numberOfColumns = entityDescriptor.getIdentifierMapping().getJdbcTypeCount();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(numberOfColumns);
        EntityIdentifierMapping identifierMapping = entityDescriptor.getIdentifierMapping();
        String idName = identifierMapping instanceof SingleAttributeIdentifierMapping ? identifierMapping.getAttributeName() : "id";
        CteTable.forEachCteColumn(idName, identifierMapping, columns::add);
        EntityDiscriminatorMapping discriminatorMapping = entityDescriptor.getDiscriminatorMapping();
        if (discriminatorMapping != null && discriminatorMapping.hasPhysicalColumn() && !discriminatorMapping.isFormula()) {
            CteTable.forEachCteColumn("class", discriminatorMapping, columns::add);
        }
        entityDescriptor.visitSubTypeAttributeMappings(attribute -> {
            if (!(attribute instanceof PluralAttributeMapping)) {
                CteTable.forEachCteColumn(attribute.getAttributeName(), attribute, columns::add);
            }
        });
        columns.add(new CteColumn(ENTITY_ROW_NUMBER_COLUMN, entityDescriptor.getEntityPersister().getFactory().getTypeConfiguration().getBasicTypeForJavaType(Integer.class)));
        return new CteTable(cteName, columns);
    }

    public static CteTable createIdTable(String cteName, PersistentClass persistentClass) {
        Property identifierProperty = persistentClass.getIdentifierProperty();
        String idName = identifierProperty != null ? identifierProperty.getName() : "id";
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(persistentClass.getIdentifier().getColumnSpan());
        InFlightMetadataCollector metadata = persistentClass.getIdentifier().getBuildingContext().getMetadataCollector();
        CteTable.forEachCteColumn(idName, persistentClass.getIdentifier(), columns::add);
        return new CteTable(cteName, columns);
    }

    public static CteTable createEntityTable(String cteName, PersistentClass persistentClass) {
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(persistentClass.getTable().getColumnSpan());
        Property identifierProperty = persistentClass.getIdentifierProperty();
        String idName = identifierProperty != null ? identifierProperty.getName() : "id";
        InFlightMetadataCollector metadata = persistentClass.getIdentifier().getBuildingContext().getMetadataCollector();
        CteTable.forEachCteColumn(idName, persistentClass.getIdentifier(), columns::add);
        Value discriminator = persistentClass.getDiscriminator();
        if (discriminator != null && !discriminator.getSelectables().get(0).isFormula()) {
            CteTable.forEachCteColumn("class", persistentClass.getIdentifier(), columns::add);
        }
        for (Property property : persistentClass.getPropertyClosure()) {
            if (property.isSynthetic()) continue;
            CteTable.forEachCteColumn(property.getName(), property.getValue(), columns::add);
        }
        columns.add(new CteColumn(ENTITY_ROW_NUMBER_COLUMN, metadata.getDatabase().getTypeConfiguration().getBasicTypeForJavaType(Integer.class)));
        return new CteTable(cteName, columns);
    }

    private static void forEachCteColumn(String prefix, Value value, Consumer<CteColumn> consumer) {
        SqmMutationStrategyHelper.forEachSelectableMapping(prefix, value, (columnName, selectable) -> consumer.accept(new CteColumn((String)columnName, selectable.getType())));
    }

    private static void forEachCteColumn(String prefix, ModelPart modelPart, Consumer<CteColumn> consumer) {
        SqmMutationStrategyHelper.forEachSelectableMapping(prefix, modelPart, (s, selectableMapping) -> consumer.accept(new CteColumn((String)s, selectableMapping.getJdbcMapping())));
    }

    public List<CteColumn> findCteColumns(ModelPart modelPart) {
        String prefix;
        if (modelPart instanceof AttributeMapping) {
            AttributeMapping attributeMapping = (AttributeMapping)modelPart;
            prefix = attributeMapping.getAttributeName();
        } else {
            prefix = modelPart instanceof DiscriminatorMapping ? "class" : "";
        }
        int jdbcTypeCount = modelPart.getJdbcTypeCount();
        ArrayList<CteColumn> columns = new ArrayList<CteColumn>(jdbcTypeCount);
        SqmMutationStrategyHelper.forEachSelectableMapping(prefix, modelPart, (s, selectableMapping) -> {
            for (CteColumn cteColumn : this.cteColumns) {
                if (!s.equals(cteColumn.getColumnExpression())) continue;
                columns.add(cteColumn);
                break;
            }
        });
        return columns;
    }
}

