/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.rendering.spi;

import java.lang.annotation.Annotation;
import java.util.List;
import org.hibernate.models.internal.AnnotationHelper;
import org.hibernate.models.rendering.spi.Renderer;
import org.hibernate.models.rendering.spi.RenderingTarget;
import org.hibernate.models.spi.AnnotationDescriptor;
import org.hibernate.models.spi.AnnotationTarget;
import org.hibernate.models.spi.AttributeDescriptor;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.FieldDetails;
import org.hibernate.models.spi.MethodDetails;
import org.hibernate.models.spi.ModelsContext;
import org.hibernate.models.spi.RecordComponentDetails;

public abstract class AbstractRenderer
implements Renderer {
    protected abstract RenderingTarget getRenderingTarget();

    @Override
    public void renderClass(ClassDetails classDetails, ModelsContext context) {
        this.renderDirectAnnotations(classDetails, context);
        this.renderClassDetails(classDetails, context);
    }

    private void renderDirectAnnotations(AnnotationTarget annotationTarget, ModelsContext context) {
        annotationTarget.forEachDirectAnnotationUsage(usage -> this.renderAnnotation(usage, context));
    }

    protected abstract void renderClassDetails(ClassDetails var1, ModelsContext var2);

    @Override
    public void renderField(FieldDetails fieldDetails, ModelsContext context) {
        this.renderDirectAnnotations(fieldDetails, context);
        this.renderFieldDetails(fieldDetails, context);
    }

    protected abstract void renderFieldDetails(FieldDetails var1, ModelsContext var2);

    @Override
    public void renderMethod(MethodDetails methodDetails, ModelsContext context) {
        this.renderDirectAnnotations(methodDetails, context);
        this.renderMethodDetails(methodDetails, context);
    }

    protected abstract void renderMethodDetails(MethodDetails var1, ModelsContext var2);

    @Override
    public void renderRecordComponent(RecordComponentDetails recordComponentDetails, ModelsContext context) {
        this.renderDirectAnnotations(recordComponentDetails, context);
        this.renderRecordComponentDetails(recordComponentDetails, context);
    }

    protected abstract void renderRecordComponentDetails(RecordComponentDetails var1, ModelsContext var2);

    @Override
    public <A extends Annotation> void renderAnnotation(A annotation, ModelsContext context) {
        AnnotationDescriptor<? extends Annotation> descriptor = context.getAnnotationDescriptorRegistry().getDescriptor(annotation.annotationType());
        List<AttributeDescriptor<?>> attributes = descriptor.getAttributes();
        if (attributes.isEmpty()) {
            this.getRenderingTarget().addLine("@%s", descriptor.getAnnotationType().getName());
        } else {
            this.getRenderingTarget().addLine("@%s(", descriptor.getAnnotationType().getName());
            this.getRenderingTarget().indent(2);
            attributes.forEach(attribute -> attribute.getTypeDescriptor().render(attribute.getName(), AnnotationHelper.extractValue(annotation, attribute), this.getRenderingTarget(), this, context));
            this.getRenderingTarget().unindent(2);
            this.getRenderingTarget().addLine(")");
        }
    }

    @Override
    public <A extends Annotation> void renderNestedAnnotation(String name, A annotation, ModelsContext context) {
        AnnotationDescriptor<? extends Annotation> descriptor = context.getAnnotationDescriptorRegistry().getDescriptor(annotation.annotationType());
        List<AttributeDescriptor<?>> attributes = descriptor.getAttributes();
        this.getRenderingTarget().addLine("%s = @%s(", name, descriptor.getAnnotationType().getName());
        this.getRenderingTarget().indent(2);
        attributes.forEach(attribute -> attribute.getTypeDescriptor().render(attribute.getName(), AnnotationHelper.extractValue(annotation, attribute), this.getRenderingTarget(), this, context));
        this.getRenderingTarget().unindent(2);
        this.getRenderingTarget().addLine(")");
    }

    @Override
    public <A extends Annotation> void renderNestedAnnotation(A annotation, ModelsContext context) {
        AnnotationDescriptor<? extends Annotation> descriptor = context.getAnnotationDescriptorRegistry().getDescriptor(annotation.annotationType());
        List<AttributeDescriptor<?>> attributes = descriptor.getAttributes();
        this.getRenderingTarget().addLine("@%s(", descriptor.getAnnotationType().getName());
        this.getRenderingTarget().indent(2);
        attributes.forEach(attribute -> attribute.getTypeDescriptor().render(attribute.getName(), AnnotationHelper.extractValue(annotation, attribute), this.getRenderingTarget(), this, context));
        this.getRenderingTarget().unindent(2);
        this.getRenderingTarget().addLine(")");
    }
}

