/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree.select;

import jakarta.persistence.Tuple;
import jakarta.persistence.criteria.AbstractQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.ParameterExpression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Selection;
import jakarta.persistence.metamodel.EntityType;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.hibernate.Internal;
import org.hibernate.query.common.FetchClauseType;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaExpression;
import org.hibernate.query.criteria.JpaQueryPart;
import org.hibernate.query.criteria.JpaSelection;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SemanticQueryWalker;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.internal.SqmUtil;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmQuery;
import org.hibernate.query.sqm.tree.SqmStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmFromClause;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.jpa.ParameterCollector;
import org.hibernate.query.sqm.tree.select.AbstractSqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.query.sqm.tree.select.SqmQueryGroup;
import org.hibernate.query.sqm.tree.select.SqmQueryPart;
import org.hibernate.query.sqm.tree.select.SqmQuerySpec;
import org.hibernate.query.sqm.tree.select.SqmSelectClause;
import org.hibernate.query.sqm.tree.select.SqmSelectableNode;
import org.hibernate.query.sqm.tree.select.SqmSortSpecification;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public class SqmSelectStatement<T>
extends AbstractSqmSelectQuery<T>
implements JpaCriteriaQuery<T>,
SqmStatement<T>,
org.hibernate.query.sqm.internal.ParameterCollector {
    private final SqmQuerySource querySource;
    private Set<SqmParameter<?>> parameters;
    private int aliasCounter = 0;

    public SqmSelectStatement(NodeBuilder nodeBuilder) {
        this(SqmQuerySource.HQL, nodeBuilder);
    }

    public SqmSelectStatement(SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(null, nodeBuilder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(Class<T> resultJavaType, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(resultJavaType, nodeBuilder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(SqmQueryPart<T> queryPart, Class<T> resultType, SqmQuerySource querySource, NodeBuilder builder) {
        super(queryPart, resultType, builder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(SqmQueryPart<T> queryPart, Class<T> resultType, Map<String, SqmCteStatement<?>> cteStatements, SqmQuerySource querySource, NodeBuilder builder) {
        super(queryPart, cteStatements, resultType, builder);
        this.querySource = querySource;
    }

    public SqmSelectStatement(Class<T> resultJavaType, NodeBuilder nodeBuilder) {
        super(resultJavaType, nodeBuilder);
        this.querySource = SqmQuerySource.CRITERIA;
        ((SqmQuerySpec)this.getQuerySpec()).setSelectClause(new SqmSelectClause(false, nodeBuilder));
        ((SqmQuerySpec)this.getQuerySpec()).setFromClause(new SqmFromClause());
    }

    public SqmSelectStatement(SqmSelectStatement<T> original) {
        super(original.getQueryPart(), original.getCteStatementMap(), original.getResultType(), original.nodeBuilder());
        this.querySource = SqmQuerySource.CRITERIA;
    }

    private SqmSelectStatement(NodeBuilder builder, Map<String, SqmCteStatement<?>> cteStatements, Class<T> resultType, SqmQuerySource querySource, Set<SqmParameter<?>> parameters) {
        super(builder, cteStatements, resultType);
        this.querySource = querySource;
        this.parameters = parameters;
    }

    @Override
    public SqmSelectStatement<T> copy(SqmCopyContext context) {
        SqmSelectStatement existing = context.getCopy(this);
        return existing != null ? existing : this.createCopy(context, this.getResultType());
    }

    @Internal
    public <X> SqmSelectStatement<X> createCopy(SqmCopyContext context, Class<X> resultType) {
        LinkedHashSet parameters;
        if (this.parameters == null) {
            parameters = null;
        } else {
            parameters = new LinkedHashSet(this.parameters.size());
            for (SqmParameter<?> parameter : this.parameters) {
                parameters.add((SqmParameter<?>)parameter.copy(context));
            }
        }
        SqmSelectStatement<X> statement = context.registerCopy(this, new SqmSelectStatement<X>(this.nodeBuilder(), this.copyCteStatements(context), resultType, context.getQuerySource() == null ? this.getQuerySource() : context.getQuerySource(), parameters));
        statement.setQueryPart((SqmQueryPart<X>)((SqmQueryPart)this.getQueryPart()).copy(context));
        return statement;
    }

    public void validateResultType(Class<?> resultType) {
        SqmUtil.validateQueryReturnType(this.getQueryPart(), resultType);
    }

    @Override
    public NodeBuilder getCriteriaBuilder() {
        return this.nodeBuilder();
    }

    public List<Order> getOrderList() {
        return Collections.unmodifiableList(((SqmQueryPart)this.getQueryPart()).getSortSpecifications());
    }

    @Override
    public SqmQuerySource getQuerySource() {
        return this.querySource;
    }

    @Override
    public SqmQuerySpec<T> getQuerySpec() {
        if (this.querySource == SqmQuerySource.CRITERIA) {
            JpaQueryPart jpaQueryPart = this.getQueryPart();
            if (jpaQueryPart instanceof SqmQuerySpec) {
                SqmQuerySpec querySpec = (SqmQuerySpec)jpaQueryPart;
                return querySpec;
            }
            throw new IllegalStateException("Query group can't be treated as query spec. Use JpaSelectCriteria#getQueryPart to access query group details");
        }
        return super.getQuerySpec();
    }

    public boolean producesUniqueResults() {
        SqmQuerySpec querySpec;
        JpaQueryPart jpaQueryPart = this.getQueryPart();
        return !(jpaQueryPart instanceof SqmQuerySpec) || (querySpec = (SqmQuerySpec)jpaQueryPart).producesUniqueResults();
    }

    public boolean containsCollectionFetches() {
        return this.containsCollectionFetches((SqmQueryPart<?>)this.getQueryPart());
    }

    private boolean containsCollectionFetches(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            SqmQuerySpec querySpec = (SqmQuerySpec)queryPart;
            return querySpec.containsCollectionFetches();
        }
        if (queryPart instanceof SqmQueryGroup) {
            SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
            return this.containsCollectionFetches(queryGroup.getQueryParts().get(0));
        }
        throw new IllegalStateException("No SqmQueryPart");
    }

    public boolean usesDistinct() {
        return this.usesDistinct((SqmQueryPart<?>)this.getQueryPart());
    }

    private boolean usesDistinct(SqmQueryPart<?> queryPart) {
        if (queryPart instanceof SqmQuerySpec) {
            SqmQuerySpec querySpec = (SqmQuerySpec)queryPart;
            return querySpec.getSelectClause().isDistinct();
        }
        if (queryPart instanceof SqmQueryGroup) {
            SqmQueryGroup queryGroup = (SqmQueryGroup)queryPart;
            return this.usesDistinct(queryGroup.getQueryParts().get(0));
        }
        throw new IllegalStateException("No SqmQueryPart");
    }

    @Override
    public Set<SqmParameter<?>> getSqmParameters() {
        if (this.querySource == SqmQuerySource.CRITERIA) {
            assert (this.parameters == null) : "SqmSelectStatement (as Criteria) should not have collected parameters";
            return ParameterCollector.collectParameters(this);
        }
        return this.parameters == null ? Collections.emptySet() : Collections.unmodifiableSet(this.parameters);
    }

    @Override
    public SqmStatement.ParameterResolutions resolveParameters() {
        return SqmUtil.resolveParameters(this);
    }

    @Override
    public <X> X accept(SemanticQueryWalker<X> walker) {
        return walker.visitSelectStatement(this);
    }

    @Override
    public void addParameter(SqmParameter<?> parameter) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashSet();
        }
        this.parameters.add(parameter);
    }

    @Override
    protected <X> JpaCteCriteria<X> withInternal(String name, AbstractQuery<X> criteria) {
        if (criteria instanceof SqmSubQuery) {
            throw new IllegalArgumentException("Invalid query type provided to root query 'with' method, expecting a root query to use as CTE instead found a subquery");
        }
        return super.withInternal(name, criteria);
    }

    @Override
    protected <X> JpaCteCriteria<X> withInternal(String name, AbstractQuery<X> baseCriteria, boolean unionDistinct, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        if (baseCriteria instanceof SqmSubQuery) {
            throw new IllegalArgumentException("Invalid query type provided to root query 'with' method, expecting a root query to use as CTE instead found a subquery");
        }
        return super.withInternal(name, baseCriteria, unionDistinct, recursiveCriteriaProducer);
    }

    @Override
    public SqmSelectStatement<T> distinct(boolean distinct) {
        super.distinct(distinct);
        return this;
    }

    @Override
    public Set<ParameterExpression<?>> getParameters() {
        assert (this.querySource == SqmQuerySource.CRITERIA);
        return SqmUtil.getParameters(this);
    }

    @Override
    public <U> SqmSubQuery<U> subquery(EntityType<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    @Override
    public SqmSelectStatement<T> select(Selection<? extends T> selection) {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            this.checkSelectionIsJpaCompliant(selection);
        }
        ((SqmQuerySpec)this.getQuerySpec()).setSelection((JpaSelection)selection);
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectStatement<T> multiselect(Selection<?> ... selections) {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            for (Selection<?> selection : selections) {
                this.checkSelectionIsJpaCompliant(selection);
            }
        }
        ((SqmQuerySpec)this.getQuerySpec()).getSelectClause().setSelection((SqmSelectableNode)this.getResultSelection(selections));
        return this;
    }

    @Override
    @Deprecated
    public SqmSelectStatement<T> multiselect(List<Selection<?>> selectionList) {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            for (Selection<?> selection : selectionList) {
                this.checkSelectionIsJpaCompliant(selection);
            }
        }
        ((SqmQuerySpec)this.getQuerySpec()).getSelectClause().setSelection((SqmSelectableNode)this.getResultSelection(selectionList));
        return this;
    }

    private JpaSelection<?> getResultSelection(List<Selection<?>> selections) {
        Class resultType = this.getResultType();
        if (resultType == null || resultType == Object.class) {
            return switch (selections.size()) {
                case 0 -> throw new IllegalArgumentException("empty selections passed to criteria query typed as Object");
                case 1 -> (JpaSelection)selections.get(0);
                default -> this.nodeBuilder().array((List)selections);
            };
        }
        if (Tuple.class.isAssignableFrom(resultType)) {
            return this.nodeBuilder().tuple((List)selections);
        }
        if (resultType.isArray()) {
            return this.nodeBuilder().array(resultType, selections);
        }
        return this.nodeBuilder().construct(resultType, selections);
    }

    private void checkSelectionIsJpaCompliant(Selection<?> selection) {
        if (selection instanceof SqmSubQuery) {
            throw new IllegalStateException("The JPA specification does not support subqueries in select clauses. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    @Override
    public SqmSelectStatement<T> orderBy(Order ... orders) {
        SqmOrderByClause sqmOrderByClause = new SqmOrderByClause(orders.length);
        for (Order order : orders) {
            sqmOrderByClause.addSortSpecification((SqmSortSpecification)order);
        }
        ((SqmQueryPart)this.getQueryPart()).setOrderByClause(sqmOrderByClause);
        return this;
    }

    @Override
    public SqmSelectStatement<T> orderBy(List<Order> orders) {
        SqmOrderByClause sqmOrderByClause = new SqmOrderByClause(orders.size());
        for (Order order : orders) {
            sqmOrderByClause.addSortSpecification((SqmSortSpecification)order);
        }
        ((SqmQueryPart)this.getQueryPart()).setOrderByClause(sqmOrderByClause);
        return this;
    }

    @Override
    public <U> SqmSubQuery<U> subquery(Class<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    @Override
    public SqmSelectStatement<T> where(Expression<Boolean> restriction) {
        super.where((Expression)restriction);
        return this;
    }

    @Override
    public SqmSelectStatement<T> where(Predicate ... restrictions) {
        super.where(restrictions);
        return this;
    }

    @Override
    public SqmSelectStatement<T> where(List<Predicate> restrictions) {
        super.where((List)restrictions);
        return this;
    }

    @Override
    public SqmSelectStatement<T> groupBy(Expression<?> ... expressions) {
        super.groupBy((Expression[])expressions);
        return this;
    }

    @Override
    public SqmSelectStatement<T> groupBy(List<Expression<?>> grouping) {
        super.groupBy((List)grouping);
        return this;
    }

    @Override
    public SqmSelectStatement<T> having(Expression<Boolean> booleanExpression) {
        super.having((Expression)booleanExpression);
        return this;
    }

    @Override
    public SqmSelectStatement<T> having(Predicate ... predicates) {
        super.having(predicates);
        return this;
    }

    @Override
    public SqmSelectStatement<T> having(List<Predicate> restrictions) {
        super.having(restrictions);
        return this;
    }

    @Override
    public JpaExpression<Number> getOffset() {
        return ((SqmQueryPart)this.getQueryPart()).getOffset();
    }

    @Override
    public JpaCriteriaQuery<T> offset(JpaExpression<? extends Number> offset) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setOffset((JpaExpression)offset);
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> offset(Number offset) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setOffset(this.nodeBuilder().value(offset));
        return this;
    }

    @Override
    public JpaExpression<Number> getFetch() {
        return ((SqmQueryPart)this.getQueryPart()).getFetch();
    }

    @Override
    public JpaCriteriaQuery<T> fetch(JpaExpression<? extends Number> fetch) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch((JpaExpression)fetch);
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> fetch(JpaExpression<? extends Number> fetch, FetchClauseType fetchClauseType) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(fetch, fetchClauseType);
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> fetch(Number fetch) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch));
        return this;
    }

    @Override
    public JpaCriteriaQuery<T> fetch(Number fetch, FetchClauseType fetchClauseType) {
        this.validateComplianceFetchOffset();
        ((SqmQueryPart)this.getQueryPart()).setFetch(this.nodeBuilder().value(fetch), fetchClauseType);
        return this;
    }

    @Override
    public FetchClauseType getFetchClauseType() {
        return ((SqmQueryPart)this.getQueryPart()).getFetchClauseType();
    }

    private void validateComplianceFetchOffset() {
        if (this.nodeBuilder().isJpaQueryComplianceEnabled()) {
            throw new IllegalStateException("The JPA specification does not support the fetch or offset clause. Please disable the JPA query compliance if you want to use this feature.");
        }
    }

    public SqmSelectStatement<Long> createCountQuery() {
        SqmQuerySpec querySpec;
        SqmSelectStatement<Object> copy = this.createCopy(SqmCopyContext.noParamCopyContext(), Object.class);
        JpaQueryPart queryPart = copy.getQueryPart();
        if (queryPart instanceof SqmQuerySpec && !(querySpec = (SqmQuerySpec)queryPart).isDistinct() && querySpec.getGroupingExpressions().isEmpty()) {
            for (SqmRoot<?> root : querySpec.getRootList()) {
                root.removeLeftFetchJoins();
            }
            querySpec.getSelectClause().setSelection((SqmSelectableNode<?>)((Object)this.nodeBuilder().count()));
            if (querySpec.getFetch() == null && querySpec.getOffset() == null) {
                querySpec.setOrderByClause(null);
            }
            return copy;
        }
        this.aliasSelections((SqmQueryPart)queryPart);
        JpaCriteriaQuery query = this.nodeBuilder().createQuery(Long.class);
        SqmSubQuery subquery = new SqmSubQuery((SqmQuery<?>)((Object)query), queryPart, null, this.nodeBuilder());
        ((AbstractSqmSelectQuery)((Object)query)).from(subquery);
        ((SqmSelectStatement)query).select(this.nodeBuilder().count());
        if (subquery.getFetch() == null && subquery.getOffset() == null) {
            ((SqmQueryPart)subquery.getQueryPart()).setOrderByClause(null);
        }
        return query;
    }

    public SqmSelectStatement<Boolean> createExistsQuery() {
        SqmSelectStatement<Object> copy = this.createCopy(SqmCopyContext.noParamCopyContext(), Object.class);
        JpaQueryPart queryPart = copy.getQueryPart();
        if (((SqmQueryPart)queryPart).isSimpleQueryPart()) {
            SqmQuerySpec querySpec = (SqmQuerySpec)queryPart;
            querySpec.setDistinct(false);
            if (querySpec.getGroupingExpressions().isEmpty()) {
                for (SqmRoot<?> root : querySpec.getRootList()) {
                    root.removeLeftFetchJoins();
                }
                querySpec.getSelectClause().setSelection((SqmSelectableNode<?>)((Object)this.nodeBuilder().literal((Object)1)));
            }
        }
        this.aliasSelections((SqmQueryPart)queryPart);
        SqmSubQuery subquery = new SqmSubQuery((SqmQuery<?>)copy, queryPart, null, this.nodeBuilder());
        JpaCriteriaQuery query = this.nodeBuilder().createQuery(Boolean.class);
        ((SqmSelectStatement)query).select(this.nodeBuilder().exists(subquery));
        if (subquery.getFetch() == null && subquery.getOffset() == null) {
            ((SqmQueryPart)subquery.getQueryPart()).setOrderByClause(null);
        }
        ((AbstractSqmSelectQuery)((Object)query)).addCteStatements(this.getCteStatementMap());
        return query;
    }

    private <S> void aliasSelections(SqmQueryPart<S> queryPart) {
        if (queryPart.isSimpleQueryPart()) {
            SqmQuerySpec<S> querySpec = queryPart.getFirstQuerySpec();
            LinkedHashSet newSelections = new LinkedHashSet();
            this.aliasSelection(querySpec.getSelection(), newSelections);
            JpaSelection selection = newSelections.size() == 1 ? (JpaSelection)newSelections.iterator().next() : this.nodeBuilder().tuple(newSelections.toArray(new JpaSelection[0]));
            querySpec.setSelection(selection);
        } else {
            ((SqmQueryGroup)queryPart).getQueryParts().forEach(this::aliasSelections);
        }
    }

    private void aliasSelection(JpaSelection<?> selection, LinkedHashSet<JpaSelection<?>> newSelections) {
        if (selection.isCompoundSelection() || selection instanceof SqmDynamicInstantiation) {
            for (JpaSelection<?> selectionItem : selection.getSelectionItems()) {
                this.aliasSelection(selectionItem, newSelections);
            }
        } else if (!newSelections.contains(selection)) {
            newSelections.add((JpaSelection<?>)selection.alias("c" + newSelections.size()));
        }
    }

    @Override
    public String generateAlias() {
        return "var_" + ++this.aliasCounter;
    }
}

