/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.incremental.processing.IncrementalAnnotationProcessorType;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDeclaration;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.api.tasks.WorkResult;
import org.gradle.language.base.internal.compile.Compiler;

public class AnnotationProcessorDiscoveringCompiler<T extends JavaCompileSpec>
implements Compiler<T> {
    private final Compiler<T> delegate;
    private final AnnotationProcessorDetector annotationProcessorDetector;

    public AnnotationProcessorDiscoveringCompiler(Compiler<T> delegate, AnnotationProcessorDetector annotationProcessorDetector) {
        this.delegate = delegate;
        this.annotationProcessorDetector = annotationProcessorDetector;
    }

    public WorkResult execute(T spec) {
        Set<AnnotationProcessorDeclaration> annotationProcessors = this.getEffectiveAnnotationProcessors((JavaCompileSpec)spec);
        spec.setEffectiveAnnotationProcessors(annotationProcessors);
        return this.delegate.execute(spec);
    }

    private Set<AnnotationProcessorDeclaration> getEffectiveAnnotationProcessors(JavaCompileSpec spec) {
        Map<String, AnnotationProcessorDeclaration> declarations = this.annotationProcessorDetector.detectProcessors(spec.getAnnotationProcessorPath());
        List<String> compilerArgs = spec.getCompileOptions().getCompilerArgs();
        int processorIndex = compilerArgs.lastIndexOf("-processor");
        if (processorIndex == -1) {
            return Sets.newLinkedHashSet(declarations.values());
        }
        if (processorIndex == compilerArgs.size() - 1) {
            throw new InvalidUserDataException("No processor specified for compiler argument -processor in requested compiler args: " + Joiner.on((String)" ").join(compilerArgs));
        }
        List explicitProcessors = Splitter.on((char)',').splitToList((CharSequence)compilerArgs.get(processorIndex + 1));
        LinkedHashSet<AnnotationProcessorDeclaration> effectiveProcessors = new LinkedHashSet<AnnotationProcessorDeclaration>();
        for (String explicitProcessor : explicitProcessors) {
            AnnotationProcessorDeclaration declaration = declarations.get(explicitProcessor);
            if (declaration != null) {
                effectiveProcessors.add(declaration);
                continue;
            }
            effectiveProcessors.add(new AnnotationProcessorDeclaration(explicitProcessor, IncrementalAnnotationProcessorType.UNKNOWN));
        }
        return effectiveProcessors;
    }
}

