---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: 'Exposure of confidential secret or token Artifactory Identity Token'
---

## Description

The response body contains content that matches the pattern of an Artifactory Identity Token was identified. An Artifactory Identity Token allows authentication to access repositories, download artifacts, upload artifacts, and execute privileged operations within JFrog Artifactory based on the token's assigned permissions. If leaked, a malicious actor could use this token to steal proprietary code, inject compromised dependencies into the software supply chain, or potentially gain unauthorized access to connected CI/CD systems that rely on Artifactory for builds.
Exposing this value could allow attackers to gain access to all resources granted by this token.

## Remediation

For general guidance on handling security incidents with regards to leaked keys, please see the GitLab documentation on [Credential exposure to the internet](../../../../../security/responding_to_security_incidents.md#credential-exposure-to-public-internet).

## Details

| ID      | Aggregated | CWE | Type | Risk |
|:--------|:-----------|:----|:-----|:-----|
| 798.159 | false | 798 | Passive | High |

## Links

- [CWE](https://cwe.mitre.org/data/definitions/798.html)
