---
stage: Verify
group: Pipeline Execution
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
title: スケジュールされたパイプライン
---

{{< details >}}

- プラン: Free、Premium、Ultimate
- 提供:GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

スケジュールされたパイプラインを使用して、GitLab CI/CD[パイプライン](_index.md)を定期的に実行します。

## 前提要件

スケジュールされたパイプラインを実行するには、次の要件を満たす必要があります。

- スケジュールオーナーには、デベロッパーロールが必要です。保護ブランチのパイプラインの場合、スケジュールオーナーはブランチへの[マージを許可されている](../../user/project/repository/branches/protected.md#add-protection-to-existing-branches)必要があります。
- `.gitlab-ci.yml`ファイルの構文が有効である必要があります。

そうでない場合、パイプラインは作成されません。エラーメッセージは表示されません。

## パイプラインスケジュールを追加する

パイプラインスケジュールを追加するには、次の手順に従います。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **Build > パイプラインスケジュール**を選択します。
1. **新しいスケジュール**を選択し、フォームに入力します。
   - **間隔パターン**: 事前設定された間隔のいずれかを選択するか、[cron形式](../../topics/cron/_index.md)でカスタム間隔を入力します。任意のcron値を使用できますが、スケジュールされたパイプラインは、インスタンスの[スケジュールされたパイプラインの最大頻度](../../administration/cicd/_index.md#change-maximum-scheduled-pipeline-frequency)よりも頻繁には実行できません。
   - **ターゲットブランチまたはタグ**: パイプラインのブランチまたはタグを選択します。
   - **変数**: 任意の数の[CI/CD変数](../variables/_index.md)をスケジュールに追加します。これらの変数は、スケジュールされたパイプラインが実行される場合にのみ使用でき、他のパイプラインの実行では使用できません。

プロジェクトに[パイプラインスケジュールの最大数](../../administration/instance_limits.md#number-of-pipeline-schedules)がすでに存在する場合、未使用のスケジュールを削除してから、別のスケジュールを追加する必要があります。

## パイプラインスケジュールを編集する

パイプラインスケジュールを編集できるのは、パイプラインスケジュールのオーナーです。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **Build > パイプラインスケジュール**を選択します。
1. スケジュールの横にある**編集**（{{< icon name="pencil" >}}）を選択し、フォームに入力します。

ユーザーは、プロジェクトのデベロッパーロール以上を持っている必要があります。ユーザーがスケジュールのオーナーでない場合は、まずスケジュールの[所有権を取得](#take-ownership)する必要があります。

## 手動で実行する

次のスケジュールされた時間ではなく、すぐに実行されるように、パイプラインスケジュールを手動でトリガーするには、次の手順を実行します。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **Build > パイプラインスケジュール**を選択します。
1. リストの右側で、実行するパイプラインの**実行**（{{< icon name="play" >}}）を選択します。

スケジュールされたパイプラインは、1分間に1回手動で実行できます。

スケジュールされたパイプラインを手動で実行すると、パイプラインは、スケジュールオーナーの権限ではなく、トリガーしたユーザーの権限で実行されます。

## 所有権を取得する

スケジュールされたパイプラインは、スケジュールを所有するユーザーの権限で実行されます。パイプラインは、[保護環境](../environments/protected_environments.md)や[CI/CDジョブトークン](../jobs/ci_job_token.md)など、パイプラインオーナーと同じリソースにアクセスできます。

別のユーザーが作成したパイプラインの所有権を取得するには、次の手順を実行します。

1. 左側のサイドバーで、**検索または移動**を選択して、プロジェクトを見つけます。
1. **Build > パイプラインスケジュール**を選択します。
1. リストの右側で、オーナーになるパイプラインの**所有権を取得する**を選択します。

別のユーザーが作成したパイプラインの所有権を取得するには、少なくともメンテナーロールが必要です。

## 関連トピック

- [パイプラインスケジュールAPI](../../api/pipeline_schedules.md)
- [スケジュールされたパイプラインのジョブを実行する](../jobs/job_rules.md#run-jobs-for-scheduled-pipelines)

## トラブルシューティング

パイプラインスケジュールを使用するときに、次の問題が発生する可能性があります。

### 短いrefsが完全なrefsに展開される

APIに短い`ref`を提供すると、完全な`ref`に自動的に展開されます。この動作は意図されたものであり、明示的なリソース識別を保証します。

APIは、短いrefs（`main`など）と完全なrefs（`refs/heads/main`または`refs/tags/main`など）の両方を受け入れます。

### あいまいなrefs

場合によっては、APIは短い`ref`を完全な`ref`に自動的に展開できません。これは、次の場合に発生することがあります。

- 短い`ref`（`main`など）を提供したが、その名前のブランチとタグが両方存在する場合。
- 短い`ref`を提供したが、その名前のブランチまたはタグが存在しない場合。

この問題を解決するには、完全な`ref`を提供して、正しいリソースが識別されるようにします。

### パイプラインスケジュールを表示および最適化する

同時に開始されるパイプラインが多すぎることに起因する[過度の負荷](pipeline_efficiency.md)を防ぐために、パイプラインスケジュールをレビューおよび最適化できます。

存在するすべてのスケジュールの概要を取得し、より均等に分散させる機会を特定するには、次の手順を実行します。

1. 次のコマンドを実行し、スケジュールデータを抽出およびフォーマットします。

   ```shell
   outfile=/tmp/gitlab_ci_schedules.tsv
   sudo gitlab-psql --command "
    COPY (SELECT
        ci_pipeline_schedules.cron,
        projects.path   AS project,
        users.email
    FROM ci_pipeline_schedules
    JOIN projects ON projects.id = ci_pipeline_schedules.project_id
    JOIN users    ON users.id    = ci_pipeline_schedules.owner_id
    ) TO '$outfile' CSV HEADER DELIMITER E'\t' ;"
   sort  "$outfile" | uniq -c | sort -n
   ```

1. 出力をレビューして、よくある`cron`パターンを特定します。たとえば、毎正時に実行するように設定された多数のスケジュール（`0 * * * *`）が表示される場合があります。
1. 特に大規模なリポジトリの場合は、スケジュールを調整して、時間を少しずつずらした[`cron`パターン](../../topics/cron/_index.md#cron-syntax)を作成します。たとえば、毎正時に複数のスケジュールを実行するのではなく、1時間の中で分散させます（`5 * * * *`、`15 * * * *`、`25 * * * *`）。

### スケジュールされたパイプラインが突然無効になる

スケジュールされたパイプラインの状態が予期せず`Inactive`に変更された場合、スケジュールのオーナーがブロックまたは削除されたことが原因である可能性があります。スケジュールの[所有権を取得](#take-ownership)して、変更および有効化します。
