# frozen_string_literal: true

class RemoveMergeRequestsVulnerabilityFeedbackMergeRequestIdFk < Gitlab::Database::Migration[2.2]
  milestone '17.6'
  disable_ddl_transaction!

  FOREIGN_KEY_NAME = "fk_563ff1912e"

  def up
    with_lock_retries do
      remove_foreign_key_if_exists(:vulnerability_feedback, :merge_requests,
        name: FOREIGN_KEY_NAME, reverse_lock_order: true)
    end
  end

  def down
    add_concurrent_foreign_key(:vulnerability_feedback, :merge_requests,
      name: FOREIGN_KEY_NAME, column: :merge_request_id,
      target_column: :id, on_delete: :nullify)
  end
end
