# frozen_string_literal: true

class RemoveClusterAgentsVulnerabilityReadsCastedClusterAgentIdFk < Gitlab::Database::Migration[2.2]
  milestone '17.5'
  disable_ddl_transaction!

  FOREIGN_KEY_NAME = "fk_aee839e611"

  def up
    with_lock_retries do
      remove_foreign_key_if_exists(:vulnerability_reads, :cluster_agents,
        name: FOREIGN_KEY_NAME, reverse_lock_order: true)
    end
  end

  # This migration can only be reverted in the event that the instance database
  # has not conducted a Sec Decomposition. GitLab.com does not run `down` operations.
  #
  # As such, this allow_cross_joins_across_databases call will never be removed.
  def down
    Gitlab::Database.allow_cross_joins_across_databases(
      url: 'https://gitlab.com/gitlab-org/gitlab/-/merge_requests/164505'
    ) do
      add_concurrent_foreign_key(:vulnerability_reads, :cluster_agents,
        name: FOREIGN_KEY_NAME, column: :casted_cluster_agent_id,
        target_column: :id, on_delete: :nullify, reverse_lock_order: true)
    end
  end
end
