/*
 * Decompiled with CFR 0.152.
 */
package org.dpolivaev.mnemonicsetter;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.dpolivaev.mnemonicsetter.INameMnemonicHolder;
import org.dpolivaev.mnemonicsetter.MnemonicMap;

class ItemMnemonicSetter {
    private static final Pattern CAN_HAVE_MNEMONICS = Pattern.compile("\\p{L}");
    private final INameMnemonicHolder[] mnemonicHolders;
    private Collection<Integer> blockedMnemonics;

    static ItemMnemonicSetter of(INameMnemonicHolder ... mnemonicHolders) {
        return ItemMnemonicSetter.of(Arrays.asList(mnemonicHolders));
    }

    static ItemMnemonicSetter of(List<INameMnemonicHolder> mnemonicHolders) {
        ArrayList<INameMnemonicHolder> validHolders = new ArrayList<INameMnemonicHolder>(mnemonicHolders.size());
        for (INameMnemonicHolder holder : mnemonicHolders) {
            if (!ItemMnemonicSetter.canHaveMnemonics(holder)) continue;
            validHolders.add(holder);
        }
        INameMnemonicHolder[] array = validHolders.toArray(new INameMnemonicHolder[validHolders.size()]);
        return new ItemMnemonicSetter(array);
    }

    private static boolean canHaveMnemonics(INameMnemonicHolder holder) {
        String text = holder.getText();
        return text != null && CAN_HAVE_MNEMONICS.matcher(text).find();
    }

    private ItemMnemonicSetter(INameMnemonicHolder[] mnemonicHolders) {
        this.mnemonicHolders = mnemonicHolders;
        this.blockedMnemonics = Collections.emptyList();
    }

    public void setMnemonics() {
        Map<Integer, INameMnemonicHolder> usedMnemonics = this.extractUsedMnemonics(this.mnemonicHolders);
        if (usedMnemonics.size() - this.blockedMnemonics.size() < this.mnemonicHolders.length) {
            Map<Integer, INameMnemonicHolder> mnemonicSet = this.findMnemonics(usedMnemonics, 0, 0);
            this.setMnemonics(mnemonicSet);
        }
    }

    private void setMnemonics(Map<Integer, INameMnemonicHolder> setMnemonics) {
        for (Map.Entry<Integer, INameMnemonicHolder> holderMnemonic : setMnemonics.entrySet()) {
            INameMnemonicHolder target = holderMnemonic.getValue();
            if (target == null) continue;
            target.setMnemonic(holderMnemonic.getKey());
        }
    }

    private Map<Integer, INameMnemonicHolder> findMnemonics(Map<Integer, INameMnemonicHolder> usedMnemonics, int holderIndex, int characterIndex) {
        boolean holderHasNoMnemonics;
        if (holderIndex >= this.mnemonicHolders.length) {
            return usedMnemonics;
        }
        INameMnemonicHolder holder = this.mnemonicHolders[holderIndex];
        boolean bl = holderHasNoMnemonics = !usedMnemonics.containsKey(holder.getMnemonic());
        if (holderHasNoMnemonics) {
            String text = holder.getText();
            if (text.length() > characterIndex) {
                return this.findUnsetMnemonics(usedMnemonics, holderIndex, characterIndex);
            }
            return this.findMnemonics(usedMnemonics, holderIndex + 1, 0);
        }
        return this.findMnemonics(usedMnemonics, holderIndex + 1, 0);
    }

    private Map<Integer, INameMnemonicHolder> findUnsetMnemonics(Map<Integer, INameMnemonicHolder> usedMnemonics, int holderIndex, int characterIndex) {
        INameMnemonicHolder holder = this.mnemonicHolders[holderIndex];
        String text = holder.getText();
        char character = text.charAt(characterIndex);
        int keyCode = KeyEvent.getExtendedKeyCodeForChar(character);
        if (!usedMnemonics.containsKey(keyCode) && Character.isAlphabetic(character) && text.toLowerCase().indexOf(Character.toLowerCase(character)) == characterIndex) {
            MnemonicMap mnemonicsWithNewCharacter = new MnemonicMap((Map<? extends Integer, ? extends INameMnemonicHolder>)usedMnemonics);
            mnemonicsWithNewCharacter.put(keyCode, holder);
            Map<Integer, INameMnemonicHolder> allMnemonics = this.findMnemonics(mnemonicsWithNewCharacter, holderIndex + 1, 0);
            return allMnemonics;
        }
        Map<Integer, INameMnemonicHolder> allMnemonics = this.findMnemonics(usedMnemonics, holderIndex, characterIndex + 1);
        return allMnemonics;
    }

    private Map<Integer, INameMnemonicHolder> extractUsedMnemonics(INameMnemonicHolder ... mnemonicHolders) {
        MnemonicMap usedMnemonics = new MnemonicMap();
        for (Integer blockedMnemonic : this.blockedMnemonics) {
            usedMnemonics.put(blockedMnemonic, null);
        }
        for (INameMnemonicHolder holder : mnemonicHolders) {
            Integer mnemonic = holder.getMnemonic();
            if (mnemonic == 0) continue;
            if (!usedMnemonics.containsKey(mnemonic)) {
                usedMnemonics.put(mnemonic, holder);
                continue;
            }
            holder.setMnemonic(0);
            holder.setDisplayedMnemonicIndex(-1);
        }
        Arrays.sort(mnemonicHolders, new Comparator<INameMnemonicHolder>(){

            @Override
            public int compare(INameMnemonicHolder o1, INameMnemonicHolder o2) {
                boolean o2HasMnemonics;
                boolean o1HasMnemonics = o1.getMnemonic() > 0;
                boolean bl = o2HasMnemonics = o2.getMnemonic() > 0;
                if (o1HasMnemonics) {
                    if (o2HasMnemonics) {
                        return 0;
                    }
                    return -1;
                }
                if (o2HasMnemonics) {
                    return 1;
                }
                boolean o1HasAccelerator = o1.hasAccelerator();
                boolean o2HasAccelerator = o2.hasAccelerator();
                if (o1HasAccelerator && !o2HasAccelerator) {
                    return 1;
                }
                if (!o1HasAccelerator && o2HasAccelerator) {
                    return -1;
                }
                return o1.getText().length() - o2.getText().length();
            }
        });
        return usedMnemonics;
    }

    public ItemMnemonicSetter notUsing(Collection<Integer> blockedMnemonics) {
        this.blockedMnemonics = blockedMnemonics;
        return this;
    }
}

