/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.internalutil;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JPopupMenu;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.internalutil.ButtonInfo;
import net.infonode.docking.properties.WindowTabButtonProperties;
import net.infonode.docking.util.DockingUtil;
import net.infonode.docking.util.ViewMap;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.util.IntList;
import net.infonode.util.Printer;

public class InternalDockingUtil {
    public static final int DEFAULT_BUTTON_ICON_SIZE = 10;

    private InternalDockingUtil() {
    }

    public static void getViews(DockingWindow window, ArrayList views) {
        if (window == null) {
            return;
        }
        if (window instanceof View) {
            views.add(window);
        } else {
            int i = 0;
            while (i < window.getChildWindowCount()) {
                InternalDockingUtil.getViews(window.getChildWindow(i), views);
                ++i;
            }
        }
    }

    public static IntList getWindowPath(DockingWindow window) {
        return InternalDockingUtil.getWindowPath(window, IntList.EMPTY_LIST);
    }

    public static DockingWindow getWindow(DockingWindow relativeToWindow, IntList windowPath) {
        return windowPath.isEmpty() ? relativeToWindow : (windowPath.getValue() >= relativeToWindow.getChildWindowCount() ? null : InternalDockingUtil.getWindow(relativeToWindow.getChildWindow(windowPath.getValue()), windowPath.getNext()));
    }

    private static IntList getWindowPath(DockingWindow window, IntList tail) {
        DockingWindow parent = window.getWindowParent();
        return parent == null ? tail : InternalDockingUtil.getWindowPath(parent, new IntList(parent.getChildWindowIndex(window), tail));
    }

    public static void addDebugMenuItems(JPopupMenu menu, final DockingWindow window) {
        menu.add("Dump Tree").addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InternalDockingUtil.dump(window, new Printer());
            }
        });
    }

    public static void dump(DockingWindow window, Printer printer) {
        DockingWindow parent = window.getWindowParent();
        String clName = window.getClass().getName();
        printer.println(String.valueOf(clName.substring(clName.lastIndexOf(46) + 1)) + ", " + System.identityHashCode(window) + " (" + (parent == null ? "null" : String.valueOf(System.identityHashCode(parent))) + "), '" + window.getTitle() + "', " + (window.isVisible() ? "visible" : "not visible") + ", " + (window.isMaximized() ? "maximized" : "not maximized") + ", " + (window.getChildWindowCount() > 0 ? ":" : ""));
        if (window.getChildWindowCount() > 0) {
            printer.beginSection();
            int i = 0;
            while (i < window.getChildWindowCount()) {
                if (window.getChildWindow(i) == null) {
                    printer.println("null");
                } else {
                    InternalDockingUtil.dump(window.getChildWindow(i), printer);
                }
                ++i;
            }
            printer.endSection();
        }
    }

    public static RootWindow createInnerRootWindow(View[] views) {
        RootWindow rootWindow = DockingUtil.createRootWindow(new ViewMap(views), true);
        rootWindow.getRootWindowProperties().getWindowAreaProperties().setBackgroundColor(null);
        rootWindow.getRootWindowProperties().getWindowAreaShapedPanelProperties().setComponentPainter(null);
        rootWindow.getRootWindowProperties().getComponentProperties().setBackgroundColor(null);
        rootWindow.getRootWindowProperties().getComponentProperties().setBorder(null);
        return rootWindow;
    }

    public static boolean updateButtons(ButtonInfo[] buttonInfos, AbstractButton[] buttons, Container container, DockingWindow window, PropertyMap map, Map changes) {
        boolean updateContainer = false;
        int i = 0;
        while (i < buttonInfos.length) {
            boolean visible;
            WindowTabButtonProperties p = new WindowTabButtonProperties(buttonInfos[i].getProperty().get(map));
            DockingWindowAction action = p.getAction();
            Map propertyChanges = changes == null ? null : (Map)changes.get(p.getMap());
            boolean bl = visible = p.isVisible() && action != null && action.getAction(window).isEnabled();
            if ((buttons[i] == null || propertyChanges != null && propertyChanges.containsKey(WindowTabButtonProperties.FACTORY)) && p.getFactory() != null && action != null) {
                buttons[i] = p.getFactory().createButton(window);
                buttons[i].setFocusable(false);
                buttons[i].addActionListener(action.getAction(window).toSwingAction());
                updateContainer = true;
            }
            if (buttons[i] != null) {
                buttons[i].setToolTipText(p.getToolTipText());
                buttons[i].setIcon(p.getIcon());
                buttons[i].setVisible(visible);
            }
            ++i;
        }
        if (updateContainer && container != null) {
            container.removeAll();
            int j = 0;
            while (j < buttonInfos.length) {
                if (buttons[j] != null) {
                    container.add(buttons[j]);
                }
                ++j;
            }
        }
        return updateContainer;
    }

    public static void addToRootWindow(DockingWindow window, RootWindow rootWindow) {
        if (rootWindow == null) {
            return;
        }
        DockingWindow w = rootWindow.getWindow();
        if (w == null) {
            rootWindow.setWindow(window);
        } else if (w instanceof TabWindow) {
            ((TabWindow)w).addTab(window);
        } else {
            rootWindow.setWindow(new TabWindow(new DockingWindow[]{w, window}));
        }
    }
}

