/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFFileSpec;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFReference;

public class PDFLaunch
extends PDFAction {
    private PDFReference externalFileSpec;
    private boolean newWindow;

    public PDFLaunch(PDFFileSpec fileSpec) {
        this(fileSpec.makeReference());
        this.newWindow = false;
    }

    public PDFLaunch(PDFFileSpec fileSpec, boolean newWindow) {
        this(fileSpec.makeReference());
        this.newWindow = newWindow;
    }

    public PDFLaunch(PDFReference fileSpec) {
        PDFObject fs = fileSpec.getObject();
        if (fs != null) assert (fs instanceof PDFFileSpec);
        this.externalFileSpec = fileSpec;
    }

    @Override
    public String getAction() {
        return this.referencePDF();
    }

    @Override
    public String toPDFString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append("<<\n/S /Launch\n/F ");
        sb.append(this.externalFileSpec.toString());
        if (this.newWindow) {
            sb.append("\n/NewWindow true");
        }
        sb.append("\n>>");
        return sb.toString();
    }

    @Override
    protected boolean contentEquals(PDFObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PDFLaunch)) {
            return false;
        }
        PDFLaunch launch = (PDFLaunch)obj;
        return launch.externalFileSpec.toString().equals(this.externalFileSpec.toString());
    }
}

