/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.filter;

import java.util.List;
import java.util.Objects;
import org.opensearch.client.node.NodeClient;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;

public class DelegatingRestHandler
implements RestHandler {
    protected final RestHandler delegate;

    public DelegatingRestHandler(RestHandler delegate) {
        Objects.requireNonNull(delegate, "RestHandler delegate can not be null");
        this.delegate = delegate;
    }

    public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        this.delegate.handleRequest(request, channel, client);
    }

    public boolean canTripCircuitBreaker() {
        return this.delegate.canTripCircuitBreaker();
    }

    public boolean supportsContentStream() {
        return this.delegate.supportsContentStream();
    }

    public boolean allowsUnsafeBuffers() {
        return this.delegate.allowsUnsafeBuffers();
    }

    public List<RestHandler.Route> routes() {
        return this.delegate.routes();
    }

    public List<RestHandler.DeprecatedRoute> deprecatedRoutes() {
        return this.delegate.deprecatedRoutes();
    }

    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        return this.delegate.replacedRoutes();
    }

    public boolean allowSystemIndexAccessByDefault() {
        return this.delegate.allowSystemIndexAccessByDefault();
    }

    public boolean isActionPaginated() {
        return this.delegate.isActionPaginated();
    }

    public String toString() {
        return this.delegate.toString();
    }

    public boolean supportsStreaming() {
        return this.delegate.supportsStreaming();
    }
}

