/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.IntegerContentCommand;
import com.dickimawbooks.texparserlib.TeXCsRef;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.html.EndElement;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import com.dickimawbooks.texparserlib.html.StartElement;
import com.dickimawbooks.texparserlib.latex.AtGobble;
import com.dickimawbooks.texparserlib.latex.LaTeXGenericCommand;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.TreeGlossEntry;
import com.dickimawbooks.texparserlib.latex.glossaries.TreeSubGlossEntry;
import com.dickimawbooks.texparserlib.latex.latex3.TokenListCommand;
import java.io.IOException;

public class L2HGlsStyleTree
extends ControlSequence {
    protected String styleName;
    protected String cssClass;
    protected boolean hasNavHeader = false;
    protected boolean hasGroupHeadings = false;
    protected boolean showChildName = true;
    protected GlossariesSty sty;
    public static final String LEVEL_CSNAME = "texparser@glstree@level";
    public static final String PENDING_CSNAME = "texparser@glstree@pending";

    public L2HGlsStyleTree(String string, String string2, GlossariesSty glossariesSty) {
        this(string, string2, false, false, glossariesSty);
    }

    public L2HGlsStyleTree(String string, String string2, boolean bl, boolean bl2, GlossariesSty glossariesSty) {
        this(string, string2, bl, bl2, true, glossariesSty);
    }

    public L2HGlsStyleTree(String string, String string2, boolean bl, boolean bl2, boolean bl3, GlossariesSty glossariesSty) {
        this("@glsstyle@" + string, string, string2, bl, bl2, bl3, glossariesSty);
    }

    public L2HGlsStyleTree(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3, GlossariesSty glossariesSty) {
        super(string);
        this.styleName = string2;
        this.cssClass = string3;
        this.hasNavHeader = bl;
        this.hasGroupHeadings = bl2;
        this.showChildName = bl3;
        this.sty = glossariesSty;
    }

    @Override
    public Object clone() {
        return new L2HGlsStyleTree(this.getName(), this.styleName, this.cssClass, this.hasNavHeader, this.hasGroupHeadings, this.showChildName, this.sty);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObjectList teXObjectList2;
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        TeXObjectList teXObjectList3 = l2HConverter.createStack();
        StartElement startElement = new StartElement("dl", true);
        if (this.cssClass != null) {
            startElement.putAttribute("class", this.cssClass + " " + this.styleName);
        } else {
            startElement.putAttribute("class", this.styleName);
        }
        teXObjectList3.add(startElement);
        teXObjectList3.add(new TeXCsRef("tl_clear:N"));
        teXObjectList3.add(new TeXCsRef(PENDING_CSNAME));
        TeXObjectList teXObjectList4 = l2HConverter.createStack();
        teXObjectList4.add(new TeXCsRef(PENDING_CSNAME));
        teXObjectList4.add(new EndElement("dl", true));
        l2HConverter.newenvironment(Overwrite.ALLOW, "renewenvironment", "theglossary", 0, null, teXObjectList3, teXObjectList4);
        if (this.hasNavHeader) {
            teXObjectList2 = l2HConverter.createStack();
            teXObjectList2.add(new TeXCsRef("glstreenavigation"));
            teXObjectList2.add(TeXParserUtils.createGroup(l2HConverter, new TeXCsRef("glsnavigation")));
        } else {
            l2HConverter.putControlSequence(true, new GenericCommand(true, "glossaryheader"));
        }
        if (this.hasGroupHeadings) {
            teXObjectList2 = l2HConverter.createStack();
            startElement = new StartElement("dt");
            startElement.putAttribute("class", "header");
            teXObjectList2.add(startElement);
            teXObjectList2.add(new TeXCsRef("glstreegroupheaderfmt"));
            Group group = l2HConverter.createGroup();
            teXObjectList2.add(group);
            if (this.hasNavHeader) {
                group.add(new TeXCsRef("glsnavhypertarget"));
                group.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(1)));
                Group group2 = l2HConverter.createGroup();
                group.add(group2);
                group = group2;
            }
            group.add(new TeXCsRef("glsgetgrouptitle"));
            group.add(TeXParserUtils.createGroup(l2HConverter, l2HConverter.getParam(1)));
            teXObjectList2.add(new EndElement("dt"));
            l2HConverter.putControlSequence(true, new LaTeXGenericCommand(true, "glsgroupheading", "m", teXObjectList2));
        } else {
            l2HConverter.putControlSequence(true, new AtGobble("glsgroupheading"));
        }
        l2HConverter.putControlSequence(true, new TreeGlossEntry(this));
        l2HConverter.putControlSequence(true, new TreeSubGlossEntry(this));
        teXObjectList2 = l2HConverter.createStack();
        teXObjectList2.add(new TeXCsRef("ifglsnogroupskip"));
        teXObjectList2.add(new TeXCsRef("else"));
        teXObjectList2.add(new TeXCsRef("indexspace"));
        teXObjectList2.add(new TeXCsRef("fi"));
        l2HConverter.putControlSequence(true, new GenericCommand(true, "glsgroupskip", null, teXObjectList2));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public GlossariesSty getGlossariesSty() {
        return this.sty;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public String getCssClass() {
        return this.cssClass;
    }

    public boolean hasNavHeader() {
        return this.hasNavHeader;
    }

    public boolean hasGroupHeadings() {
        return this.hasGroupHeadings;
    }

    public boolean showChildName() {
        return this.showChildName;
    }

    public IntegerContentCommand getLevelCommand() {
        ControlSequence controlSequence = this.sty.getParser().getControlSequence(LEVEL_CSNAME);
        if (controlSequence == null) {
            controlSequence = new IntegerContentCommand(LEVEL_CSNAME, 0);
            this.sty.getParser().putControlSequence(true, controlSequence);
        }
        return (IntegerContentCommand)controlSequence;
    }

    public TokenListCommand getPendingCommand() {
        ControlSequence controlSequence = this.sty.getParser().getControlSequence(PENDING_CSNAME);
        if (controlSequence == null) {
            controlSequence = new TokenListCommand(PENDING_CSNAME);
            this.sty.getParser().putControlSequence(true, controlSequence);
        }
        return (TokenListCommand)controlSequence;
    }
}

