/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.algorithms;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeGraph;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public final class Tarjan {
    private final Map<Long, TarjanHelper> registry;
    private final Map<Node, List<Node>> graphMap;
    private final Collection<List<Node>> scc = new ArrayList<List<Node>>();
    private final Deque<Node> stack = new ArrayDeque<Node>();
    private int index;

    public Tarjan(NodeGraph graph) {
        this.graphMap = graph.createMap();
        this.registry = new HashMap<Long, TarjanHelper>(Utils.hashMapInitialCapacity(graph.getEdges().size()));
    }

    public Collection<List<Node>> getSCC() {
        for (Node node : this.graphMap.keySet()) {
            if (this.registry.containsKey(node.getUniqueId())) continue;
            this.strongConnect(node);
        }
        return this.scc;
    }

    public Map<Node, List<Node>> getGraphMap() {
        return this.graphMap;
    }

    private void strongConnect(Node u0) {
        ArrayDeque<Pair<Node, Integer>> work = new ArrayDeque<Pair<Node, Integer>>();
        work.push(new Pair<Node, Integer>(u0, 0));
        while (!work.isEmpty()) {
            TarjanHelper vHelper;
            Node v;
            Pair popped = (Pair)work.remove();
            Node u = (Node)popped.a;
            int j = (Integer)popped.b;
            if (j == 0) {
                ++this.index;
                this.registry.put(u.getUniqueId(), new TarjanHelper(this.index));
                this.stack.push(u);
            }
            boolean recurse = false;
            List<Node> successors = this.getSuccessors(u);
            for (int i = j; i < successors.size(); ++i) {
                v = successors.get(i);
                if (!this.registry.containsKey(v.getUniqueId())) {
                    work.push(new Pair<Node, Integer>(u, i + 1));
                    work.push(new Pair<Node, Integer>(v, 0));
                    recurse = true;
                    break;
                }
                if (!this.stack.contains(v)) continue;
                TarjanHelper uHelper = this.registry.get(u.getUniqueId());
                vHelper = this.registry.get(v.getUniqueId());
                uHelper.lowlink = Math.min(uHelper.lowlink, vHelper.index);
            }
            if (recurse) continue;
            TarjanHelper uHelper = this.registry.get(u.getUniqueId());
            if (uHelper.lowlink == uHelper.index) {
                Node v2;
                ArrayList<Node> currentSCC = new ArrayList<Node>();
                do {
                    v2 = this.stack.remove();
                    currentSCC.add(v2);
                } while (!v2.equals(u));
                if (currentSCC.size() > 1) {
                    this.scc.add(currentSCC);
                }
            }
            if (work.isEmpty()) continue;
            v = u;
            Pair peeked = (Pair)work.peek();
            u = (Node)peeked.a;
            vHelper = this.registry.get(v.getUniqueId());
            uHelper = this.registry.get(u.getUniqueId());
            uHelper.lowlink = Math.min(uHelper.lowlink, vHelper.lowlink);
        }
    }

    private List<Node> getSuccessors(Node node) {
        return this.graphMap.getOrDefault(node, Collections.emptyList());
    }

    private static final class TarjanHelper {
        private final int index;
        private int lowlink;

        private TarjanHelper(int index) {
            this.index = index;
            this.lowlink = index;
        }
    }
}

