/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.p3order.AbstractBarycenterPortDistributor;
import org.eclipse.elk.alg.layered.p3order.BarycenterHeuristic;
import org.eclipse.elk.alg.layered.p3order.ForsterConstraintResolver;

public class ModelOrderBarycenterHeuristic
extends BarycenterHeuristic {
    private HashMap<LNode, HashSet<LNode>> biggerThan = new HashMap();
    private HashMap<LNode, HashSet<LNode>> smallerThan = new HashMap();

    public ModelOrderBarycenterHeuristic(ForsterConstraintResolver constraintResolver, Random random, AbstractBarycenterPortDistributor portDistributor, LNode[][] graph) {
        super(constraintResolver, random, portDistributor, graph);
        this.barycenterStateComparator = (n1, n2) -> {
            int transitiveComparison = this.compareBasedOnTansitiveDependencies((LNode)n1, (LNode)n2);
            if (transitiveComparison != 0) {
                return transitiveComparison;
            }
            if (n1.hasProperty(InternalProperties.MODEL_ORDER) && n2.hasProperty(InternalProperties.MODEL_ORDER)) {
                int value = Integer.compare(n1.getProperty(InternalProperties.MODEL_ORDER), n2.getProperty(InternalProperties.MODEL_ORDER));
                if (value < 0) {
                    this.updateBiggerAndSmallerAssociations((LNode)n1, (LNode)n2);
                } else if (value > 0) {
                    this.updateBiggerAndSmallerAssociations((LNode)n2, (LNode)n1);
                }
                return value;
            }
            return this.compareBasedOnBarycenter((LNode)n1, (LNode)n2);
        };
    }

    @Override
    public void minimizeCrossings(List<LNode> layer, boolean preOrdered, boolean randomize, boolean forward) {
        if (randomize) {
            this.randomizeBarycenters(layer);
        } else {
            this.calculateBarycenters(layer, forward);
            this.fillInUnknownBarycenters(layer, preOrdered);
        }
        if (layer.size() > 1) {
            if (layer.get(0).getGraph().getProperty(LayeredOptions.CROSSING_MINIMIZATION_FORCE_NODE_MODEL_ORDER).booleanValue()) {
                ModelOrderBarycenterHeuristic.insertionSort(layer, this.barycenterStateComparator, this);
            } else {
                Collections.sort(layer, this.barycenterStateComparator);
            }
            if (!layer.get(0).getGraph().getProperty(LayeredOptions.CROSSING_MINIMIZATION_FORCE_NODE_MODEL_ORDER).booleanValue()) {
                this.constraintResolver.processConstraints(layer);
            }
        }
    }

    private int compareBasedOnTansitiveDependencies(LNode n1, LNode n2) {
        if (!this.biggerThan.containsKey(n1)) {
            this.biggerThan.put(n1, new HashSet());
        } else if (this.biggerThan.get(n1).contains(n2)) {
            return 1;
        }
        if (!this.biggerThan.containsKey(n2)) {
            this.biggerThan.put(n2, new HashSet());
        } else if (this.biggerThan.get(n2).contains(n1)) {
            return -1;
        }
        if (!this.smallerThan.containsKey(n1)) {
            this.smallerThan.put(n1, new HashSet());
        } else if (this.smallerThan.get(n1).contains(n2)) {
            return -1;
        }
        if (!this.smallerThan.containsKey(n2)) {
            this.smallerThan.put(n2, new HashSet());
        } else if (this.smallerThan.get(n2).contains(n1)) {
            return 1;
        }
        return 0;
    }

    private int compareBasedOnBarycenter(LNode n1, LNode n2) {
        BarycenterHeuristic.BarycenterState s1 = this.stateOf(n1);
        BarycenterHeuristic.BarycenterState s2 = this.stateOf(n2);
        if (s1.barycenter != null && s2.barycenter != null) {
            int value = s1.barycenter.compareTo(s2.barycenter);
            if (value < 0) {
                this.updateBiggerAndSmallerAssociations(n1, n2);
            } else if (value > 0) {
                this.updateBiggerAndSmallerAssociations(n2, n1);
            }
            return value;
        }
        if (s1.barycenter != null) {
            this.updateBiggerAndSmallerAssociations(n1, n2);
            return -1;
        }
        if (s2.barycenter != null) {
            this.updateBiggerAndSmallerAssociations(n2, n1);
            return 1;
        }
        return 0;
    }

    private void updateBiggerAndSmallerAssociations(LNode bigger, LNode smaller) {
        HashSet<LNode> biggerNodeBiggerThan = this.biggerThan.get(bigger);
        HashSet<LNode> smallerNodeBiggerThan = this.biggerThan.get(smaller);
        HashSet<LNode> biggerNodeSmallerThan = this.smallerThan.get(bigger);
        HashSet<LNode> smallerNodeSmallerThan = this.smallerThan.get(smaller);
        biggerNodeBiggerThan.add(smaller);
        smallerNodeSmallerThan.add(bigger);
        for (LNode verySmall : smallerNodeBiggerThan) {
            biggerNodeBiggerThan.add(verySmall);
            this.smallerThan.get(verySmall).add(bigger);
            this.smallerThan.get(verySmall).addAll(biggerNodeSmallerThan);
        }
        for (LNode veryBig : biggerNodeSmallerThan) {
            smallerNodeSmallerThan.add(veryBig);
            this.biggerThan.get(veryBig).add(smaller);
            this.biggerThan.get(veryBig).addAll(smallerNodeBiggerThan);
        }
    }

    public static void insertionSort(List<LNode> layer, Comparator<LNode> comparator, ModelOrderBarycenterHeuristic barycenterHeuristic) {
        int i = 1;
        while (i < layer.size()) {
            LNode temp = layer.get(i);
            int j = i;
            while (j > 0 && comparator.compare(layer.get(j - 1), temp) > 0) {
                layer.set(j, layer.get(j - 1));
                --j;
            }
            layer.set(j, temp);
            ++i;
        }
        barycenterHeuristic.clearTransitiveOrdering();
    }

    public void clearTransitiveOrdering() {
        this.biggerThan = new HashMap();
        this.smallerThan = new HashMap();
    }
}

