/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.query;

import java.io.IOException;
import java.util.Arrays;
import lombok.Generated;
import org.apache.lucene.search.Scorable;

public class HybridSubQueryScorer
extends Scorable {
    private final float[] subQueryScores;
    private final float[] minScores;

    public HybridSubQueryScorer(int numOfSubQueries) {
        this.minScores = new float[numOfSubQueries];
        this.subQueryScores = new float[numOfSubQueries];
    }

    public float score() throws IOException {
        float totalScore = 0.0f;
        for (float score : this.subQueryScores) {
            totalScore += score;
        }
        return totalScore;
    }

    public void resetScores() {
        Arrays.fill(this.subQueryScores, 0.0f);
    }

    public int getNumOfSubQueries() {
        return this.subQueryScores.length;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HybridSubQueryScorer)) {
            return false;
        }
        HybridSubQueryScorer other = (HybridSubQueryScorer)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (!Arrays.equals(this.getSubQueryScores(), other.getSubQueryScores())) {
            return false;
        }
        return Arrays.equals(this.getMinScores(), other.getMinScores());
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof HybridSubQueryScorer;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.hashCode(this.getSubQueryScores());
        result = result * 59 + Arrays.hashCode(this.getMinScores());
        return result;
    }

    @Generated
    public float[] getSubQueryScores() {
        return this.subQueryScores;
    }

    @Generated
    public float[] getMinScores() {
        return this.minScores;
    }

    @Generated
    public String toString() {
        return "HybridSubQueryScorer(subQueryScores=" + Arrays.toString(this.getSubQueryScores()) + ", minScores=" + Arrays.toString(this.getMinScores()) + ")";
    }
}

