/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.model.ast.builder;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.jdbc.Expectation;
import org.hibernate.persister.collection.mutation.CollectionTableMapping;
import org.hibernate.sql.model.MutationTarget;
import org.hibernate.sql.model.ast.MutatingTableReference;
import org.hibernate.sql.model.ast.TableDelete;
import org.hibernate.sql.model.ast.builder.TableDeleteBuilderStandard;
import org.hibernate.sql.model.internal.TableDeleteCustomSql;
import org.hibernate.sql.model.internal.TableDeleteStandard;

public class CollectionRowDeleteBuilder
extends TableDeleteBuilderStandard {
    public CollectionRowDeleteBuilder(MutationTarget<?> mutationTarget, MutatingTableReference tableReference, SessionFactoryImplementor sessionFactory, String whereFragment) {
        super(mutationTarget, tableReference, sessionFactory, whereFragment);
        assert (tableReference.getTableMapping() instanceof CollectionTableMapping);
    }

    @Override
    public TableDelete buildMutation() {
        final CollectionTableMapping tableMapping = (CollectionTableMapping)this.getMutatingTable().getTableMapping();
        if (tableMapping.getDeleteRowDetails().getCustomSql() != null) {
            return new TableDeleteCustomSql(this.getMutatingTable(), this.getMutationTarget(), this.getSqlComment(), this.getKeyRestrictionBindings(), this.getOptimisticLockBindings(), this.getParameters()){

                @Override
                public String getCustomSql() {
                    return tableMapping.getDeleteRowDetails().getCustomSql();
                }

                @Override
                public boolean isCallable() {
                    return tableMapping.getDeleteRowDetails().isCallable();
                }

                @Override
                public Expectation getExpectation() {
                    return tableMapping.getDeleteRowDetails().getExpectation();
                }
            };
        }
        return new TableDeleteStandard(this.getMutatingTable(), this.getMutationTarget(), this.getSqlComment(), this.getKeyRestrictionBindings(), this.getOptimisticLockBindings(), this.getParameters(), this.getWhereFragment()){

            @Override
            public Expectation getExpectation() {
                return tableMapping.getDeleteRowDetails().getExpectation();
            }
        };
    }
}

