/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.partialimport;

import java.util.HashSet;
import java.util.Set;
import org.keycloak.partialimport.Action;
import org.keycloak.partialimport.PartialImportResult;

public class PartialImportResults {
    private int overwritten;
    private int added;
    private int skipped;
    private String errorMessage;
    private final Set<PartialImportResult> importResults = new HashSet<PartialImportResult>();

    public void addResult(PartialImportResult result) {
        this.importResults.add(result);
    }

    public void addAllResults(PartialImportResults results) {
        this.importResults.addAll(results.getResults());
    }

    public int getAdded() {
        int added = 0;
        for (PartialImportResult result : this.importResults) {
            if (result.getAction() != Action.ADDED) continue;
            ++added;
        }
        return added;
    }

    public int getOverwritten() {
        int overwritten = 0;
        for (PartialImportResult result : this.importResults) {
            if (result.getAction() != Action.OVERWRITTEN) continue;
            ++overwritten;
        }
        return overwritten;
    }

    public int getSkipped() {
        int skipped = 0;
        for (PartialImportResult result : this.importResults) {
            if (result.getAction() != Action.SKIPPED) continue;
            ++skipped;
        }
        return skipped;
    }

    public Set<PartialImportResult> getResults() {
        return this.importResults;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

