/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.device;

import java.io.IOException;
import java.util.Base64;
import org.keycloak.device.DeviceRepresentationProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.UserSessionModel;
import org.keycloak.representations.account.DeviceRepresentation;
import org.keycloak.util.JsonSerialization;

public class DeviceActivityManager {
    private static final String DEVICE_NOTE = "KC_DEVICE_NOTE";

    public static DeviceRepresentation getCurrentDevice(UserSessionModel userSession) {
        String deviceInfo = userSession.getNote(DEVICE_NOTE);
        if (deviceInfo == null) {
            return null;
        }
        try {
            return (DeviceRepresentation)JsonSerialization.readValue((byte[])Base64.getMimeDecoder().decode(deviceInfo), DeviceRepresentation.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void attachDevice(UserSessionModel userSession, KeycloakSession session) {
        DeviceRepresentation current = ((DeviceRepresentationProvider)session.getProvider(DeviceRepresentationProvider.class)).deviceRepresentation();
        if (current != null) {
            try {
                userSession.setNote(DEVICE_NOTE, Base64.getEncoder().encodeToString(JsonSerialization.writeValueAsBytes((Object)current)));
            }
            catch (IOException cause) {
                throw new RuntimeException(cause);
            }
        }
    }
}

