/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.assistant.runtime.dev;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;

public interface Assistant {
    public boolean isAvailable();

    public <T> CompletionStage<T> exception(Optional<String> var1, String var2, String var3, Path var4);

    public <T> CompletionStage<T> assist(Optional<String> var1, String var2, Map<String, String> var3, List<Path> var4);

    default public ExceptionBuilder exceptionBuilder() {
        return new ExceptionBuilder(this);
    }

    default public AssistBuilder assistBuilder() {
        return new AssistBuilder(this);
    }

    public static class ExceptionBuilder {
        private final Assistant assistant;
        private Optional<String> systemMessage = Optional.empty();
        private String userMessage;
        private String stacktrace;
        private Path path;

        ExceptionBuilder(Assistant assistant) {
            this.assistant = assistant;
        }

        public ExceptionBuilder systemMessage(String systemMessage) {
            this.systemMessage = Optional.ofNullable(systemMessage);
            return this;
        }

        public ExceptionBuilder userMessage(String userMessage) {
            this.userMessage = userMessage;
            return this;
        }

        public ExceptionBuilder stacktrace(String stacktrace) {
            this.stacktrace = stacktrace;
            return this;
        }

        public ExceptionBuilder path(Path path) {
            this.path = path;
            return this;
        }

        public <T> CompletionStage<T> explain() {
            if (this.userMessage == null || this.stacktrace == null || this.path == null) {
                throw new IllegalStateException("userMessage, stacktrace, and path must be provided");
            }
            return this.assistant.exception(this.systemMessage, this.userMessage, this.stacktrace, this.path);
        }
    }

    public static class AssistBuilder {
        private final Assistant assistant;
        private Optional<String> systemMessage = Optional.empty();
        private String userMessage;
        private final Map<String, String> variables = new LinkedHashMap<String, String>();
        private final List<Path> paths = new ArrayList<Path>();

        AssistBuilder(Assistant assistant) {
            this.assistant = assistant;
        }

        public AssistBuilder systemMessage(String systemMessage) {
            this.systemMessage = Optional.ofNullable(systemMessage);
            return this;
        }

        public AssistBuilder userMessage(String userMessage) {
            this.userMessage = userMessage;
            return this;
        }

        public AssistBuilder variables(Map<String, String> variables) {
            if (variables != null) {
                this.variables.putAll(variables);
            }
            return this;
        }

        public AssistBuilder addVariable(String key, String value) {
            if (key != null && value != null) {
                this.variables.put(key, value);
            }
            return this;
        }

        public AssistBuilder paths(List<Path> paths) {
            if (paths != null) {
                this.paths.addAll(paths);
            }
            return this;
        }

        public AssistBuilder addPath(Path path) {
            if (path != null) {
                this.paths.add(path);
            }
            return this;
        }

        public <T> CompletionStage<T> assist() {
            if (this.userMessage == null || this.userMessage.isBlank()) {
                throw new IllegalStateException("User message is required");
            }
            return this.assistant.assist(this.systemMessage, this.userMessage, this.variables, this.paths);
        }
    }
}

