/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.diagnostics.SimpleDiagnostic;
import org.jetbrains.kotlin.diagnostics.UnboundDiagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.quickfix.AddModifierFix;
import org.jetbrains.kotlin.idea.quickfix.KotlinSingleIntentionActionFactory;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0014\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/AddLateinitFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinSingleIntentionActionFactory;", "<init>", "()V", "createAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "kotlin.idea"})
public final class AddLateinitFactory
extends KotlinSingleIntentionActionFactory {
    @NotNull
    public static final AddLateinitFactory INSTANCE = new AddLateinitFactory();

    private AddLateinitFactory() {
    }

    @Override
    @Nullable
    protected IntentionAction createAction(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement = ((SimpleDiagnostic)Errors.MUST_BE_INITIALIZED_OR_BE_ABSTRACT.cast((UnboundDiagnostic)diagnostic)).getPsiElement();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"<get-psiElement>(...)");
        KtProperty property = (KtProperty)psiElement;
        if (!property.isVar()) {
            return null;
        }
        VariableDescriptor variableDescriptor = ResolutionUtils.resolveToDescriptorIfAny(property, BodyResolveMode.FULL);
        if (variableDescriptor == null) {
            return null;
        }
        VariableDescriptor descriptor2 = variableDescriptor;
        PropertyDescriptor propertyDescriptor = descriptor2 instanceof PropertyDescriptor ? (PropertyDescriptor)descriptor2 : null;
        if (propertyDescriptor == null || (propertyDescriptor = propertyDescriptor.getType()) == null) {
            return null;
        }
        PropertyDescriptor type2 = propertyDescriptor;
        if (TypeUtils.isNullableType((KotlinType)type2)) {
            return null;
        }
        if (KotlinBuiltIns.isPrimitiveType((KotlinType)type2)) {
            return null;
        }
        KtModifierListOwner ktModifierListOwner = (KtModifierListOwner)property;
        KtModifierKeywordToken ktModifierKeywordToken = KtTokens.LATEINIT_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktModifierKeywordToken, (String)"LATEINIT_KEYWORD");
        return new AddModifierFix(ktModifierListOwner, ktModifierKeywordToken).asIntention();
    }
}

