/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.indices.MavenArtifactSearchDialog;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.utils.MavenArtifactScope;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.base.projectStructure.KotlinProjectStructureUtils;
import org.jetbrains.kotlin.idea.maven.KotlinMavenBundle;
import org.jetbrains.kotlin.idea.maven.PomFile;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\f\u001a\u00020\u0004H\u0016J\b\u0010\r\u001a\u00020\u0004H\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/maven/inspections/AddMavenDependencyQuickFix;", "Lcom/intellij/codeInsight/intention/IntentionAction;", "Lcom/intellij/codeInsight/intention/LowPriorityAction;", "className", "", "smartPsiElementPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lorg/jetbrains/kotlin/psi/KtSimpleNameExpression;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/SmartPsiElementPointer;)V", "getClassName", "()Ljava/lang/String;", "getText", "getFamilyName", "startInWriteAction", "", "isAvailable", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "invoke", "", "intellij.kotlin.maven"})
@SourceDebugExtension(value={"SMAP\nKotlinMavenUnresolvedReferenceQuickFixProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinMavenUnresolvedReferenceQuickFixProvider.kt\norg/jetbrains/kotlin/idea/maven/inspections/AddMavenDependencyQuickFix\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,105:1\n1#2:106\n1869#3,2:107\n*S KotlinDebug\n*F\n+ 1 KotlinMavenUnresolvedReferenceQuickFixProvider.kt\norg/jetbrains/kotlin/idea/maven/inspections/AddMavenDependencyQuickFix\n*L\n97#1:107,2\n*E\n"})
public final class AddMavenDependencyQuickFix
implements IntentionAction,
LowPriorityAction {
    @NotNull
    private final String className;
    @NotNull
    private final SmartPsiElementPointer<KtSimpleNameExpression> smartPsiElementPointer;

    public AddMavenDependencyQuickFix(@NotNull String className, @NotNull SmartPsiElementPointer<KtSimpleNameExpression> smartPsiElementPointer) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter(smartPsiElementPointer, (String)"smartPsiElementPointer");
        this.className = className;
        this.smartPsiElementPointer = smartPsiElementPointer;
    }

    @NotNull
    public final String getClassName() {
        return this.className;
    }

    @NotNull
    public String getText() {
        return KotlinMavenBundle.message("fix.add.maven.dependency.name", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean startInWriteAction() {
        return false;
    }

    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        KtSimpleNameExpression it = (KtSimpleNameExpression)this.smartPsiElementPointer.getElement();
        boolean bl = false;
        return it != null && it.isValid() && file != null && MavenDomUtil.findContainingProject((PsiElement)((PsiElement)file)) != null;
    }

    public void invoke(@NotNull Project project, @Nullable Editor editor, @Nullable PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (editor == null || file == null) {
            return;
        }
        VirtualFile virtualFile = file.getOriginalFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        MavenProject mavenProject = MavenDomUtil.findContainingProject((PsiElement)((PsiElement)file));
        if (mavenProject == null) {
            return;
        }
        MavenProject mavenProject2 = mavenProject;
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(mavenProject2.getFile());
        XmlFile xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
        if (xmlFile == null) {
            return;
        }
        XmlFile xmlFile2 = xmlFile;
        List list2 = MavenArtifactSearchDialog.searchForClass((Project)project, (String)this.className);
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"searchForClass(...)");
        List ids = list2;
        if (ids.isEmpty()) {
            return;
        }
        ActionsKt.runWriteAction(() -> AddMavenDependencyQuickFix.invoke$lambda$0(project, virtualFile2, xmlFile2, ids));
    }

    private static final Unit invoke$lambda$0(Project $project, VirtualFile $virtualFile, XmlFile $xmlFile, List $ids) {
        Unit unit;
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)$project).getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getFileIndex(...)");
        ProjectFileIndex fileIndex = projectFileIndex;
        boolean isTestSource = Intrinsics.areEqual((Object)KotlinProjectStructureUtils.getKotlinSourceRootType(fileIndex, $virtualFile), (Object)TestSourceKotlinRootType.INSTANCE);
        MavenArtifactScope scope = isTestSource ? MavenArtifactScope.TEST : null;
        PomFile pomFile = PomFile.Companion.forFileOrNull($xmlFile);
        if (pomFile != null) {
            PomFile pom = pomFile;
            boolean bl = false;
            Iterable $this$forEach$iv = $ids;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                MavenId it = (MavenId)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it);
                PomFile.addDependency$default(pom, it, scope, null, false, null, 28, null);
            }
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit;
    }
}

