/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.checkers.extra;

import com.intellij.lang.LighterASTNode;
import com.intellij.util.diff.FlyweightCapableTreeStructure;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKind;
import org.jetbrains.kotlin.contracts.description.EventOccurrencesRangeKt;
import org.jetbrains.kotlin.contracts.description.MarkedEventOccurrencesRange;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticFactory0;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.cfa.AbstractFirPropertyInitializationChecker;
import org.jetbrains.kotlin.fir.analysis.cfa.FirPropertyInitializationAnalyzerKt;
import org.jetbrains.kotlin.fir.analysis.cfa.util.VariableInitializationInfoData;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.diagnostics.FirErrors;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.CFGNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraph;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphVisitorVoid;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableAssignmentNode;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.VariableDeclarationNode;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.util.LightTreeUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\rB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u00020\u0006R\u00020\bj\u0006\u0010\u0007\u001a\u00020\u0006j\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\f\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/CanBeValChecker;", "Lorg/jetbrains/kotlin/fir/analysis/cfa/AbstractFirPropertyInitializationChecker;", "<init>", "()V", "analyze", "", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "(Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;)V", "ReassignedVariableCollector", "checkers"})
@SourceDebugExtension(value={"SMAP\nCanBeValChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/CanBeValChecker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirSymbolStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirSymbolStatusUtilsKt\n*L\n1#1,86:1\n1#2:87\n1834#3,4:88\n1849#3,3:92\n37#4:95\n*S KotlinDebug\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/CanBeValChecker\n*L\n38#1:88,4\n42#1:92,3\n49#1:95\n*E\n"})
public final class CanBeValChecker
extends AbstractFirPropertyInitializationChecker {
    @NotNull
    public static final CanBeValChecker INSTANCE = new CanBeValChecker();

    private CanBeValChecker() {
        super(MppCheckerKind.Common);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void analyze(@NotNull DiagnosticReporter reporter, @NotNull CheckerContext context2, @NotNull VariableInitializationInfoData data) {
        Iterator<FirVariableSymbol<?>> iterator2;
        ReassignedVariableCollector reassignedVariableCollector;
        Intrinsics.checkNotNullParameter((Object)reporter, (String)"reporter");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        boolean isForInitialization = data.getGraph().getKind() == ControlFlowGraph.Kind.Class || data.getGraph().getKind() == ControlFlowGraph.Kind.File;
        ReassignedVariableCollector $this$analyze_u24lambda_u240 = reassignedVariableCollector = new ReassignedVariableCollector(data, isForInitialization);
        boolean bl = false;
        data.getGraph().traverse($this$analyze_u24lambda_u240);
        ReassignedVariableCollector collector2 = reassignedVariableCollector;
        Iterator<FirVariableSymbol<?>> iterator3 = iterator2 = data.getProperties().iterator();
        while (iterator3.hasNext()) {
            KtDiagnosticFactory0 ktDiagnosticFactory0;
            boolean canBeVal;
            boolean bl2;
            KtSourceElement source;
            FirVariableSymbol<?> symbol = iterator3.next();
            if (symbol.getSource() == null) continue;
            if (Intrinsics.areEqual((Object)source.getElementType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION)) {
                void $this$fold$iv;
                int n;
                Iterable $this$count$iv = LightTreeUtilsKt.getChildren((LighterASTNode)source.getLighterASTNode(), (FlyweightCapableTreeStructure)source.getTreeStructure());
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        LighterASTNode it = (LighterASTNode)element$iv;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual((Object)it.getTokenType(), (Object)KtNodeTypes.DESTRUCTURING_DECLARATION_ENTRY) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int count = n;
                $this$count$iv = (Iterable)RangesKt.until((int)0, (int)count);
                boolean initial$iv = true;
                boolean $i$f$fold = false;
                boolean accumulator$iv = initial$iv;
                Iterator iterator4 = $this$fold$iv.iterator();
                while (iterator4.hasNext()) {
                    int element$iv = ((IntIterator)iterator4).nextInt();
                    boolean acc = accumulator$iv;
                    boolean bl4 = false;
                    accumulator$iv = iterator2.hasNext() && collector2.canBeVal(iterator2.next()) && acc;
                }
                bl2 = accumulator$iv;
            } else {
                bl2 = collector2.canBeVal(symbol);
            }
            if (!(canBeVal = bl2)) continue;
            if (symbol instanceof FirPropertySymbol && !FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)symbol, isForInitialization)) {
                ktDiagnosticFactory0 = FirErrors.INSTANCE.getCAN_BE_VAL();
            } else {
                FirCallableSymbol $this$isLateInit$iv = symbol;
                boolean $i$f$isLateInit = false;
                ktDiagnosticFactory0 = $this$isLateInit$iv.getRawStatus().isLateInit() ? FirErrors.INSTANCE.getCAN_BE_VAL_LATEINIT() : FirErrors.INSTANCE.getCAN_BE_VAL_DELAYED_INITIALIZATION();
            }
            KtDiagnosticFactory0 diagnostic = ktDiagnosticFactory0;
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, (DiagnosticReporter)reporter, (AbstractKtSourceElement)((AbstractKtSourceElement)source), (KtDiagnosticFactory0)diagnostic, null, (int)8, null);
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u00020\u00052\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/checkers/extra/CanBeValChecker$ReassignedVariableCollector;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraphVisitorVoid;", "data", "Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;", "isForInitialization", "", "<init>", "(Lorg/jetbrains/kotlin/fir/analysis/cfa/util/VariableInitializationInfoData;Z)V", "declaredIn", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/ControlFlowGraph;", "Lkotlin/collections/HashMap;", "reassigned", "", "visitNode", "", "node", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/CFGNode;", "visitVariableDeclarationNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableDeclarationNode;", "visitVariableAssignmentNode", "Lorg/jetbrains/kotlin/fir/resolve/dfa/cfg/VariableAssignmentNode;", "canBeVal", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "checkers"})
    @SourceDebugExtension(value={"SMAP\nCanBeValChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/CanBeValChecker$ReassignedVariableCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,86:1\n1807#2,3:87\n*S KotlinDebug\n*F\n+ 1 CanBeValChecker.kt\norg/jetbrains/kotlin/fir/analysis/checkers/extra/CanBeValChecker$ReassignedVariableCollector\n*L\n74#1:87,3\n*E\n"})
    private static final class ReassignedVariableCollector
    extends ControlFlowGraphVisitorVoid {
        @NotNull
        private final VariableInitializationInfoData data;
        private final boolean isForInitialization;
        @NotNull
        private final HashMap<FirPropertySymbol, ControlFlowGraph> declaredIn;
        @NotNull
        private final Set<FirPropertySymbol> reassigned;

        public ReassignedVariableCollector(@NotNull VariableInitializationInfoData data, boolean isForInitialization) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.data = data;
            this.isForInitialization = isForInitialization;
            this.declaredIn = new HashMap();
            this.reassigned = new LinkedHashSet();
        }

        @Override
        public void visitNode(@NotNull CFGNode<?> node) {
            Intrinsics.checkNotNullParameter(node, (String)"node");
        }

        @Override
        public void visitVariableDeclarationNode(@NotNull VariableDeclarationNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            ((Map)this.declaredIn).put(node.getFir().getSymbol(), FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner()));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void visitVariableAssignmentNode(@NotNull VariableAssignmentNode node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            FirReference firReference = ReferenceUtilsKt.getCalleeReference(node.getFir());
            Object object = firReference;
            if (firReference == null) return;
            if ((object = FirReferenceUtilsKt.toResolvedPropertySymbol$default((FirReference)object, false, 1, null)) == null) {
                return;
            }
            Object symbol = object;
            if (!((FirVariableSymbol)symbol).isVar()) return;
            KtSourceElement ktSourceElement = ((FirBasedSymbol)symbol).getSource();
            if ((ktSourceElement != null ? ktSourceElement.getKind() : null) instanceof KtFakeSourceElementKind) return;
            if (!this.data.getProperties().contains(symbol)) return;
            if (FirPropertyInitializationAnalyzerKt.requiresInitialization((FirPropertySymbol)symbol, this.isForInitialization)) {
                boolean bl;
                block6: {
                    Iterable $this$any$iv = this.data.getValue(node).values();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            PersistentMap it = (PersistentMap)element$iv;
                            boolean bl2 = false;
                            MarkedEventOccurrencesRange<CFGNode<?>> markedEventOccurrencesRange = (MarkedEventOccurrencesRange<CFGNode<?>>)it.get(symbol);
                            boolean bl3 = markedEventOccurrencesRange != null && (markedEventOccurrencesRange = markedEventOccurrencesRange.getRange()) != null ? EventOccurrencesRangeKt.canBeRevisited(markedEventOccurrencesRange) : false;
                            if (!bl3) continue;
                            bl = true;
                            break block6;
                        }
                        bl = false;
                    }
                }
                if (!bl) {
                    if (Intrinsics.areEqual((Object)this.declaredIn.get(symbol), (Object)FirPropertyInitializationAnalyzerKt.nearestNonInPlaceGraph(node.getOwner()))) return;
                }
            }
            boolean bl = true;
            boolean isReassigned = bl;
            if (!isReassigned) return;
            this.reassigned.add((FirPropertySymbol)symbol);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean canBeVal(@NotNull FirVariableSymbol<?> symbol) {
            Intrinsics.checkNotNullParameter(symbol, (String)"symbol");
            if (!(symbol instanceof FirPropertySymbol)) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            if (!((FirPropertySymbol)symbol).isVar()) return false;
            if (((FirPropertySymbol)symbol).getHasDelegate()) return false;
            KtSourceElement ktSourceElement = ((FirPropertySymbol)symbol).getSource();
            if (ktSourceElement == null) return false;
            KtSourceElementKind ktSourceElementKind = ktSourceElement.getKind();
            if (ktSourceElementKind == null) {
                return false;
            }
            boolean bl = ktSourceElementKind instanceof KtFakeSourceElementKind;
            if (bl) return false;
            if (this.reassigned.contains(symbol)) return false;
            return true;
        }
    }
}

