/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonFileType;
import com.intellij.json.json5.Json5FileType;
import com.intellij.json.syntax.JsonSyntaxElementTypes;
import com.intellij.json.syntax.JsonSyntaxLexer;
import com.intellij.json.syntax.json5.Json5SyntaxLexer;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.syntax.SyntaxElementType;
import com.intellij.platform.syntax.element.SyntaxTokenTypes;
import com.intellij.platform.syntax.lexer.Lexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.hints.FileTypeInputFilterPredicate;
import com.intellij.util.indexing.hints.FileTypeSubstitutionStrategy;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JsonSchemaFileValuesIndex
extends FileBasedIndexExtension<String, String> {
    public static final ID<String, String> INDEX_ID = ID.create((String)"json.file.root.values");
    private static final int VERSION = 5;
    public static final String NULL = "$NULL$";
    public static final String SCHEMA_PROPERTY_NAME = "$schema";
    private final DataIndexer<String, String, FileContent> myIndexer = new DataIndexer<String, String, FileContent>(this){

        @NotNull
        public Map<String, String> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                1.$$$reportNull$$$0(0);
            }
            Map<String, String> map = JsonSchemaFileValuesIndex.readTopLevelProps(inputData.getFileType(), inputData.getContentAsText());
            if (map == null) {
                1.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaFileValuesIndex$1";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaFileValuesIndex$1";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    };

    @NotNull
    public ID<String, String> getName() {
        ID<String, String> iD = INDEX_ID;
        if (iD == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    @NotNull
    public DataIndexer<String, String, FileContent> getIndexer() {
        DataIndexer<String, String, FileContent> dataIndexer = this.myIndexer;
        if (dataIndexer == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<String> getValueExternalizer() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(3);
        }
        return enumeratorStringDescriptor;
    }

    public int getVersion() {
        return 5;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new FileTypeInputFilterPredicate(FileTypeSubstitutionStrategy.BEFORE_SUBSTITUTION, fileType -> fileType instanceof JsonFileType);
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @Nullable
    public static String getCachedValue(Project project, VirtualFile file, String requestedKey) {
        if (project.isDisposed() || !file.isValid() || DumbService.isDumb((Project)project)) {
            return NULL;
        }
        return (String)FileBasedIndex.getInstance().getFileData(INDEX_ID, file, project).get(requestedKey);
    }

    @NotNull
    static Map<String, String> readTopLevelProps(@NotNull FileType fileType, @NotNull CharSequence content) {
        if (fileType == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(4);
        }
        if (content == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(5);
        }
        if (!(fileType instanceof JsonFileType)) {
            return new HashMap<String, String>();
        }
        Json5SyntaxLexer lexer = fileType == Json5FileType.INSTANCE ? new Json5SyntaxLexer() : new JsonSyntaxLexer();
        HashMap<String, String> map = new HashMap<String, String>();
        lexer.start(content);
        int nesting = 0;
        boolean idFound = false;
        boolean obsoleteIdFound = false;
        boolean schemaFound = false;
        while (!(idFound && schemaFound && obsoleteIdFound || lexer.getTokenStart() >= lexer.getBufferEnd())) {
            SyntaxElementType token = lexer.getTokenType();
            if (token == JsonSyntaxElementTypes.L_CURLY) {
                ++nesting;
            } else if (token == JsonSyntaxElementTypes.R_CURLY) {
                --nesting;
            } else if (nesting == 1 && (token == JsonSyntaxElementTypes.DOUBLE_QUOTED_STRING || token == JsonSyntaxElementTypes.SINGLE_QUOTED_STRING || token == JsonSyntaxElementTypes.IDENTIFIER)) {
                switch (lexer.getTokenText()) {
                    case "$id": 
                    case "\"$id\"": 
                    case "'$id'": {
                        idFound |= JsonSchemaFileValuesIndex.captureValueIfString((Lexer)lexer, map, "JsonSchemaIdCache");
                        break;
                    }
                    case "id": 
                    case "\"id\"": 
                    case "'id'": {
                        obsoleteIdFound |= JsonSchemaFileValuesIndex.captureValueIfString((Lexer)lexer, map, "JsonSchemaObsoleteIdCache");
                        break;
                    }
                    case "$schema": 
                    case "\"$schema\"": 
                    case "'$schema'": {
                        schemaFound |= JsonSchemaFileValuesIndex.captureValueIfString((Lexer)lexer, map, "JsonSchemaUrlCache");
                    }
                }
            }
            lexer.advance();
        }
        if (!map.containsKey("JsonSchemaIdCache")) {
            map.put("JsonSchemaIdCache", NULL);
        }
        if (!map.containsKey("JsonSchemaObsoleteIdCache")) {
            map.put("JsonSchemaObsoleteIdCache", NULL);
        }
        if (!map.containsKey("JsonSchemaUrlCache")) {
            map.put("JsonSchemaUrlCache", NULL);
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    private static boolean captureValueIfString(@NotNull Lexer lexer, @NotNull HashMap<String, String> destMap, @NotNull String key) {
        if (lexer == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(7);
        }
        if (destMap == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(8);
        }
        if (key == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(9);
        }
        lexer.advance();
        SyntaxElementType token = JsonSchemaFileValuesIndex.skipWhitespacesAndGetTokenType(lexer);
        if (token == JsonSyntaxElementTypes.COLON) {
            lexer.advance();
            token = JsonSchemaFileValuesIndex.skipWhitespacesAndGetTokenType(lexer);
            if (token == JsonSyntaxElementTypes.DOUBLE_QUOTED_STRING || token == JsonSyntaxElementTypes.SINGLE_QUOTED_STRING) {
                String text = lexer.getTokenText();
                destMap.put(key, text.length() <= 1 ? "" : text.substring(1, text.length() - 1));
                return true;
            }
        }
        return false;
    }

    @Nullable
    private static SyntaxElementType skipWhitespacesAndGetTokenType(@NotNull Lexer lexer) {
        if (lexer == null) {
            JsonSchemaFileValuesIndex.$$$reportNull$$$0(10);
        }
        while (lexer.getTokenType() == SyntaxTokenTypes.getWHITE_SPACE() || lexer.getTokenType() == JsonSyntaxElementTypes.LINE_COMMENT || lexer.getTokenType() == JsonSyntaxElementTypes.BLOCK_COMMENT) {
            lexer.advance();
        }
        return lexer.getTokenType();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 5, 7, 8, 9, 10 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaFileValuesIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lexer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "destMap";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaFileValuesIndex";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "readTopLevelProps";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "readTopLevelProps";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "captureValueIfString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "skipWhitespacesAndGetTokenType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 5, 7, 8, 9, 10 -> new IllegalArgumentException(string);
        };
    }
}

