/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.jvm.JvmTestSuite;
import org.gradle.api.plugins.jvm.internal.DefaultJvmTestSuite;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.testing.AbstractTestTask;
import org.gradle.api.tasks.testing.Test;
import org.gradle.testing.base.TestingExtension;
import org.gradle.testing.base.plugins.TestSuiteBasePlugin;

@Incubating
public abstract class JvmTestSuitePlugin
implements Plugin<Project> {
    public static final String DEFAULT_TEST_SUITE_NAME = "test";

    public void apply(Project project) {
        project.getPluginManager().apply(TestSuiteBasePlugin.class);
        project.getPluginManager().apply(JavaBasePlugin.class);
        JavaPluginExtension java = (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
        project.getTasks().withType(Test.class).configureEach(test -> test.getModularity().getInferModulePath().convention((Provider)java.getModularity().getInferModulePath()));
        TestingExtension testing = (TestingExtension)project.getExtensions().getByType(TestingExtension.class);
        testing.getSuites().registerBinding(JvmTestSuite.class, DefaultJvmTestSuite.class);
        testing.getSuites().withType(JvmTestSuite.class).all(testSuite -> testSuite.getTargets().all(target -> {
            target.getTestTask().configure(test -> {
                test.getConventionMapping().map("testClassesDirs", () -> testSuite.getSources().getOutput().getClassesDirs());
                test.getConventionMapping().map("classpath", () -> testSuite.getSources().getRuntimeClasspath());
            });
            target.getBinaryResultsDirectory().convention(target.getTestTask().flatMap(AbstractTestTask::getBinaryResultsDirectory));
        }));
    }
}

