/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPEventProducer;
import org.apache.fop.afp.AFPResourceLevel;
import org.apache.fop.afp.AFPResourceLevelDefaults;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.render.RendererConfig;
import org.apache.fop.render.afp.AFPFontConfig;
import org.apache.fop.render.afp.AFPRendererOption;
import org.apache.fop.render.afp.AFPShadingMode;
import org.apache.fop.util.LogUtil;

public final class AFPRendererConfig
implements RendererConfig {
    private final EnumMap<AFPRendererOption, Object> params = new EnumMap(AFPRendererOption.class);
    private final EnumMap<ImagesModeOptions, Object> imageModeParams = new EnumMap(ImagesModeOptions.class);
    private final AFPFontConfig fontConfig;

    private AFPRendererConfig(AFPFontConfig fontConfig) {
        this.fontConfig = fontConfig;
    }

    @Override
    public AFPFontConfig getFontInfoConfig() {
        return this.fontConfig;
    }

    public Boolean isColorImages() {
        return this.getParam(AFPRendererOption.IMAGES_MODE, Boolean.class);
    }

    public Boolean isCmykImagesSupported() {
        if (!this.isColorImages().booleanValue()) {
            throw new IllegalStateException();
        }
        return (Boolean)Boolean.class.cast(this.imageModeParams.get((Object)ImagesModeOptions.MODE_COLOR));
    }

    public Integer getBitsPerPixel() {
        if (this.isColorImages().booleanValue()) {
            throw new IllegalStateException();
        }
        return (Integer)Integer.class.cast(this.imageModeParams.get((Object)ImagesModeOptions.MODE_GRAYSCALE));
    }

    public Float getDitheringQuality() {
        return this.getParam(AFPRendererOption.IMAGES_DITHERING_QUALITY, Float.class);
    }

    public Boolean isNativeImagesSupported() {
        return this.getParam(AFPRendererOption.IMAGES_NATIVE, Boolean.class);
    }

    public Boolean isNativePDFImagesSupported() {
        return this.getParam(AFPRendererOption.IMAGES_NATIVE_PDF, Boolean.class);
    }

    public AFPShadingMode getShadingMode() {
        return this.getParam(AFPRendererOption.SHADING, AFPShadingMode.class);
    }

    public Integer getResolution() {
        return this.getParam(AFPRendererOption.RENDERER_RESOLUTION, Integer.class);
    }

    public URI getDefaultResourceGroupUri() {
        return this.getParam(AFPRendererOption.RESOURCE_GROUP_URI, URI.class);
    }

    public AFPResourceLevelDefaults getResourceLevelDefaults() {
        return this.getParam(AFPRendererOption.DEFAULT_RESOURCE_LEVELS, AFPResourceLevelDefaults.class);
    }

    public Boolean isWrapPseg() {
        return this.getParam(AFPRendererOption.IMAGES_WRAP_PSEG, Boolean.class);
    }

    public Boolean isGocaWrapPseg() {
        return this.getParam(AFPRendererOption.GOCA_WRAP_PSEG, Boolean.class);
    }

    public Boolean isFs45() {
        return this.getParam(AFPRendererOption.IMAGES_FS45, Boolean.class);
    }

    public Boolean isMaskEnabled() {
        return this.getParam(AFPRendererOption.IMAGES_MASK_ENABLED, Boolean.class);
    }

    public Boolean allowJpegEmbedding() {
        return this.getParam(AFPRendererOption.JPEG_ALLOW_JPEG_EMBEDDING, Boolean.class);
    }

    public Float getBitmapEncodingQuality() {
        return this.getParam(AFPRendererOption.JPEG_BITMAP_ENCODING_QUALITY, Float.class);
    }

    public Boolean isUseIocaImages() {
        return this.getParam(AFPRendererOption.JPEG_USE_IOCA_IMAGES, Boolean.class);
    }

    public Float getLineWidthCorrection() {
        return this.getParam(AFPRendererOption.LINE_WIDTH_CORRECTION, Float.class);
    }

    public Boolean isGocaEnabled() {
        return this.getParam(AFPRendererOption.GOCA, Boolean.class);
    }

    public Boolean isStrokeGocaText() {
        return this.getParam(AFPRendererOption.GOCA_TEXT, Boolean.class);
    }

    private <T> T getParam(AFPRendererOption options, Class<T> type) {
        assert (options.getType().equals(type));
        return type.cast(this.params.get(options));
    }

    private <T> void setParam(AFPRendererOption option, T value) {
        assert (option.getType().isInstance(value));
        this.params.put(option, value);
    }

    private static final class ParserHelper {
        private static final Log LOG = LogFactory.getLog(ParserHelper.class);
        private final AFPRendererConfig config;
        private final boolean strict;
        private final Configuration cfg;

        private ParserHelper(Configuration cfg, FontManager fontManager, boolean strict, AFPEventProducer eventProducer) throws ConfigurationException, FOPException {
            this.cfg = cfg;
            this.strict = strict;
            if (cfg != null) {
                this.config = new AFPRendererConfig(new AFPFontConfig.AFPFontInfoConfigParser().parse(cfg, fontManager, strict, eventProducer));
                this.configure();
            } else {
                this.config = new AFPRendererConfig(new AFPFontConfig.AFPFontInfoConfigParser().getEmptyConfig());
            }
        }

        private void configure() throws ConfigurationException, FOPException {
            this.configureImages();
            this.configureGOCA();
            this.setParam(AFPRendererOption.SHADING, (Object)AFPShadingMode.getValueOf(this.cfg.getChild(AFPRendererOption.SHADING.getName()).getValue(AFPShadingMode.COLOR.getName())));
            Configuration rendererResolutionCfg = this.cfg.getChild(AFPRendererOption.RENDERER_RESOLUTION.getName(), false);
            this.setParam(AFPRendererOption.RENDERER_RESOLUTION, rendererResolutionCfg == null ? 240 : rendererResolutionCfg.getValueAsInteger(240));
            Configuration lineWidthCorrectionCfg = this.cfg.getChild(AFPRendererOption.LINE_WIDTH_CORRECTION.getName(), false);
            this.setParam(AFPRendererOption.LINE_WIDTH_CORRECTION, Float.valueOf(lineWidthCorrectionCfg != null ? lineWidthCorrectionCfg.getValueAsFloat() : 2.5f));
            Configuration gocaCfg = this.cfg.getChild(AFPRendererOption.GOCA.getName());
            boolean gocaEnabled = gocaCfg.getAttributeAsBoolean("enabled", true);
            this.setParam(AFPRendererOption.GOCA, gocaEnabled);
            String strokeGocaText = gocaCfg.getAttribute(AFPRendererOption.GOCA_TEXT.getName(), "default");
            this.setParam(AFPRendererOption.GOCA_TEXT, "stroke".equalsIgnoreCase(strokeGocaText) || "shapes".equalsIgnoreCase(strokeGocaText));
            this.createResourceGroupFile();
            this.createResourceLevel();
        }

        private void setParam(AFPRendererOption option, Object value) {
            this.config.setParam(option, value);
        }

        private void configureImages() throws ConfigurationException, FOPException {
            float dq;
            Configuration imagesCfg = this.cfg.getChild(AFPRendererOption.IMAGES.getName());
            ImagesModeOptions imagesMode = ImagesModeOptions.forName(imagesCfg.getAttribute(AFPRendererOption.IMAGES_MODE.getName(), ImagesModeOptions.MODE_GRAYSCALE.getName()));
            boolean colorImages = ImagesModeOptions.MODE_COLOR == imagesMode;
            this.setParam(AFPRendererOption.IMAGES_MODE, colorImages);
            if (colorImages) {
                this.config.imageModeParams.put(ImagesModeOptions.MODE_COLOR, imagesCfg.getAttributeAsBoolean(imagesMode.getModeAttribute(), false));
            } else {
                this.config.imageModeParams.put(ImagesModeOptions.MODE_GRAYSCALE, imagesCfg.getAttributeAsInteger(imagesMode.getModeAttribute(), 8));
            }
            String dithering = imagesCfg.getAttribute(AFPRendererOption.IMAGES_DITHERING_QUALITY.getName(), "medium");
            if (dithering.startsWith("min")) {
                dq = 0.0f;
            } else if (dithering.startsWith("max")) {
                dq = 1.0f;
            } else {
                try {
                    dq = Float.parseFloat(dithering);
                }
                catch (NumberFormatException nfe) {
                    dq = 0.5f;
                }
            }
            this.setParam(AFPRendererOption.IMAGES_DITHERING_QUALITY, Float.valueOf(dq));
            this.setParam(AFPRendererOption.IMAGES_NATIVE, imagesCfg.getAttributeAsBoolean(AFPRendererOption.IMAGES_NATIVE.getName(), false));
            this.setParam(AFPRendererOption.IMAGES_NATIVE_PDF, imagesCfg.getAttributeAsBoolean(AFPRendererOption.IMAGES_NATIVE_PDF.getName(), false));
            this.setParam(AFPRendererOption.IMAGES_WRAP_PSEG, imagesCfg.getAttributeAsBoolean(AFPRendererOption.IMAGES_WRAP_PSEG.getName(), false));
            this.setParam(AFPRendererOption.IMAGES_FS45, imagesCfg.getAttributeAsBoolean(AFPRendererOption.IMAGES_FS45.getName(), false));
            this.setParam(AFPRendererOption.IMAGES_MASK_ENABLED, imagesCfg.getAttributeAsBoolean(AFPRendererOption.IMAGES_MASK_ENABLED.getName(), false));
            if ("scale-to-fit".equals(imagesCfg.getAttribute(AFPRendererOption.IMAGES_MAPPING_OPTION.getName(), null))) {
                this.setParam(AFPRendererOption.IMAGES_MAPPING_OPTION, (byte)96);
            } else {
                this.setParam(AFPRendererOption.IMAGES_MAPPING_OPTION, (byte)0);
            }
            this.configureJpegImages(imagesCfg);
        }

        private void configureGOCA() {
            Configuration gocaCfg = this.cfg.getChild(AFPRendererOption.GOCA.getName());
            this.setParam(AFPRendererOption.GOCA_WRAP_PSEG, gocaCfg.getAttributeAsBoolean(AFPRendererOption.GOCA_WRAP_PSEG.getName(), false));
        }

        private void configureJpegImages(Configuration imagesCfg) {
            Configuration jpegConfig = imagesCfg.getChild(AFPRendererOption.IMAGES_JPEG.getName());
            float bitmapEncodingQuality = 1.0f;
            boolean allowJpegEmbedding = false;
            boolean useIocaImages = true;
            if (jpegConfig != null) {
                allowJpegEmbedding = jpegConfig.getAttributeAsBoolean(AFPRendererOption.JPEG_ALLOW_JPEG_EMBEDDING.getName(), false);
                useIocaImages = jpegConfig.getAttributeAsBoolean(AFPRendererOption.JPEG_USE_IOCA_IMAGES.getName(), true);
                String bitmapEncodingQualityStr = jpegConfig.getAttribute(AFPRendererOption.JPEG_BITMAP_ENCODING_QUALITY.getName(), null);
                if (bitmapEncodingQualityStr != null) {
                    try {
                        bitmapEncodingQuality = Float.parseFloat(bitmapEncodingQualityStr);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
            this.setParam(AFPRendererOption.JPEG_BITMAP_ENCODING_QUALITY, Float.valueOf(bitmapEncodingQuality));
            this.setParam(AFPRendererOption.JPEG_ALLOW_JPEG_EMBEDDING, allowJpegEmbedding);
            this.setParam(AFPRendererOption.JPEG_USE_IOCA_IMAGES, useIocaImages);
        }

        private void createResourceGroupFile() throws FOPException {
            try {
                Configuration resourceGroupUriCfg = this.cfg.getChild(AFPRendererOption.RESOURCE_GROUP_URI.getName(), false);
                if (resourceGroupUriCfg != null) {
                    URI resourceGroupUri = InternalResourceResolver.cleanURI(resourceGroupUriCfg.getValue());
                    this.setParam(AFPRendererOption.RESOURCE_GROUP_URI, resourceGroupUri);
                }
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, this.strict);
            }
            catch (URISyntaxException use) {
                LogUtil.handleException(LOG, use, this.strict);
            }
        }

        private void createResourceLevel() throws FOPException {
            Configuration defaultResourceLevelCfg = this.cfg.getChild(AFPRendererOption.DEFAULT_RESOURCE_LEVELS.getName(), false);
            if (defaultResourceLevelCfg != null) {
                String[] types;
                AFPResourceLevelDefaults defaults = new AFPResourceLevelDefaults();
                for (String type : types = defaultResourceLevelCfg.getAttributeNames()) {
                    try {
                        String level = defaultResourceLevelCfg.getAttribute(type);
                        defaults.setDefaultResourceLevel(type, AFPResourceLevel.valueOf(level));
                    }
                    catch (IllegalArgumentException iae) {
                        LogUtil.handleException(LOG, iae, this.strict);
                    }
                    catch (ConfigurationException e) {
                        LogUtil.handleException(LOG, e, this.strict);
                    }
                }
                this.setParam(AFPRendererOption.DEFAULT_RESOURCE_LEVELS, defaults);
            }
        }
    }

    public static final class AFPRendererConfigParser
    implements RendererConfig.RendererConfigParser {
        private static final Log LOG = LogFactory.getLog(AFPRendererConfigParser.class);

        @Override
        public AFPRendererConfig build(FOUserAgent userAgent, Configuration cfg) throws FOPException {
            boolean strict = userAgent.validateUserConfigStrictly();
            AFPRendererConfig config = null;
            AFPEventProducer eventProducer = AFPEventProducer.Provider.get(userAgent.getEventBroadcaster());
            try {
                config = new ParserHelper(cfg, userAgent.getFontManager(), strict, eventProducer).config;
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(LOG, e, strict);
            }
            return config;
        }

        @Override
        public String getMimeType() {
            return "application/x-afp";
        }
    }

    public static enum ImagesModeOptions {
        MODE_GRAYSCALE("b+w", "bits-per-pixel"),
        MODE_COLOR("color", "cmyk");

        private final String name;
        private final String modeAttribute;

        private ImagesModeOptions(String name, String modeAttribute) {
            this.name = name;
            this.modeAttribute = modeAttribute;
        }

        public String getName() {
            return this.name;
        }

        public String getModeAttribute() {
            return this.modeAttribute;
        }

        public static ImagesModeOptions forName(String name) {
            for (ImagesModeOptions option : ImagesModeOptions.values()) {
                if (!option.name.equals(name)) continue;
                return option;
            }
            throw new IllegalArgumentException(name);
        }
    }
}

