/*
 * Decompiled with CFR 0.152.
 */
package org.a11y.brlapi.clients;

import org.a11y.brlapi.Client;
import org.a11y.brlapi.Connection;
import org.a11y.brlapi.Parameter;
import org.a11y.brlapi.Parameters;
import org.a11y.brlapi.Parse;
import org.a11y.brlapi.SemanticException;
import org.a11y.brlapi.SyntaxException;
import org.a11y.brlapi.TooManyParametersException;

public class ListParametersClient
extends Client {
    private String parameterName = null;
    private Long subparamValue = null;

    public ListParametersClient(String ... stringArray) {
        super(stringArray);
        this.addOptionalParameters("parameter", "subparam");
    }

    @Override
    protected void processParameters(String[] stringArray) throws SyntaxException {
        int n = 0;
        int n2 = stringArray.length;
        if (n == n2) {
            return;
        }
        this.parameterName = stringArray[n++];
        if (n == n2) {
            return;
        }
        this.subparamValue = Parse.asLong("subparam", stringArray[n++]);
        if (n < n2) {
            throw new TooManyParametersException(stringArray, n);
        }
    }

    @Override
    protected final void runClient(Connection connection) throws SemanticException {
        if (this.parameterName == null) {
            Parameter[] parameterArray = connection.getParameters().get();
            Parameters.sortByName(parameterArray);
            for (Parameter parameter : parameterArray) {
                String string;
                if (parameter.isHidable() || parameter.hasSubparam() || (string = parameter.toString()) == null) continue;
                ListParametersClient.printf("%s: %s\n", parameter.getLabel(), string);
            }
        } else {
            String string;
            Parameter parameter = this.getParameter(connection, this.parameterName);
            if (this.subparamValue == null) {
                if (parameter.hasSubparam()) {
                    throw new SemanticException("subparam not specified: %s", parameter.getName());
                }
                string = parameter.toString();
            } else {
                if (!parameter.hasSubparam()) {
                    throw new SemanticException("has no subparam: %s", parameter.getName());
                }
                long l = this.subparamValue;
                string = parameter.toString(l);
            }
            if (string == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("parameter has no value");
                stringBuilder.append(": ");
                stringBuilder.append(parameter.getName());
                if (this.subparamValue != null) {
                    stringBuilder.append('[');
                    stringBuilder.append(this.subparamValue);
                    stringBuilder.append(']');
                }
                throw new SemanticException("%s", stringBuilder);
            }
            ListParametersClient.printf("%s\n", string);
        }
    }
}

