# Distributed under the OSI-approved BSD 3-Clause License.
# See https://cmake.org/licensing for details.

#[=======================================================================[.rst:
gio-2.0
-------

Finds the gio-2.0 library.

Imported Targets
^^^^^^^^^^^^^^^^

This module was generated by "generate_find_module" and provides the following IMPORTED targets, if found:

``gio-2.0::gio-2.0``
  The gio-2.0 library

Result Variables
^^^^^^^^^^^^^^^^

This will define the following variables:

``gio-2.0_FOUND``
  True if the system has the gio-2.0 library.
``gio-2.0_VERSION``
  The version of the gio-2.0 library which was found.
``gio-2.0_INCLUDE_DIRS``
  Include directories needed to use gio-2.0.
``gio-2.0_LIBRARIES``
  Libraries needed to link to gio-2.0.

Cache Variables
^^^^^^^^^^^^^^^

The following cache variables may also be set:

``gio-2.0_INCLUDE_DIR``
  The directory containing ``gfile.h``.
``gio-2.0_LIBRARY``
  The path to the gio-2.0 library.

#]=======================================================================]

set(VERBOSE_FIND_MODULE OFF CACHE BOOL "Enable to print debug infos in the generated Find[...].cmake files")

find_package(PkgConfig)
pkg_check_modules(PC_gio-2.0 QUIET gio-2.0)
find_path(gio-2.0_INCLUDE_DIR NAMES gfile.h
    HINTS  
    PATHS  ${PC_gio-2.0_INCLUDE_DIRS}
    PATH_SUFFIXES gio
    
    
    
    
    
    
      
)

find_library(gio-2.0_LIBRARY NAMES gio-2.0
    HINTS 
    PATHS  ${PC_gio-2.0_LIBRARY_DIRS}
    PATH_SUFFIXES 
    
    
    
    
    
    
      
)

set(Foo_VERSION ${PC_gio-2.0_VERSION})
set(Foo_VERSION_STRING ${Foo_VERSION})

if(${VERBOSE_FIND_MODULE})
    message(STATUS "Running Findgio-2.0.cmake")
    if(${PC_gio-2.0_FOUND})
        message(STATUS "   Found PkgConfig module with name 'gio-2.0':")
        message(STATUS "       gio-2.0_LIBRARIES: ${PC_gio-2.0_LIBRARIES}")
        message(STATUS "       gio-2.0_LIBRARY_DIRS: ${PC_gio-2.0_LIBRARY_DIRS}")
        message(STATUS "       gio-2.0_LDFLAGS: ${PC_gio-2.0_LDFLAGS}")
        message(STATUS "       gio-2.0_LDFLAGS_OTHER: ${PC_gio-2.0_LDFLAGS_OTHER}")
        message(STATUS "       gio-2.0_INCLUDE_DIRS: ${PC_gio-2.0_INCLUDE_DIRS}")
        message(STATUS "       gio-2.0_CFLAGS: ${PC_gio-2.0_CFLAGS}")
        message(STATUS "       gio-2.0_CFLAGS_OTHER: ${PC_gio-2.0_CFLAGS_OTHER}")
    else()
        message(STATUS "   No PkgConfig module found with name 'gio-2.0'")
    endif()
endif()

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(gio-2.0 FOUND_VAR gio-2.0_FOUND REQUIRED_VARS gio-2.0_LIBRARY gio-2.0_INCLUDE_DIR VERSION_VAR gio-2.0_VERSION)

if(gio-2.0_FOUND)
    set(gio-2.0_LIBRARIES ${gio-2.0_LIBRARY})
    if(PC_gio-2.0_INCLUDE_DIRS)
        set(gio-2.0_INCLUDE_DIRS ${PC_gio-2.0_INCLUDE_DIRS})
    else()
        set(gio-2.0_INCLUDE_DIRS ${gio-2.0_INCLUDE_DIR})
    endif()
    set(gio-2.0_DEFINITIONS ${PC_gio-2.0_CFLAGS_OTHER})
endif()

if(gio-2.0_FOUND AND NOT TARGET gio-2.0::gio-2.0)
    add_library(gio-2.0::gio-2.0 UNKNOWN IMPORTED)
    set_target_properties(gio-2.0::gio-2.0 PROPERTIES IMPORTED_LOCATION "${gio-2.0_LIBRARY}" INTERFACE_COMPILE_OPTIONS "${PC_gio-2.0_CFLAGS_OTHER}" INTERFACE_INCLUDE_DIRECTORIES "${gio-2.0_INCLUDE_DIRS}")
    if(${VERBOSE_FIND_MODULE})
        message(STATUS "   Creating IMPORTED target 'gio-2.0::gio-2.0':")
        message(STATUS "       IMPORTED_LOCATION: ${gio-2.0_LIBRARY}")
        message(STATUS "       INTERFACE_COMPILE_OPTIONS: ${PC_gio-2.0_CFLAGS_OTHER}")
        message(STATUS "       INTERFACE_INCLUDE_DIRECTORIES: ${gio-2.0_INCLUDE_DIRS}")
    endif()
endif()

mark_as_advanced(
  gio-2.0_INCLUDE_DIR
  gio-2.0_LIBRARY
)
