// SPDX-FileCopyrightText: Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
// SPDX-License-Identifier: BSD-3-Clause
/**
 * @class   vtkIndexedLongLongArray
 * @brief   indexed implicit array of long long.
 *
 * vtkIndexedLongLongArray is an indexed implicit array of values of type long long.
 * see vtkIndexedArray, vtkIndexedImplicitBackend
 *
 * This file is generated by vtkImplicitArrays.cmake
 */

#ifndef vtkIndexedLongLongArray_h
#define vtkIndexedLongLongArray_h

#include "vtkIndexedArray.h" // Real Superclass
#include "vtkCommonCoreModule.h"     // For export macro
#include "vtkDataArray.h"

// Fake the superclass for the wrappers.
#ifndef __VTK_WRAP__
#define vtkDataArray vtkIndexedArray<long long>
#endif
VTK_ABI_NAMESPACE_BEGIN
class VTKCOMMONCORE_EXPORT vtkIndexedLongLongArray : public vtkDataArray
{
public:
  vtkImplicitArrayTypeMacro(vtkIndexedLongLongArray, vtkDataArray);
#ifndef __VTK_WRAP__
#undef vtkDataArray
#endif

  static vtkIndexedLongLongArray* New();
  static vtkIndexedLongLongArray* ExtendedNew();
  void PrintSelf(ostream& os, vtkIndent indent) override;

  // This macro expands to the set of method declarations that
  // make up the interface of vtkImplicitArray, which is ignored
  // by the wrappers.
#if defined(__VTK_WRAP__) || defined(__WRAP_GCCXML__)
  vtkCreateReadOnlyWrappedArrayInterface(long long);
#endif

  /**
   * A faster alternative to SafeDownCast for downcasting vtkAbstractArrays.
   */
  static vtkIndexedLongLongArray* FastDownCast(vtkAbstractArray* source)
  {
    return static_cast<vtkIndexedLongLongArray*>(Superclass::FastDownCast(source));
  }

  ///@{
  /**
   * Set which indexes from array should be exposed.
   */
  void ConstructBackend(vtkIdList* indexes, vtkDataArray* array);
  void ConstructBackend(vtkDataArray* indexes, vtkDataArray* array);
  ///@}

protected:
  vtkIndexedLongLongArray();
  ~vtkIndexedLongLongArray() override;

private:
  typedef vtkIndexedArray<long long> RealSuperclass;

  vtkIndexedLongLongArray(const vtkIndexedLongLongArray&) = delete;
  void operator=(const vtkIndexedLongLongArray&) = delete;
};

// Define vtkArrayDownCast implementation:
vtkArrayDownCast_FastCastMacro(vtkIndexedLongLongArray);

VTK_ABI_NAMESPACE_END
#endif
// VTK-HeaderTest-Exclude: TYPEMACRO
