/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.remote;

import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ISVNRemote;
import org.apache.subversion.javahl.NativeResources;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.AuthnCallback;
import org.apache.subversion.javahl.callback.ConfigEvent;
import org.apache.subversion.javahl.callback.ProgressCallback;
import org.apache.subversion.javahl.callback.TunnelAgent;
import org.apache.subversion.javahl.callback.UserPasswordCallback;

public class RemoteFactory {
    private String configDirectory;
    private String username;
    private String password;
    private AuthnCallback prompt;
    private UserPasswordCallback deprecatedPrompt;
    private ProgressCallback progress;
    private ConfigEvent configHandler;
    private TunnelAgent tunnelAgent;

    public RemoteFactory() {
    }

    public RemoteFactory(String string, String string2, String string3, AuthnCallback authnCallback, ProgressCallback progressCallback, ConfigEvent configEvent, TunnelAgent tunnelAgent) {
        this.setConfigDirectory(string);
        this.setUsername(string2);
        this.setPassword(string3);
        this.setPrompt(authnCallback);
        this.setProgressCallback(progressCallback);
        this.setConfigEventHandler(configEvent);
        this.setTunnelAgent(tunnelAgent);
    }

    public RemoteFactory(String string, String string2, String string3, UserPasswordCallback userPasswordCallback, ProgressCallback progressCallback, ConfigEvent configEvent, TunnelAgent tunnelAgent) {
        this.setConfigDirectory(string);
        this.setUsername(string2);
        this.setPassword(string3);
        this.setPrompt(userPasswordCallback);
        this.setProgressCallback(progressCallback);
        this.setConfigEventHandler(configEvent);
        this.setTunnelAgent(tunnelAgent);
    }

    public void setUsername(String string) {
        if (string != null && string.isEmpty()) {
            throw new IllegalArgumentException("username must not be empty");
        }
        this.username = string;
    }

    public void setPassword(String string) {
        if (string != null && string.isEmpty()) {
            throw new IllegalArgumentException("password must not be empty");
        }
        this.password = string;
    }

    public void setPrompt(AuthnCallback authnCallback) {
        assert (this.deprecatedPrompt == null);
        this.prompt = authnCallback;
    }

    public void setPrompt(UserPasswordCallback userPasswordCallback) {
        assert (this.prompt == null);
        this.deprecatedPrompt = userPasswordCallback;
    }

    public void setProgressCallback(ProgressCallback progressCallback) {
        this.progress = progressCallback;
    }

    public void setConfigDirectory(String string) {
        this.configDirectory = string;
    }

    public void setConfigEventHandler(ConfigEvent configEvent) {
        this.configHandler = configEvent;
    }

    public void setTunnelAgent(TunnelAgent tunnelAgent) {
        this.tunnelAgent = tunnelAgent;
    }

    public ISVNRemote openRemoteSession(String string) throws ClientException, SubversionException {
        return RemoteFactory.open(1, string, null, this.configDirectory, this.username, this.password, this.prompt, this.deprecatedPrompt, this.progress, this.configHandler, this.tunnelAgent);
    }

    public ISVNRemote openRemoteSession(String string, int n) throws ClientException, SubversionException {
        if (n <= 0) {
            throw new IllegalArgumentException("retryAttempts must be positive");
        }
        return RemoteFactory.open(n, string, null, this.configDirectory, this.username, this.password, this.prompt, this.deprecatedPrompt, this.progress, this.configHandler, this.tunnelAgent);
    }

    public ISVNRemote openRemoteSession(String string, String string2) throws ClientException, SubversionException {
        if (string2 == null) {
            throw new IllegalArgumentException("reposUUID may not be null");
        }
        return RemoteFactory.open(1, string, string2, this.configDirectory, this.username, this.password, this.prompt, this.deprecatedPrompt, this.progress, this.configHandler, this.tunnelAgent);
    }

    public ISVNRemote openRemoteSession(String string, String string2, int n) throws ClientException, SubversionException {
        if (string2 == null) {
            throw new IllegalArgumentException("reposUUID may not be null");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("retryAttempts must be positive");
        }
        return RemoteFactory.open(n, string, string2, this.configDirectory, this.username, this.password, this.prompt, this.deprecatedPrompt, this.progress, this.configHandler, this.tunnelAgent);
    }

    private static native ISVNRemote open(int var0, String var1, String var2, String var3, String var4, String var5, AuthnCallback var6, UserPasswordCallback var7, ProgressCallback var8, ConfigEvent var9, TunnelAgent var10) throws ClientException, SubversionException;

    static {
        NativeResources.loadNativeLibrary();
    }
}

