/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.range;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.range.PBigRange;
import com.oracle.graal.python.builtins.objects.range.PIntRange;
import com.oracle.graal.python.builtins.objects.range.PRange;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.util.CastToJavaBigIntegerNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.math.BigInteger;

public abstract class RangeNodes {

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PRangeStepNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, PRange var2);

        @Specialization
        Object doIntRange(PIntRange range) {
            return range.getIntStep();
        }

        @Specialization
        Object doBigRange(PBigRange range) {
            return range.getStep();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PRangeStopNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, PRange var2);

        @Specialization
        Object doIntRange(PIntRange range) {
            return range.getIntStop();
        }

        @Specialization
        Object doBigRange(PBigRange range) {
            return range.getStop();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PRangeStartNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, PRange var2);

        @Specialization
        Object doIntRange(PIntRange range) {
            return range.getIntStart();
        }

        @Specialization
        Object doBigRange(PBigRange range) {
            return range.getStart();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CoerceToBigRange
    extends PNodeWithContext {
        public abstract PBigRange execute(Node var1, PRange var2);

        @Specialization
        static PBigRange doIntRange(Node inliningTarget, PIntRange range, @Cached CreateBigRangeNode cast) {
            return cast.execute(inliningTarget, range.getIntStart(), range.getIntStop(), range.getIntStep());
        }

        @Specialization
        static PBigRange doBigRange(PBigRange range) {
            return range;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class LenOfIntRangeNodeExact
    extends LenOfIntRangeBaseNode {
        @Specialization(guards={"step > 0", "lo < hi"})
        static int mightBeBig1(int lo, int hi, int step) throws OverflowException {
            long diff = PythonUtils.subtractExact(PythonUtils.subtractExact((long)hi, (long)lo), 1L);
            return PythonUtils.toIntExact(PythonUtils.addExact(diff / (long)step, 1L));
        }

        @Specialization(guards={"step < 0", "lo > hi"})
        static int mightBeBig2(int lo, int hi, int step) throws OverflowException {
            long diff = PythonUtils.subtractExact(PythonUtils.subtractExact((long)lo, (long)hi), 1L);
            return PythonUtils.toIntExact(PythonUtils.addExact(diff / -((long)step), 1L));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class LenOfRangeNode
    extends LenOfIntRangeBaseNode {
        public abstract BigInteger execute(Node var1, BigInteger var2, BigInteger var3, BigInteger var4);

        @Override
        public abstract int executeInt(Node var1, int var2, int var3, int var4);

        public int len(Node inliningTarget, PSlice.SliceInfo slice) throws ArithmeticException {
            return this.executeInt(inliningTarget, slice.start, slice.stop, slice.step);
        }

        @Specialization(guards={"step > 0", "lo < hi"})
        static int mightBeBig1(int lo, int hi, int step) throws ArithmeticException {
            long diff = (long)hi - (long)lo - 1L;
            long result = diff / (long)step + 1L;
            assert (result == (long)((int)result));
            return (int)result;
        }

        @Specialization(guards={"step < 0", "lo > hi"})
        static int mightBeBig2(int lo, int hi, int step) throws ArithmeticException {
            long diff = (long)lo - (long)hi - 1L;
            long result = diff / -((long)step) + 1L;
            assert (result == (long)((int)result));
            return (int)result;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static Object doBigInt(BigInteger lo, BigInteger hi, BigInteger step) {
            BigInteger zero = BigInteger.ZERO;
            BigInteger one = BigInteger.ONE;
            BigInteger n = zero;
            if (step.compareTo(zero) > 0 && lo.compareTo(hi) < 0) {
                BigInteger diff = hi.subtract(one).subtract(lo);
                n = diff.divide(step).add(one);
            } else if (step.compareTo(zero) < 0 && lo.compareTo(hi) > 0) {
                BigInteger diff = lo.subtract(one).subtract(hi);
                n = diff.divide(step.negate()).add(one);
            }
            return n;
        }
    }

    @ImportStatic(value={SpecialMethodNames.class})
    @GenerateCached(value=false)
    public static abstract class LenOfIntRangeBaseNode
    extends Node {
        public abstract int executeInt(Node var1, int var2, int var3, int var4) throws OverflowException;

        @Specialization(guards={"step > 0", "lo > 0", "lo < hi"})
        static int simple(int lo, int hi, int step) {
            return 1 + (hi - 1 - lo) / step;
        }

        @Specialization(guards={"step > 0", "lo >= hi"})
        static int zero1(int lo, int hi, int step) {
            return 0;
        }

        @Specialization(guards={"step < 0", "lo < 0", "lo > hi"})
        static int simpleNegative(int lo, int hi, int step) {
            return 1 + (lo - 1 - hi) / -step;
        }

        @Specialization(guards={"step < 0", "lo <= hi"})
        static int zero2(int lo, int hi, int step) {
            return 0;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={SpecialMethodNames.class})
    public static abstract class CreateBigRangeNode
    extends Node {
        public abstract PBigRange execute(Node var1, Object var2, Object var3, Object var4);

        @CompilerDirectives.TruffleBoundary
        private static void checkStepZero(Node inliningTarget, BigInteger stepBI, PRaiseNode raise) {
            if (stepBI.compareTo(BigInteger.ZERO) == 0) {
                throw raise.raise(inliningTarget, PythonErrorType.ValueError, ErrorMessages.ARG_MUST_NOT_BE_ZERO, "range()", 3);
            }
        }

        @Specialization
        static PBigRange createBigRange(Node inliningTarget, Object start, Object stop, Object step, @Cached LenOfRangeNode lenOfRangeNode, @Cached CastToJavaBigIntegerNode startToBI, @Cached CastToJavaBigIntegerNode stopToBI, @Cached CastToJavaBigIntegerNode stepToBI, @Cached PRaiseNode raise) {
            BigInteger stepBI = stepToBI.execute(inliningTarget, step);
            CreateBigRangeNode.checkStepZero(inliningTarget, stepBI, raise);
            BigInteger startBI = startToBI.execute(inliningTarget, start);
            BigInteger stopBI = stopToBI.execute(inliningTarget, stop);
            BigInteger len = lenOfRangeNode.execute(inliningTarget, startBI, stopBI, stepBI);
            PythonLanguage language = PythonLanguage.get(inliningTarget);
            return PFactory.createBigRange(language, PFactory.createInt(language, startBI), PFactory.createInt(language, stopBI), PFactory.createInt(language, stepBI), PFactory.createInt(language, len));
        }
    }
}

