/*
 * Decompiled with CFR 0.152.
 */
package us.fatehi.utility;

import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import us.fatehi.utility.PropertiesUtility;
import us.fatehi.utility.Utility;

public final class UtilityLogger {
    private final Logger logger;

    public UtilityLogger(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "No logger provided");
    }

    public void logFatalStackTrace(Throwable t) {
        if (t == null || !this.logger.isLoggable(Level.SEVERE)) {
            return;
        }
        this.logger.log(Level.SEVERE, t.getMessage(), t);
    }

    public void logPossiblyUnsupportedSQLFeature(Supplier<String> message, SQLException e) {
        if ("HYC00".equalsIgnoreCase(e.getSQLState()) || "HY000".equalsIgnoreCase(e.getSQLState()) || "0A000".equalsIgnoreCase(e.getSQLState()) || e instanceof SQLFeatureNotSupportedException) {
            this.logSQLFeatureNotSupported(message, e);
        } else {
            this.logger.log(Level.WARNING, e, message);
        }
    }

    public void logSafeArguments(String[] args) {
        if (args == null || !this.logger.isLoggable(Level.INFO)) {
            return;
        }
        String passwordRedacted = "<password provided>";
        StringJoiner argsList = new StringJoiner(System.lineSeparator());
        Iterator<String> iterator = Arrays.asList(args).iterator();
        while (iterator.hasNext()) {
            String arg = iterator.next();
            if (arg == null) continue;
            if (arg.matches("--password.*=.*")) {
                argsList.add("<password provided>");
                continue;
            }
            if (arg.startsWith("--password")) {
                argsList.add("<password provided>");
                if (!iterator.hasNext()) continue;
                iterator.next();
                continue;
            }
            argsList.add(arg);
        }
        this.logger.log(Level.INFO, "Command line: %n%s".formatted(argsList.toString()));
    }

    public void logSQLFeatureNotSupported(Supplier<String> message, Throwable e) {
        this.logger.log(Level.WARNING, message);
        this.logger.log(Level.FINE, e, message);
    }

    public void logSQLWarnings(ResultSet resultSet) {
        if (resultSet == null || !this.logger.isLoggable(Level.INFO)) {
            return;
        }
        try {
            this.logSQLWarnings(resultSet.getWarnings());
            resultSet.clearWarnings();
        }
        catch (SQLException e) {
            this.logger.log(Level.FINE, "Could not log SQL warnings for result set");
        }
    }

    public void logSQLWarnings(Statement statement) {
        if (statement == null || !this.logger.isLoggable(Level.INFO)) {
            return;
        }
        try {
            this.logSQLWarnings(statement.getWarnings());
            statement.clearWarnings();
        }
        catch (SQLException e) {
            this.logger.log(Level.FINE, "Could not log SQL warnings for statement");
        }
    }

    public void logSystemClasspath() {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        this.logger.log(Level.CONFIG, "Classpath: %n%s".formatted(this.printPath(System.getProperty("java.class.path"))));
        this.logger.log(Level.CONFIG, "LD_LIBRARY_PATH: %n%s".formatted(this.printPath(System.getenv("LD_LIBRARY_PATH"))));
    }

    public void logSystemProperties() {
        if (!this.logger.isLoggable(Level.CONFIG)) {
            return;
        }
        Map systemProperties = PropertiesUtility.systemProperties().entrySet().stream().filter(entry -> {
            String key = (String)entry.getKey();
            return (key.startsWith("java.") || key.startsWith("os.")) && !key.endsWith(".path");
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, TreeMap::new));
        this.logger.log(Level.CONFIG, "System properties: %n%s".formatted(Utility.join(systemProperties, System.lineSeparator())));
    }

    private void logSQLWarnings(SQLWarning sqlWarning) {
        for (SQLWarning currentSqlWarning = sqlWarning; currentSqlWarning != null; currentSqlWarning = currentSqlWarning.getNextWarning()) {
            String message = "%s%nError code: %d, SQL state: %s".formatted(currentSqlWarning.getMessage(), currentSqlWarning.getErrorCode(), currentSqlWarning.getSQLState());
            this.logger.log(Level.INFO, message, currentSqlWarning);
        }
    }

    private String printPath(String path) {
        if (path == null) {
            return "";
        }
        return String.join((CharSequence)System.lineSeparator(), path.split(File.pathSeparator));
    }
}

