/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.regex.result;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.regex.AbstractConstantKeysObject;
import com.oracle.truffle.regex.AbstractRegexObject;
import com.oracle.truffle.regex.result.RegexResultFactory;
import com.oracle.truffle.regex.runtime.nodes.DispatchNode;
import com.oracle.truffle.regex.runtime.nodes.ToIntNode;
import com.oracle.truffle.regex.tregex.parser.ast.Group;
import com.oracle.truffle.regex.util.EmptyArrays;
import com.oracle.truffle.regex.util.TruffleReadOnlyKeysArray;
import java.util.Arrays;

@ExportLibrary(value=InteropLibrary.class)
public final class RegexResult
extends AbstractConstantKeysObject {
    static final String PROP_IS_MATCH = "isMatch";
    static final String PROP_GET_START = "getStart";
    static final String PROP_GET_END = "getEnd";
    static final String PROP_LAST_GROUP = "lastGroup";
    private static final TruffleReadOnlyKeysArray KEYS = new TruffleReadOnlyKeysArray("isMatch", "getStart", "getEnd", "lastGroup");
    private final TruffleString input;
    private final int fromIndex;
    private final int regionFrom;
    private final int regionTo;
    private final int start;
    private final int end;
    private int[] result;
    private final CallTarget lazyCallTarget;
    private static final RegexResult NO_MATCH_RESULT = new RegexResult(null, -1, -1, -1, -1, -1, EmptyArrays.INT, null);
    private static final RegexResult BOOLEAN_MATCH_RESULT = new RegexResult(null, -1, -1, -1, -1, -1, EmptyArrays.INT, null);
    private static final int INVALID_RESULT_INDEX = -1;

    protected RegexResult(TruffleString input, int fromIndex, int regionFrom, int regionTo, int start, int end, int[] result, CallTarget lazyCallTarget) {
        this.input = input;
        this.fromIndex = fromIndex;
        this.regionFrom = regionFrom;
        this.regionTo = regionTo;
        this.start = start;
        this.end = end;
        this.result = result;
        this.lazyCallTarget = lazyCallTarget;
    }

    public static RegexResult getNoMatchInstance() {
        return NO_MATCH_RESULT;
    }

    public static RegexResult getBooleanMatchInstance() {
        return BOOLEAN_MATCH_RESULT;
    }

    public static RegexResult create(int start, int end) {
        return new RegexResult(null, -1, 0, 0, 0, 0, new int[]{start, end}, null);
    }

    public static RegexResult create(int[] result) {
        assert (result != null && result.length >= 2);
        return new RegexResult(null, -1, 0, 0, 0, 0, result, null);
    }

    public static RegexResult createFromExecutorResult(Object executorResult) {
        if (executorResult == null) {
            return RegexResult.getNoMatchInstance();
        }
        return RegexResult.create((int[])executorResult);
    }

    public static RegexResult createLazy(TruffleString input, int fromIndex, int regionFrom, int regionTo, int start, int end, CallTarget lazyCallTarget) {
        return new RegexResult(input, fromIndex, regionFrom, regionTo, start, end, null, lazyCallTarget);
    }

    public TruffleString getInput() {
        return this.input;
    }

    public int getFromIndex() {
        return this.fromIndex;
    }

    public int getRegionFrom() {
        return this.regionFrom;
    }

    public int getRegionTo() {
        return this.regionTo;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public void setResult(int[] result) {
        this.result = result;
    }

    public int getStart(int groupNumber) {
        int index = Group.groupNumberToBoundaryIndexStart(groupNumber);
        return groupNumber >= this.result.length >> 1 ? -1 : this.result[index];
    }

    public int getEnd(int groupNumber) {
        int index = Group.groupNumberToBoundaryIndexEnd(groupNumber);
        return groupNumber >= this.result.length >> 1 ? -1 : this.result[index];
    }

    public int getLastGroup() {
        return (this.result.length & 1) == 0 ? -1 : this.result[this.result.length - 1];
    }

    @Override
    @ExportMessage
    public Object getMembers(boolean includeInternal) {
        return KEYS;
    }

    @Override
    public TruffleReadOnlyKeysArray getKeys() {
        return KEYS;
    }

    @Override
    public boolean isMemberReadableImpl(String symbol) {
        switch (symbol) {
            case "isMatch": 
            case "getStart": 
            case "getEnd": 
            case "lastGroup": {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object readMemberImpl(String symbol) {
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw CompilerDirectives.shouldNotReachHere();
    }

    @ExportMessage
    Object invokeMember(String member, Object[] args, @Cached ToIntNode toIntNode, @Cached InvokeCacheNode invokeCache) throws UnknownIdentifierException, ArityException, UnsupportedTypeException {
        if (args.length != 1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw ArityException.create((int)1, (int)1, (int)args.length);
        }
        return invokeCache.execute(this, member, toIntNode.execute(args[0]));
    }

    @CompilerDirectives.TruffleBoundary
    public void debugForceEvaluation() {
        CompilerAsserts.neverPartOfCompilation();
        assert (this != RegexResult.getNoMatchInstance());
        if (this.result == null) {
            this.lazyCallTarget.call(new Object[]{this});
        }
        assert (this.result != null);
    }

    @CompilerDirectives.TruffleBoundary
    public String toString() {
        if (this == RegexResult.getNoMatchInstance()) {
            return "NO_MATCH";
        }
        if (this.result == null) {
            return "[ _lazy_ ]";
        }
        return Arrays.toString(this.result);
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    @ExportMessage
    public Object toDisplayString(boolean allowSideEffects) {
        if (allowSideEffects) {
            this.debugForceEvaluation();
            return "TRegexResult" + String.valueOf(this);
        }
        return "TRegexResult";
    }

    @ImportStatic(value={RegexResult.class})
    @GenerateUncached
    @GenerateInline(value=false)
    static abstract class InvokeCacheNode
    extends Node {
        InvokeCacheNode() {
        }

        abstract Object execute(RegexResult var1, String var2, int var3) throws UnknownIdentifierException;

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_START)"}, limit="2")
        static Object getStartIdentity(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached @Cached.Shared RegexResultGetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_START)"}, limit="2", replaces={"getStartIdentity"})
        static Object getStartEquals(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached @Cached.Shared RegexResultGetStartNode getStartNode) {
            return getStartNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_END)"}, limit="2")
        static Object getEndIdentity(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached @Cached.Shared RegexResultGetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_END)"}, limit="2", replaces={"getEndIdentity"})
        static Object getEndEquals(RegexResult receiver, String symbol, int groupNumber, @Cached(value="symbol") String cachedSymbol, @Cached @Cached.Shared RegexResultGetEndNode getEndNode) {
            return getEndNode.execute(receiver, groupNumber);
        }

        @Specialization(replaces={"getStartEquals", "getEndEquals"})
        @ReportPolymorphism.Megamorphic
        static Object invokeGeneric(RegexResult receiver, String symbol, int groupNumber, @Cached @Cached.Shared RegexResultGetStartNode getStartNode, @Cached @Cached.Shared RegexResultGetEndNode getEndNode) throws UnknownIdentifierException {
            switch (symbol) {
                case "getStart": {
                    return getStartNode.execute(receiver, groupNumber);
                }
                case "getEnd": {
                    return getEndNode.execute(receiver, groupNumber);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create((String)symbol);
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class RegexResultGetLastGroupNode
    extends Node {
        public abstract int execute(Object var1);

        @Specialization
        int doResult(RegexResult receiver, @Cached InlinedBranchProfile lazyProfile, @Cached DispatchNode getIndicesCall) {
            if (receiver.result == null) {
                assert (receiver.lazyCallTarget != null);
                lazyProfile.enter((Node)this);
                getIndicesCall.execute(this, receiver.lazyCallTarget, receiver);
            }
            return receiver.getLastGroup();
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    public static abstract class RegexResultGetStartNode
    extends Node {
        public abstract int execute(Object var1, int var2);

        @Specialization
        int doResult(RegexResult receiver, int groupNumber, @Cached InlinedBranchProfile lazyProfile, @Cached DispatchNode getIndicesCall) {
            int i;
            if (receiver.result == null) {
                assert (receiver.lazyCallTarget != null);
                lazyProfile.enter((Node)this);
                getIndicesCall.execute(this, receiver.lazyCallTarget, receiver);
            }
            return (i = Group.groupNumberToBoundaryIndexStart(groupNumber)) < 0 || i >= receiver.result.length ? -1 : receiver.result[i];
        }

        public static RegexResultGetStartNode getUncached() {
            return RegexResultFactory.RegexResultGetStartNodeGen.getUncached();
        }
    }

    @GenerateInline(value=false)
    @GenerateUncached
    static abstract class RegexResultGetEndNode
    extends Node {
        RegexResultGetEndNode() {
        }

        abstract int execute(Object var1, int var2);

        @Specialization
        int doResult(RegexResult receiver, int groupNumber, @Cached InlinedBranchProfile lazyProfile, @Cached DispatchNode getIndicesCall) {
            int i;
            if (receiver.result == null) {
                assert (receiver.lazyCallTarget != null);
                lazyProfile.enter((Node)this);
                getIndicesCall.execute(this, receiver.lazyCallTarget, receiver);
            }
            return (i = Group.groupNumberToBoundaryIndexEnd(groupNumber)) < 0 || i >= receiver.result.length ? -1 : receiver.result[i];
        }
    }

    @ExportMessage
    static abstract class IsMemberInvocable {
        IsMemberInvocable() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "result"}, limit="2")
        static boolean cacheIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "result"}, limit="2", replaces={"cacheIdentity"})
        static boolean cacheEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isInvocable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isInvocable(RegexResult receiver, String symbol) {
            return RegexResult.PROP_GET_START.equals(symbol) || RegexResult.PROP_GET_END.equals(symbol);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class RegexResultGetEndMethod
    extends AbstractRegexObject {
        private final RegexResult result;

        RegexResultGetEndMethod(RegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached RegexResultGetEndNode getEndNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create((int)1, (int)1, (int)args.length);
            }
            return getEndNode.execute(this.result, toIntNode.execute(args[0]));
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexResultGetEndMethod{result=" + String.valueOf(this.result) + "}";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class RegexResultGetStartMethod
    extends AbstractRegexObject {
        private final RegexResult result;

        RegexResultGetStartMethod(RegexResult result) {
            this.result = result;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        int execute(Object[] args, @Cached ToIntNode toIntNode, @Cached RegexResultGetStartNode getStartNode) throws ArityException, UnsupportedTypeException {
            if (args.length != 1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create((int)1, (int)1, (int)args.length);
            }
            return getStartNode.execute(this.result, toIntNode.execute(args[0]));
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return "TRegexResultGetStartMethod{result=" + String.valueOf(this.result) + "}";
        }
    }

    @ExportMessage
    static abstract class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "result"}, limit="4")
        static boolean cacheIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "result"}, limit="4", replaces={"cacheIdentity"})
        static boolean cacheEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached(value="isReadable(receiver, cachedSymbol)") boolean result) {
            return result;
        }

        @Specialization(replaces={"cacheEquals"})
        static boolean isReadable(RegexResult receiver, String symbol) {
            return KEYS.contains(symbol);
        }
    }

    @ExportMessage
    static abstract class ReadMember {
        ReadMember() {
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_IS_MATCH)"}, limit="2")
        static boolean isMatchIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return receiver != RegexResult.getNoMatchInstance();
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_IS_MATCH)"}, limit="2", replaces={"isMatchIdentity"})
        static boolean isMatchEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return receiver != RegexResult.getNoMatchInstance();
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_START)"}, limit="2")
        static RegexResultGetStartMethod getStartIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetStartMethod(receiver);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_START)"}, limit="2", replaces={"getStartIdentity"})
        static RegexResultGetStartMethod getStartEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetStartMethod(receiver);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_GET_END)"}, limit="2")
        static RegexResultGetEndMethod getEndIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetEndMethod(receiver);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_GET_END)"}, limit="2", replaces={"getEndIdentity"})
        static RegexResultGetEndMethod getEndEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol) {
            return new RegexResultGetEndMethod(receiver);
        }

        @Specialization(guards={"symbol == cachedSymbol", "cachedSymbol.equals(PROP_LAST_GROUP)"}, limit="2")
        static int lastGroupIdentity(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached @Cached.Shared RegexResultGetLastGroupNode getLastGroupNode) {
            return getLastGroupNode.execute(receiver);
        }

        @Specialization(guards={"symbol.equals(cachedSymbol)", "cachedSymbol.equals(PROP_LAST_GROUP)"}, limit="2", replaces={"lastGroupIdentity"})
        static int lastGroupEquals(RegexResult receiver, String symbol, @Cached(value="symbol") String cachedSymbol, @Cached @Cached.Shared RegexResultGetLastGroupNode getLastGroupNode) {
            return getLastGroupNode.execute(receiver);
        }

        @Specialization(replaces={"isMatchEquals", "getStartEquals", "getEndEquals"})
        @ReportPolymorphism.Megamorphic
        static Object readGeneric(RegexResult receiver, String symbol, @Cached @Cached.Shared RegexResultGetLastGroupNode getLastGroupNode) throws UnknownIdentifierException {
            switch (symbol) {
                case "isMatch": {
                    return receiver != RegexResult.getNoMatchInstance();
                }
                case "getStart": {
                    return new RegexResultGetStartMethod(receiver);
                }
                case "getEnd": {
                    return new RegexResultGetEndMethod(receiver);
                }
                case "lastGroup": {
                    return getLastGroupNode.execute(receiver);
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw UnknownIdentifierException.create((String)symbol);
        }
    }
}

