/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.tools.internal.generator.jdt;

import com.ibm.db2.cmx.runtime.exception.ExceptionFactory;
import com.ibm.db2.cmx.runtime.exception.GenerationException;
import com.ibm.db2.cmx.runtime.exception.WarningFactory;
import com.ibm.db2.cmx.runtime.internal.resources.Messages;
import com.ibm.db2.cmx.tools.internal.generator.GeneratorImpl;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.osgi.framework.Bundle;

public class ASTEnvironmentInitializer {
    private boolean projectCreated = false;

    public IJavaProject getJavaProject(String string, String string2, GeneratorImpl generatorImpl, PrintWriter printWriter) throws GenerationException {
        for (int i10 = 1; i10 <= 3; ++i10) {
            Object object;
            IJavaProject iJavaProject = null;
            IProject iProject = null;
            try {
                NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                object = new Path(string);
                iProject = this.getProjectHandle();
                if (!iProject.exists()) {
                    this.createProject(iProject, (IPath)object, (IProgressMonitor)nullProgressMonitor);
                }
                if (!iProject.isOpen()) {
                    iProject.open((IProgressMonitor)nullProgressMonitor);
                }
                iJavaProject = JavaCore.create((IProject)iProject);
                if (!iProject.hasNature("org.eclipse.jdt.core.javanature")) {
                    this.addNatureToProject(iProject, "org.eclipse.jdt.core.javanature", null);
                    this.configureBuildPaths(iJavaProject, string2, (IProgressMonitor)nullProgressMonitor);
                }
                return iJavaProject;
            }
            catch (CoreException coreException) {
                throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_LD_PRJ", new Object[0]), coreException, 10178, null, null);
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                object = Messages.getText("ERR_EXCEPTION_DUE_TO_ECLIPSE_BUG_280488", "pureQuery Runtime", concurrentModificationException.getClass().getCanonicalName(), string) + "  ";
                int n2 = 3 - i10;
                if (0 >= n2) {
                    object = (String)object + Messages.getText("MSG_PLEASE_RETRY_UTILITY", generatorImpl.getUtilityName());
                    throw ExceptionFactory.createGenerationExceptionForToolsOnly((String)object, concurrentModificationException, 11261, null, null);
                }
                object = (String)object + Messages.getText("MSG_WILL_ATTEMPT_RETRY", "pureQuery Runtime", n2);
                printWriter.println((String)object);
                WarningFactory.createPureQueryWarningForToolsLogOnly((String)object, 11260, this.getClass(), "getJavaProject", concurrentModificationException);
                try {
                    if (null != iJavaProject) {
                        this.cleanup(iJavaProject);
                    } else if (null != iProject) {
                        this.cleanup(iProject);
                    }
                }
                catch (Throwable throwable) {
                    WarningFactory.createPureQueryWarningForToolsLogOnly(Messages.getText("WARN_EXCEPTION_DURING_CLEANUP", new Object[0]), 11262, this.getClass(), "getJavaProject", throwable);
                }
                iJavaProject = null;
                iProject = null;
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
        }
        throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_INTERNAL_ERROR_VALUE_NOT_SET", IJavaProject.class.getCanonicalName()), null, 11263, null, null);
    }

    public void createProject(IProject iProject, IPath iPath, IProgressMonitor iProgressMonitor) throws GenerationException {
        try {
            if (!Platform.getLocation().equals((Object)iPath)) {
                IProjectDescription iProjectDescription = iProject.getWorkspace().newProjectDescription(iProject.getName());
                iProjectDescription.setLocation(iPath);
                iProject.create(iProjectDescription, iProgressMonitor);
            } else {
                iProject.create(iProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_CRT_PRJ", new Object[0]), coreException, 10179, null, null);
        }
        this.projectCreated = true;
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject("PDQTempJavaProject");
    }

    public void addNatureToProject(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws GenerationException {
        try {
            IProjectDescription iProjectDescription = iProject.getDescription();
            String[] stringArray = iProjectDescription.getNatureIds();
            String[] stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray.length] = string;
            iProjectDescription.setNatureIds(stringArray2);
            iProject.setDescription(iProjectDescription, iProgressMonitor);
        }
        catch (CoreException coreException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PRJ_SETDESC", new Object[0]), coreException, 10180, null, null);
        }
    }

    protected void configureBuildPaths(IJavaProject iJavaProject, String string, IProgressMonitor iProgressMonitor) throws GenerationException {
        IClasspathEntry iClasspathEntry = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.jdt.launching.JRE_CONTAINER"), (boolean)false);
        URL uRL = null;
        Bundle bundle = Platform.getBundle((String)"com.ibm.db2.cmx.tools");
        int n2 = bundle != null ? ((uRL = bundle.getEntry("/pdq.jar")) != null ? 2 : 1) : 1;
        try {
            IClasspathEntry[] iClasspathEntryArray = iJavaProject.getRawClasspath();
            IClasspathEntry[] iClasspathEntryArray2 = new IClasspathEntry[iClasspathEntryArray.length + n2];
            System.arraycopy(iClasspathEntryArray, 0, iClasspathEntryArray2, 0, iClasspathEntryArray.length);
            iClasspathEntryArray2[iClasspathEntryArray2.length - n2] = iClasspathEntry;
            if (uRL != null) {
                IClasspathEntry iClasspathEntry2;
                Path path = new Path(FileLocator.toFileURL((URL)uRL).getPath());
                iClasspathEntryArray2[iClasspathEntryArray2.length - (n2 - 1)] = iClasspathEntry2 = JavaCore.newLibraryEntry((IPath)path, null, null);
            }
            iClasspathEntryArray2 = this.addPathsToClasspathEntries(iClasspathEntryArray2, string);
            iJavaProject.setRawClasspath(iClasspathEntryArray2, iProgressMonitor);
        }
        catch (JavaModelException javaModelException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_BUILDPATH", new Object[0]), javaModelException, 10181, null, null);
        }
        catch (IOException iOException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_BUILDPATH", new Object[0]), iOException, 10182, null, null);
        }
    }

    public IClasspathEntry[] addPathsToClasspathEntries(IClasspathEntry[] iClasspathEntryArray, String string) {
        if (string == null) {
            return iClasspathEntryArray;
        }
        ArrayList<IClasspathEntry> arrayList = new ArrayList<IClasspathEntry>(Arrays.asList(iClasspathEntryArray));
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            IClasspathEntry iClasspathEntry = JavaCore.newLibraryEntry((IPath)new Path(string2), null, null);
            if (arrayList.contains(iClasspathEntry)) continue;
            arrayList.add(iClasspathEntry);
        }
        return arrayList.toArray(new IClasspathEntry[arrayList.size()]);
    }

    public void cleanup(IJavaProject iJavaProject) throws GenerationException {
        if (null != iJavaProject) {
            this.cleanup(iJavaProject.getProject());
        }
    }

    private void cleanup(IProject iProject) throws GenerationException {
        try {
            if (this.projectCreated && null != iProject) {
                NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
                IFile iFile = iProject.getFile(".classpath");
                iFile.delete(true, (IProgressMonitor)nullProgressMonitor);
                iFile = iProject.getFile(".project");
                iFile.delete(true, (IProgressMonitor)nullProgressMonitor);
                iProject.delete(false, true, (IProgressMonitor)nullProgressMonitor);
            }
        }
        catch (CoreException coreException) {
            throw ExceptionFactory.createGenerationExceptionForToolsOnly(Messages.getText("ERR_PRJ_CLEANUP", new Object[0]), coreException, 10183, null, null);
        }
    }
}

