/*
 * Decompiled with CFR 0.152.
 */
package primitive.collection;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.Random;

public class IntList {
    private static final int DEFAULT = 1024;
    private static final double RESIZE = 1.8;
    private int[] underlyingArray;
    private int pos;

    public IntList() {
        this.clear();
    }

    public IntList(int n) {
        this.underlyingArray = new int[n];
    }

    public IntList(int[] nArray) {
        this.underlyingArray = nArray;
        this.pos = nArray.length;
    }

    public boolean add(int n) {
        this.ensureCapacity(1);
        this.underlyingArray[this.pos++] = n;
        return true;
    }

    public void add(int n, int n2) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean addAll(IntList intList) {
        this.ensureCapacity(intList.size());
        System.arraycopy(intList.underlyingArray, 0, this.underlyingArray, this.size(), intList.size());
        this.pos += intList.size();
        return true;
    }

    public boolean addAll(int[] nArray) {
        return this.addAll(nArray, 0, nArray.length);
    }

    public boolean addAll(int[] nArray, int n, int n2) {
        this.ensureCapacity(n2);
        System.arraycopy(nArray, n, this.underlyingArray, this.size(), n2);
        this.pos += nArray.length;
        return true;
    }

    public boolean addAll(int n, IntList intList) {
        throw new UnsupportedOperationException("TBD");
    }

    public void clear() {
        if (null == this.underlyingArray || 1024 != this.underlyingArray.length) {
            this.underlyingArray = new int[1024];
        }
        this.pos = 0;
    }

    public boolean contains(int n) {
        return this.indexOf(n) != -1;
    }

    public boolean containsAll(IntList intList) {
        throw new UnsupportedOperationException("TBD");
    }

    public int get(int n) {
        if (n >= this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return this.underlyingArray[n];
    }

    public int indexOf(int n) {
        for (int i = 0; i != this.size(); ++i) {
            if (n != this.underlyingArray[i]) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        for (int i = this.size() - 1; i != -1; --i) {
            if (n != this.underlyingArray[i]) continue;
            return i;
        }
        return -1;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new Iterator(this);
    }

    public Iterator iterator(int n) {
        return new Iterator(this, n);
    }

    public boolean remove(int n) {
        throw new UnsupportedOperationException("TBD");
    }

    public int removeIdx(int n) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean removeAll(IntList intList) {
        throw new UnsupportedOperationException("TBD");
    }

    public boolean retainAll(IntList intList) {
        throw new UnsupportedOperationException("TBD");
    }

    public int set(int n, int n2) {
        if (n < 0 || n >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.get(n);
        this.underlyingArray[n] = n2;
        return n3;
    }

    public int size() {
        return this.pos;
    }

    public IntList subList(int n, int n2) {
        if (n < 0 || n2 > this.size() || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2 - n;
        int[] nArray = new int[n3];
        System.arraycopy(this.underlyingArray, n, nArray, 0, n3);
        return new IntList(nArray);
    }

    public int[] toArray() {
        int[] nArray = new int[this.pos];
        System.arraycopy(this.underlyingArray, 0, nArray, 0, this.pos);
        return nArray;
    }

    private void ensureCapacity(int n) {
        int n2 = this.underlyingArray.length - this.pos;
        if (n2 < n) {
            this.resize(this.underlyingArray.length + n);
        }
    }

    private void resize(int n) {
        int n2 = this.max(n, (int)((double)this.underlyingArray.length * 1.8));
        int[] nArray = new int[n2];
        System.arraycopy(this.underlyingArray, 0, nArray, 0, this.pos);
        this.underlyingArray = nArray;
    }

    private int max(int n, int n2) {
        return n > n2 ? n : n2;
    }

    private static void p(Object object) {
        System.out.println(object);
    }

    public static void main(String[] stringArray) {
        long l = System.currentTimeMillis();
        IntList intList = new IntList();
        Random random = new Random(0L);
        byte[] byArray = new byte[1];
        for (int i = 0; i != 250000; ++i) {
            int n = random.nextInt();
            intList.add(n);
        }
        int[] nArray = intList.toArray();
        intList.addAll(nArray);
        IntList.p("ok...: " + intList.size() + " in: " + (System.currentTimeMillis() - l));
        l = System.currentTimeMillis();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i != 250000; ++i) {
            int n = random.nextInt();
            arrayList.add(new Integer(n));
        }
        arrayList.addAll(arrayList);
        IntList.p("ok...: " + arrayList.size() + " in: " + (System.currentTimeMillis() - l));
    }

    class Iterator {
        private IntList list;
        private int pos;

        public Iterator(IntList intList2) {
            this.list = intList2;
        }

        public Iterator(IntList intList2, int n) {
            if (n < 0 || n > intList2.size()) {
                throw new IndexOutOfBoundsException();
            }
            this.list = intList2;
            this.pos = n;
        }

        boolean hasNext() {
            return this.pos < this.list.size();
        }

        int next() {
            if (this.pos >= this.list.size() || this.pos < 0) {
                throw new NoSuchElementException();
            }
            return this.list.get(this.pos++);
        }

        void remove() {
            throw new UnsupportedOperationException("TBD");
        }
    }
}

