\name{DisplacementFieldTransform}
\alias{DisplacementFieldTransform}
\title{DisplacementFieldTransform}
\Rdversion{1.1}
\docType{class}
\description{
A dense deformable transform over a bounded spatial domain for 2D or
3D coordinates space.
DisplacementFieldTransform}
\details{
See:
itk::DisplacementFieldTransform
DisplacementFieldTransform}
%C++ includes: sitkDisplacementFieldTransform.h
\section{Methods}{
\describe{
\item{ DisplacementFieldTransform(const DisplacementFieldTransform &):}{}
\item{ DisplacementFieldTransform(const Transform &):}{}
\item{ DisplacementFieldTransform(Image &):}{
Consume an image to construct a displacement field transform.
WARNING:
The input displacement image is transferred to the constructed
transform object. The input image is modified to be a default
constructed Image object.
Image must be of sitkVectorFloat64 pixel type with the number of components
equal to the image dimension.
}
\item{ DisplacementFieldTransform(unsigned int dimensions):}{}
\item{Image GetDisplacementField() const:}{
Todo
The returned image should not directly modify the internal
displacement field.
}
\item{Image GetInverseDisplacementField() const:}{
Todo
The returned image is should not directly modify the internal
displacement field.
}
\item{std::string GetName() const override:}{
Name of this class
}
\item{Self SetDisplacementField(Image &):}{
Consume an image, and set the displacement field.
parameters
WARNING:
The ownership of the input displacement image is transferred to the
constructed transform object. The input image is modified to be a
default constructed Image object.
Image must be of sitkVectorFloat64 pixel type with the number of components
equal to the image dimension.
}
\item{Self SetInterpolator(InterpolatorEnum interp):}{
Set the interpolator used between the field voxels.
}
\item{Self SetInverseDisplacementField(Image &):}{
fixed parameter
}
\item{Self SetSmoothingBSplineOnUpdate(const std::vector< unsigned int > &numberOfControlPointsForUpdateField=std::vector< unsigned int >(3, 4), const std::vector< unsigned int > &numberOfControlPointsForTotalField=std::vector< unsigned int >(3, 4), bool enforceStationaryBoundary=true, unsigned int order=3):}{}
\item{Self SetSmoothingGaussianOnUpdate(double varianceForUpdateField=1.75, double varianceForTotalField=0.5):}{}
\item{Self SetSmoothingOff():}{}
\item{ ~DisplacementFieldTransform() override:}{}
}
}
