
use builtin;
use str;

set edit:completion:arg-completer[qsv] = {|@words|
    fn spaces {|n|
        builtin:repeat $n ' ' | str:join ''
    }
    fn cand {|text desc|
        edit:complex-candidate $text &display=$text' '(spaces (- 14 (wcswidth $text)))$desc
    }
    var command = 'qsv'
    for word $words[1..-1] {
        if (str:has-prefix $word '-') {
            break
        }
        set command = $command';'$word
    }
    var completions = [
        &'qsv'= {
            cand --list 'list'
            cand --envlist 'envlist'
            cand --update 'update'
            cand --updatenow 'updatenow'
            cand -V 'V'
            cand --version 'version'
            cand -h 'Print help'
            cand --help 'Print help'
            cand apply 'apply'
            cand behead 'behead'
            cand cat 'cat'
            cand clipboard 'clipboard'
            cand color 'color'
            cand count 'count'
            cand datefmt 'datefmt'
            cand dedup 'dedup'
            cand describegpt 'describegpt'
            cand diff 'diff'
            cand edit 'edit'
            cand enum 'enum'
            cand excel 'excel'
            cand exclude 'exclude'
            cand explode 'explode'
            cand extdedup 'extdedup'
            cand extsort 'extsort'
            cand fetch 'fetch'
            cand fetchpost 'fetchpost'
            cand fill 'fill'
            cand fixlengths 'fixlengths'
            cand flatten 'flatten'
            cand fmt 'fmt'
            cand foreach 'foreach'
            cand frequency 'frequency'
            cand geocode 'geocode'
            cand geoconvert 'geoconvert'
            cand headers 'headers'
            cand index 'index'
            cand input 'input'
            cand join 'join'
            cand joinp 'joinp'
            cand json 'json'
            cand jsonl 'jsonl'
            cand lens 'lens'
            cand luau 'luau'
            cand moarstats 'moarstats'
            cand partition 'partition'
            cand pivotp 'pivotp'
            cand pragmastat 'pragmastat'
            cand pro 'pro'
            cand prompt 'prompt'
            cand pseudo 'pseudo'
            cand py 'py'
            cand rename 'rename'
            cand replace 'replace'
            cand reverse 'reverse'
            cand safenames 'safenames'
            cand sample 'sample'
            cand schema 'schema'
            cand search 'search'
            cand searchset 'searchset'
            cand select 'select'
            cand slice 'slice'
            cand snappy 'snappy'
            cand sniff 'sniff'
            cand sort 'sort'
            cand sortcheck 'sortcheck'
            cand split 'split'
            cand sqlp 'sqlp'
            cand stats 'stats'
            cand table 'table'
            cand template 'template'
            cand to 'to'
            cand tojsonl 'tojsonl'
            cand transpose 'transpose'
            cand validate 'validate'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;apply'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -r 'r'
            cand --rename 'rename'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -o 'o'
            cand --output 'output'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
            cand calcconv 'calcconv'
            cand dynfmt 'dynfmt'
            cand emptyreplace 'emptyreplace'
            cand operations 'operations'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;apply;calcconv'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -r 'r'
            cand --rename 'rename'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -o 'o'
            cand --output 'output'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;apply;dynfmt'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -r 'r'
            cand --rename 'rename'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -o 'o'
            cand --output 'output'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;apply;emptyreplace'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -r 'r'
            cand --rename 'rename'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -o 'o'
            cand --output 'output'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;apply;operations'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -C 'C'
            cand --comparand 'comparand'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -r 'r'
            cand --rename 'rename'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand -o 'o'
            cand --output 'output'
            cand -R 'R'
            cand --replacement 'replacement'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;apply;help'= {
            cand calcconv 'calcconv'
            cand dynfmt 'dynfmt'
            cand emptyreplace 'emptyreplace'
            cand operations 'operations'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;apply;help;calcconv'= {
        }
        &'qsv;apply;help;dynfmt'= {
        }
        &'qsv;apply;help;emptyreplace'= {
        }
        &'qsv;apply;help;operations'= {
        }
        &'qsv;apply;help;help'= {
        }
        &'qsv;behead'= {
            cand -o 'o'
            cand --output 'output'
            cand -f 'f'
            cand --flexible 'flexible'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;cat'= {
            cand -N 'N'
            cand --group-name 'group-name'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -g 'g'
            cand --group 'group'
            cand -p 'p'
            cand --pad 'pad'
            cand --flexible 'flexible'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
            cand columns 'columns'
            cand rows 'rows'
            cand rowskey 'rowskey'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;cat;columns'= {
            cand -N 'N'
            cand --group-name 'group-name'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -g 'g'
            cand --group 'group'
            cand -p 'p'
            cand --pad 'pad'
            cand --flexible 'flexible'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;cat;rows'= {
            cand -N 'N'
            cand --group-name 'group-name'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -g 'g'
            cand --group 'group'
            cand -p 'p'
            cand --pad 'pad'
            cand --flexible 'flexible'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;cat;rowskey'= {
            cand -N 'N'
            cand --group-name 'group-name'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -g 'g'
            cand --group 'group'
            cand -p 'p'
            cand --pad 'pad'
            cand --flexible 'flexible'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;cat;help'= {
            cand columns 'columns'
            cand rows 'rows'
            cand rowskey 'rowskey'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;cat;help;columns'= {
        }
        &'qsv;cat;help;rows'= {
        }
        &'qsv;cat;help;rowskey'= {
        }
        &'qsv;cat;help;help'= {
        }
        &'qsv;clipboard'= {
            cand -s 's'
            cand --save 'save'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;color'= {
            cand -o 'o'
            cand --output 'output'
            cand -t 't'
            cand --title 'title'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --memcheck 'memcheck'
            cand -C 'C'
            cand --color 'color'
            cand -n 'n'
            cand --row-numbers 'row-numbers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;count'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --low-memory 'low-memory'
            cand --width 'width'
            cand --json 'json'
            cand -H 'H'
            cand --human-readable 'human-readable'
            cand --no-polars 'no-polars'
            cand -f 'f'
            cand --flexible 'flexible'
            cand --width-no-delims 'width-no-delims'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;datefmt'= {
            cand --default-tz 'default-tz'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --formatstr 'formatstr'
            cand -b 'b'
            cand --batch 'batch'
            cand --input-tz 'input-tz'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --output-tz 'output-tz'
            cand -R 'R'
            cand --ts-resolution 'ts-resolution'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --keep-zero-time 'keep-zero-time'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --utc 'utc'
            cand --zulu 'zulu'
            cand --prefer-dmy 'prefer-dmy'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;dedup'= {
            cand -D 'D'
            cand --dupes-output 'dupes-output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand -s 's'
            cand --select 'select'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --sorted 'sorted'
            cand -H 'H'
            cand --human-readable 'human-readable'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -N 'N'
            cand --numeric 'numeric'
            cand --memcheck 'memcheck'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;describegpt'= {
            cand --timeout 'timeout'
            cand --ckan-token 'ckan-token'
            cand --addl-props 'addl-props'
            cand --cache-dir 'cache-dir'
            cand --num-examples 'num-examples'
            cand --session-len 'session-len'
            cand --disk-cache-dir 'disk-cache-dir'
            cand --format 'format'
            cand -p 'p'
            cand --prompt 'prompt'
            cand -m 'm'
            cand --model 'model'
            cand --language 'language'
            cand --stats-options 'stats-options'
            cand --sql-results 'sql-results'
            cand --session 'session'
            cand --ckan-api 'ckan-api'
            cand -o 'o'
            cand --output 'output'
            cand --truncate-str 'truncate-str'
            cand --sample-size 'sample-size'
            cand --tag-vocab 'tag-vocab'
            cand --prompt-file 'prompt-file'
            cand --export-prompt 'export-prompt'
            cand --enum-threshold 'enum-threshold'
            cand --num-tags 'num-tags'
            cand -u 'u'
            cand --base-url 'base-url'
            cand --freq-options 'freq-options'
            cand --addl-cols-list 'addl-cols-list'
            cand -t 't'
            cand --max-tokens 'max-tokens'
            cand --user-agent 'user-agent'
            cand -k 'k'
            cand --api-key 'api-key'
            cand --description 'description'
            cand --fewshot-examples 'fewshot-examples'
            cand --addl-cols 'addl-cols'
            cand --fresh 'fresh'
            cand -A 'A'
            cand --all 'all'
            cand --no-cache 'no-cache'
            cand --forget 'forget'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --dictionary 'dictionary'
            cand --tags 'tags'
            cand --flush-cache 'flush-cache'
            cand --redis-cache 'redis-cache'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;diff'= {
            cand --delimiter-right 'delimiter-right'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -k 'k'
            cand --key 'key'
            cand --delimiter-left 'delimiter-left'
            cand --sort-columns 'sort-columns'
            cand -o 'o'
            cand --output 'output'
            cand --delimiter-output 'delimiter-output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --drop-equal-fields 'drop-equal-fields'
            cand --no-headers-right 'no-headers-right'
            cand --no-headers-left 'no-headers-left'
            cand --no-headers-output 'no-headers-output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;edit'= {
            cand -o 'o'
            cand --output 'output'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -i 'i'
            cand --in-place 'in-place'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;enum'= {
            cand --copy 'copy'
            cand --increment 'increment'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -o 'o'
            cand --output 'output'
            cand --hash 'hash'
            cand --start 'start'
            cand --constant 'constant'
            cand --uuid7 'uuid7'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --uuid4 'uuid4'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;excel'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --table 'table'
            cand --cell 'cell'
            cand -s 's'
            cand --sheet 'sheet'
            cand --range 'range'
            cand -o 'o'
            cand --output 'output'
            cand --metadata 'metadata'
            cand --date-format 'date-format'
            cand --header-row 'header-row'
            cand --error-format 'error-format'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --flexible 'flexible'
            cand --keep-zero-time 'keep-zero-time'
            cand --trim 'trim'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;exclude'= {
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -v 'v'
            cand --invert 'invert'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;explode'= {
            cand -r 'r'
            cand --rename 'rename'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;extdedup'= {
            cand -s 's'
            cand --select 'select'
            cand --memory-limit 'memory-limit'
            cand -D 'D'
            cand --dupes-output 'dupes-output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --temp-dir 'temp-dir'
            cand -H 'H'
            cand --human-readable 'human-readable'
            cand --no-output 'no-output'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;extsort'= {
            cand --tmp-dir 'tmp-dir'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --select 'select'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --memory-limit 'memory-limit'
            cand -R 'R'
            cand --reverse 'reverse'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fetch'= {
            cand --rate-limit 'rate-limit'
            cand --disk-cache-dir 'disk-cache-dir'
            cand --mem-cache-size 'mem-cache-size'
            cand --max-errors 'max-errors'
            cand --jaqfile 'jaqfile'
            cand -o 'o'
            cand --output 'output'
            cand --max-retries 'max-retries'
            cand -H 'H'
            cand --http-header 'http-header'
            cand --jaq 'jaq'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --url-template 'url-template'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand --report 'report'
            cand --pretty 'pretty'
            cand --no-cache 'no-cache'
            cand --disk-cache 'disk-cache'
            cand --store-error 'store-error'
            cand --redis-cache 'redis-cache'
            cand --cache-error 'cache-error'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --flush-cache 'flush-cache'
            cand --cookies 'cookies'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fetchpost'= {
            cand --user-agent 'user-agent'
            cand --disk-cache-dir 'disk-cache-dir'
            cand --max-errors 'max-errors'
            cand --mem-cache-size 'mem-cache-size'
            cand -H 'H'
            cand --http-header 'http-header'
            cand -t 't'
            cand --payload-tpl 'payload-tpl'
            cand --jaqfile 'jaqfile'
            cand --content-type 'content-type'
            cand -j 'j'
            cand --globals-json 'globals-json'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --max-retries 'max-retries'
            cand -o 'o'
            cand --output 'output'
            cand --timeout 'timeout'
            cand --report 'report'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --rate-limit 'rate-limit'
            cand --jaq 'jaq'
            cand --compress 'compress'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --pretty 'pretty'
            cand --cookies 'cookies'
            cand --cache-error 'cache-error'
            cand --store-error 'store-error'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --disk-cache 'disk-cache'
            cand --no-cache 'no-cache'
            cand --redis-cache 'redis-cache'
            cand --flush-cache 'flush-cache'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fill'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand -g 'g'
            cand --groupby 'groupby'
            cand -v 'v'
            cand --default 'default'
            cand -f 'f'
            cand --first 'first'
            cand -b 'b'
            cand --backfill 'backfill'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fixlengths'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --quote 'quote'
            cand -l 'l'
            cand --length 'length'
            cand -o 'o'
            cand --output 'output'
            cand -i 'i'
            cand --insert 'insert'
            cand --escape 'escape'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -r 'r'
            cand --remove-empty 'remove-empty'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;flatten'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -f 'f'
            cand --field-separator 'field-separator'
            cand -c 'c'
            cand --condense 'condense'
            cand -s 's'
            cand --separator 'separator'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;fmt'= {
            cand -o 'o'
            cand --output 'output'
            cand --escape 'escape'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -t 't'
            cand --out-delimiter 'out-delimiter'
            cand --quote 'quote'
            cand --ascii 'ascii'
            cand --crlf 'crlf'
            cand --quote-always 'quote-always'
            cand --quote-never 'quote-never'
            cand --no-final-newline 'no-final-newline'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;foreach'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --dry-run 'dry-run'
            cand -c 'c'
            cand --new-column 'new-column'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -u 'u'
            cand --unify 'unify'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;frequency'= {
            cand -s 's'
            cand --select 'select'
            cand --other-text 'other-text'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --no-float 'no-float'
            cand --lmt-threshold 'lmt-threshold'
            cand --high-card-threshold 'high-card-threshold'
            cand --pct-dec-places 'pct-dec-places'
            cand --high-card-pct 'high-card-pct'
            cand --all-unique-text 'all-unique-text'
            cand --null-text 'null-text'
            cand -o 'o'
            cand --output 'output'
            cand -r 'r'
            cand --rank-strategy 'rank-strategy'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --stats-filter 'stats-filter'
            cand --weight 'weight'
            cand -u 'u'
            cand --unq-limit 'unq-limit'
            cand -l 'l'
            cand --limit 'limit'
            cand --json 'json'
            cand --memcheck 'memcheck'
            cand --pct-nulls 'pct-nulls'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --other-sorted 'other-sorted'
            cand --force 'force'
            cand --no-nulls 'no-nulls'
            cand -a 'a'
            cand --asc 'asc'
            cand --toon 'toon'
            cand --vis-whitespace 'vis-whitespace'
            cand --no-stats 'no-stats'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --null-sorted 'null-sorted'
            cand --pretty-json 'pretty-json'
            cand --no-trim 'no-trim'
            cand --no-other 'no-other'
            cand --frequency-jsonl 'frequency-jsonl'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
            cand countryinfo 'countryinfo'
            cand countryinfonow 'countryinfonow'
            cand index-check 'index-check'
            cand index-load 'index-load'
            cand index-reset 'index-reset'
            cand index-update 'index-update'
            cand iplookup 'iplookup'
            cand iplookupnow 'iplookupnow'
            cand reverse 'reverse'
            cand reversenow 'reversenow'
            cand suggest 'suggest'
            cand suggestnow 'suggestnow'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;geocode;countryinfo'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;countryinfonow'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;index-check'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;index-load'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;index-reset'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;index-update'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;iplookup'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;iplookupnow'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;reverse'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;reversenow'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;suggest'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;suggestnow'= {
            cand -k 'k'
            cand --k_weight 'k_weight'
            cand --min-score 'min-score'
            cand -f 'f'
            cand --formatstr 'formatstr'
            cand --invalid-result 'invalid-result'
            cand -b 'b'
            cand --batch 'batch'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --country 'country'
            cand --admin1 'admin1'
            cand -l 'l'
            cand --language 'language'
            cand --cache-dir 'cache-dir'
            cand --languages 'languages'
            cand --timeout 'timeout'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -c 'c'
            cand --new-column 'new-column'
            cand --cities-url 'cities-url'
            cand -r 'r'
            cand --rename 'rename'
            cand -o 'o'
            cand --output 'output'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --force 'force'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;geocode;help'= {
            cand countryinfo 'countryinfo'
            cand countryinfonow 'countryinfonow'
            cand index-check 'index-check'
            cand index-load 'index-load'
            cand index-reset 'index-reset'
            cand index-update 'index-update'
            cand iplookup 'iplookup'
            cand iplookupnow 'iplookupnow'
            cand reverse 'reverse'
            cand reversenow 'reversenow'
            cand suggest 'suggest'
            cand suggestnow 'suggestnow'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;geocode;help;countryinfo'= {
        }
        &'qsv;geocode;help;countryinfonow'= {
        }
        &'qsv;geocode;help;index-check'= {
        }
        &'qsv;geocode;help;index-load'= {
        }
        &'qsv;geocode;help;index-reset'= {
        }
        &'qsv;geocode;help;index-update'= {
        }
        &'qsv;geocode;help;iplookup'= {
        }
        &'qsv;geocode;help;iplookupnow'= {
        }
        &'qsv;geocode;help;reverse'= {
        }
        &'qsv;geocode;help;reversenow'= {
        }
        &'qsv;geocode;help;suggest'= {
        }
        &'qsv;geocode;help;suggestnow'= {
        }
        &'qsv;geocode;help;help'= {
        }
        &'qsv;geoconvert'= {
            cand -l 'l'
            cand --max-length 'max-length'
            cand -g 'g'
            cand --geometry 'geometry'
            cand -x 'x'
            cand --longitude 'longitude'
            cand -o 'o'
            cand --output 'output'
            cand -y 'y'
            cand --latitude 'latitude'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;headers'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --just-names 'just-names'
            cand --intersect 'intersect'
            cand -J 'J'
            cand --just-count 'just-count'
            cand --trim 'trim'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;index'= {
            cand -o 'o'
            cand --output 'output'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;input'= {
            cand --quote 'quote'
            cand --quote-style 'quote-style'
            cand --encoding-errors 'encoding-errors'
            cand --skip-lastlines 'skip-lastlines'
            cand --comment 'comment'
            cand --escape 'escape'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand --skip-lines 'skip-lines'
            cand --trim-headers 'trim-headers'
            cand --trim-fields 'trim-fields'
            cand --auto-skip 'auto-skip'
            cand --no-quoting 'no-quoting'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;join'= {
            cand --keys-output 'keys-output'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --left 'left'
            cand --left-anti 'left-anti'
            cand --full 'full'
            cand --cross 'cross'
            cand --right-semi 'right-semi'
            cand --left-semi 'left-semi'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --right-anti 'right-anti'
            cand --right 'right'
            cand --nulls 'nulls'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -z 'z'
            cand --ignore-leading-zeros 'ignore-leading-zeros'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;joinp'= {
            cand --tolerance 'tolerance'
            cand --left_by 'left_by'
            cand --filter-left 'filter-left'
            cand --infer-len 'infer-len'
            cand --date-format 'date-format'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --cache-schema 'cache-schema'
            cand --null-value 'null-value'
            cand --datetime-format 'datetime-format'
            cand --filter-right 'filter-right'
            cand --strategy 'strategy'
            cand --right_by 'right_by'
            cand --maintain-order 'maintain-order'
            cand --float-precision 'float-precision'
            cand --sql-filter 'sql-filter'
            cand --non-equi 'non-equi'
            cand -o 'o'
            cand --output 'output'
            cand --validate 'validate'
            cand --time-format 'time-format'
            cand -N 'N'
            cand --norm-unicode 'norm-unicode'
            cand --decimal-comma 'decimal-comma'
            cand --no-optimizations 'no-optimizations'
            cand --asof 'asof'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --right-semi 'right-semi'
            cand --right 'right'
            cand --right-anti 'right-anti'
            cand --nulls 'nulls'
            cand --streaming 'streaming'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --low-memory 'low-memory'
            cand --try-parsedates 'try-parsedates'
            cand --full 'full'
            cand --cross 'cross'
            cand --coalesce 'coalesce'
            cand -X 'X'
            cand --allow-exact-matches 'allow-exact-matches'
            cand --left-anti 'left-anti'
            cand --left-semi 'left-semi'
            cand -z 'z'
            cand --ignore-leading-zeros 'ignore-leading-zeros'
            cand --ignore-errors 'ignore-errors'
            cand --left 'left'
            cand --no-sort 'no-sort'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;json'= {
            cand -o 'o'
            cand --output 'output'
            cand --jaq 'jaq'
            cand -s 's'
            cand --select 'select'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;jsonl'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -b 'b'
            cand --batch 'batch'
            cand -o 'o'
            cand --output 'output'
            cand --ignore-errors 'ignore-errors'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;lens'= {
            cand -W 'W'
            cand --wrap-mode 'wrap-mode'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -f 'f'
            cand --freeze-columns 'freeze-columns'
            cand --echo-column 'echo-column'
            cand --filter 'filter'
            cand --find 'find'
            cand -P 'P'
            cand --prompt 'prompt'
            cand --columns 'columns'
            cand -t 't'
            cand --tab-separated 'tab-separated'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --no-headers 'no-headers'
            cand -m 'm'
            cand --monochrome 'monochrome'
            cand -A 'A'
            cand --auto-reload 'auto-reload'
            cand -S 'S'
            cand --streaming-stdin 'streaming-stdin'
            cand --debug 'debug'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;luau'= {
            cand --cache-dir 'cache-dir'
            cand -B 'B'
            cand --begin 'begin'
            cand --ckan-api 'ckan-api'
            cand --timeout 'timeout'
            cand -o 'o'
            cand --output 'output'
            cand --max-errors 'max-errors'
            cand -E 'E'
            cand --end 'end'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --ckan-token 'ckan-token'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -g 'g'
            cand --no-globals 'no-globals'
            cand --colindex 'colindex'
            cand -r 'r'
            cand --remap 'remap'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
            cand filter 'filter'
            cand map 'map'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;luau;filter'= {
            cand --cache-dir 'cache-dir'
            cand -B 'B'
            cand --begin 'begin'
            cand --ckan-api 'ckan-api'
            cand --timeout 'timeout'
            cand -o 'o'
            cand --output 'output'
            cand --max-errors 'max-errors'
            cand -E 'E'
            cand --end 'end'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --ckan-token 'ckan-token'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -g 'g'
            cand --no-globals 'no-globals'
            cand --colindex 'colindex'
            cand -r 'r'
            cand --remap 'remap'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;luau;map'= {
            cand --cache-dir 'cache-dir'
            cand -B 'B'
            cand --begin 'begin'
            cand --ckan-api 'ckan-api'
            cand --timeout 'timeout'
            cand -o 'o'
            cand --output 'output'
            cand --max-errors 'max-errors'
            cand -E 'E'
            cand --end 'end'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --ckan-token 'ckan-token'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -g 'g'
            cand --no-globals 'no-globals'
            cand --colindex 'colindex'
            cand -r 'r'
            cand --remap 'remap'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;luau;help'= {
            cand filter 'filter'
            cand map 'map'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;luau;help;filter'= {
        }
        &'qsv;luau;help;map'= {
        }
        &'qsv;luau;help;help'= {
        }
        &'qsv;moarstats'= {
            cand -T 'T'
            cand --join-type 'join-type'
            cand --stats-options 'stats-options'
            cand -o 'o'
            cand --output 'output'
            cand --round 'round'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --xsd-gdate-scan 'xsd-gdate-scan'
            cand -C 'C'
            cand --cardinality-threshold 'cardinality-threshold'
            cand -e 'e'
            cand --epsilon 'epsilon'
            cand --pct-thresholds 'pct-thresholds'
            cand -J 'J'
            cand --join-inputs 'join-inputs'
            cand -K 'K'
            cand --join-keys 'join-keys'
            cand -S 'S'
            cand --bivariate-stats 'bivariate-stats'
            cand --force 'force'
            cand --advanced 'advanced'
            cand --use-percentiles 'use-percentiles'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -B 'B'
            cand --bivariate 'bivariate'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;partition'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --limit 'limit'
            cand --filename 'filename'
            cand -p 'p'
            cand --prefix-length 'prefix-length'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --drop 'drop'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pivotp'= {
            cand -i 'i'
            cand --index 'index'
            cand --col-separator 'col-separator'
            cand -o 'o'
            cand --output 'output'
            cand -a 'a'
            cand --agg 'agg'
            cand --infer-len 'infer-len'
            cand -v 'v'
            cand --values 'values'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --validate 'validate'
            cand --try-parsedates 'try-parsedates'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --ignore-errors 'ignore-errors'
            cand --maintain-order 'maintain-order'
            cand --sort-columns 'sort-columns'
            cand --decimal-comma 'decimal-comma'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pragmastat'= {
            cand -s 's'
            cand --select 'select'
            cand -o 'o'
            cand --output 'output'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -m 'm'
            cand --misrate 'misrate'
            cand -t 't'
            cand --twosample 'twosample'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --memcheck 'memcheck'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pro'= {
            cand -h 'Print help'
            cand --help 'Print help'
            cand lens 'lens'
            cand workflow 'workflow'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;pro;lens'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pro;workflow'= {
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pro;help'= {
            cand lens 'lens'
            cand workflow 'workflow'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;pro;help;lens'= {
        }
        &'qsv;pro;help;workflow'= {
        }
        &'qsv;pro;help;help'= {
        }
        &'qsv;prompt'= {
            cand -m 'm'
            cand --msg 'msg'
            cand -d 'd'
            cand --workdir 'workdir'
            cand --save-fname 'save-fname'
            cand -F 'F'
            cand --filters 'filters'
            cand -o 'o'
            cand --output 'output'
            cand --base-delay-ms 'base-delay-ms'
            cand -f 'f'
            cand --fd-output 'fd-output'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;pseudo'= {
            cand --increment 'increment'
            cand -o 'o'
            cand --output 'output'
            cand --formatstr 'formatstr'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --start 'start'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;py'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -f 'f'
            cand --helper 'helper'
            cand -o 'o'
            cand --output 'output'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
            cand filter 'filter'
            cand map 'map'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;py;filter'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -f 'f'
            cand --helper 'helper'
            cand -o 'o'
            cand --output 'output'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;py;map'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -f 'f'
            cand --helper 'helper'
            cand -o 'o'
            cand --output 'output'
            cand -b 'b'
            cand --batch 'batch'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;py;help'= {
            cand filter 'filter'
            cand map 'map'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;py;help;filter'= {
        }
        &'qsv;py;help;map'= {
        }
        &'qsv;py;help;help'= {
        }
        &'qsv;rename'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand --pairwise 'pairwise'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;replace'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --select 'select'
            cand -o 'o'
            cand --output 'output'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --size-limit 'size-limit'
            cand --dfa-size-limit 'dfa-size-limit'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --exact 'exact'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -u 'u'
            cand --unicode 'unicode'
            cand --literal 'literal'
            cand --not-one 'not-one'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;reverse'= {
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --memcheck 'memcheck'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;safenames'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --prefix 'prefix'
            cand --mode 'mode'
            cand -o 'o'
            cand --output 'output'
            cand --reserved 'reserved'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;sample'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --rng 'rng'
            cand --ts-aggregate 'ts-aggregate'
            cand --cluster 'cluster'
            cand --seed 'seed'
            cand --systematic 'systematic'
            cand --timeout 'timeout'
            cand --max-size 'max-size'
            cand --ts-input-tz 'ts-input-tz'
            cand -o 'o'
            cand --output 'output'
            cand --stratified 'stratified'
            cand --ts-adaptive 'ts-adaptive'
            cand --ts-interval 'ts-interval'
            cand --timeseries 'timeseries'
            cand --ts-start 'ts-start'
            cand --user-agent 'user-agent'
            cand --weighted 'weighted'
            cand --bernoulli 'bernoulli'
            cand --force 'force'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --ts-prefer-dmy 'ts-prefer-dmy'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;schema'= {
            cand --dates-whitelist 'dates-whitelist'
            cand --pattern-columns 'pattern-columns'
            cand --enum-threshold 'enum-threshold'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --strict-formats 'strict-formats'
            cand --prefer-dmy 'prefer-dmy'
            cand --memcheck 'memcheck'
            cand --force 'force'
            cand --strict-dates 'strict-dates'
            cand --polars 'polars'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --stdout 'stdout'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;search'= {
            cand --preview-match 'preview-match'
            cand -s 's'
            cand --select 'select'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --dfa-size-limit 'dfa-size-limit'
            cand --size-limit 'size-limit'
            cand -f 'f'
            cand --flag 'flag'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -u 'u'
            cand --unicode 'unicode'
            cand -c 'c'
            cand --count 'count'
            cand --json 'json'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --not-one 'not-one'
            cand -v 'v'
            cand --invert-match 'invert-match'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --exact 'exact'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -Q 'Q'
            cand --quick 'quick'
            cand --literal 'literal'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;searchset'= {
            cand --jobs 'jobs'
            cand --size-limit 'size-limit'
            cand --dfa-size-limit 'dfa-size-limit'
            cand -s 's'
            cand --select 'select'
            cand -f 'f'
            cand --flag 'flag'
            cand --unmatched-output 'unmatched-output'
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand --exact 'exact'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -u 'u'
            cand --unicode 'unicode'
            cand -j 'j'
            cand --json 'json'
            cand --literal 'literal'
            cand -v 'v'
            cand --invert-match 'invert-match'
            cand --flag-matches-only 'flag-matches-only'
            cand -Q 'Q'
            cand --quick 'quick'
            cand -c 'c'
            cand --count 'count'
            cand --not-one 'not-one'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;select'= {
            cand -o 'o'
            cand --output 'output'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --seed 'seed'
            cand -R 'R'
            cand --random 'random'
            cand -S 'S'
            cand --sort 'sort'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;slice'= {
            cand -e 'e'
            cand --end 'end'
            cand -o 'o'
            cand --output 'output'
            cand -s 's'
            cand --start 'start'
            cand -i 'i'
            cand --index 'index'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -l 'l'
            cand --len 'len'
            cand --invert 'invert'
            cand --json 'json'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -o 'o'
            cand --output 'output'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
            cand check 'check'
            cand compress 'compress'
            cand decompress 'decompress'
            cand validate 'validate'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;snappy;check'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -o 'o'
            cand --output 'output'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy;compress'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -o 'o'
            cand --output 'output'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy;decompress'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -o 'o'
            cand --output 'output'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy;validate'= {
            cand -j 'j'
            cand --jobs 'jobs'
            cand --user-agent 'user-agent'
            cand --timeout 'timeout'
            cand -o 'o'
            cand --output 'output'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;snappy;help'= {
            cand check 'check'
            cand compress 'compress'
            cand decompress 'decompress'
            cand validate 'validate'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;snappy;help;check'= {
        }
        &'qsv;snappy;help;compress'= {
        }
        &'qsv;snappy;help;decompress'= {
        }
        &'qsv;snappy;help;validate'= {
        }
        &'qsv;snappy;help;help'= {
        }
        &'qsv;sniff'= {
            cand --timeout 'timeout'
            cand --save-urlsample 'save-urlsample'
            cand --sample 'sample'
            cand --quote 'quote'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --user-agent 'user-agent'
            cand --pretty-json 'pretty-json'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --no-infer 'no-infer'
            cand --prefer-dmy 'prefer-dmy'
            cand --harvest-mode 'harvest-mode'
            cand --just-mime 'just-mime'
            cand --json 'json'
            cand --stats-types 'stats-types'
            cand -Q 'Q'
            cand --quick 'quick'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;sort'= {
            cand --seed 'seed'
            cand -o 'o'
            cand --output 'output'
            cand --rng 'rng'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -s 's'
            cand --select 'select'
            cand --natural 'natural'
            cand --memcheck 'memcheck'
            cand --faster 'faster'
            cand --random 'random'
            cand -N 'N'
            cand --numeric 'numeric'
            cand -u 'u'
            cand --unique 'unique'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -R 'R'
            cand --reverse 'reverse'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;sortcheck'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --select 'select'
            cand --pretty-json 'pretty-json'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --json 'json'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --all 'all'
            cand -i 'i'
            cand --ignore-case 'ignore-case'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;split'= {
            cand --pad 'pad'
            cand --filename 'filename'
            cand -c 'c'
            cand --chunks 'chunks'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -s 's'
            cand --size 'size'
            cand -k 'k'
            cand --kb-size 'kb-size'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --filter 'filter'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --filter-cleanup 'filter-cleanup'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --filter-ignore-errors 'filter-ignore-errors'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;sqlp'= {
            cand -o 'o'
            cand --output 'output'
            cand --infer-len 'infer-len'
            cand --compress-level 'compress-level'
            cand --compression 'compression'
            cand --datetime-format 'datetime-format'
            cand --wnull-value 'wnull-value'
            cand --float-precision 'float-precision'
            cand --format 'format'
            cand --rnull-values 'rnull-values'
            cand --time-format 'time-format'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --date-format 'date-format'
            cand --ignore-errors 'ignore-errors'
            cand --truncate-ragged-lines 'truncate-ragged-lines'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --low-memory 'low-memory'
            cand --decimal-comma 'decimal-comma'
            cand --cache-schema 'cache-schema'
            cand --streaming 'streaming'
            cand --statistics 'statistics'
            cand --no-optimizations 'no-optimizations'
            cand --try-parsedates 'try-parsedates'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;stats'= {
            cand -o 'o'
            cand --output 'output'
            cand --boolean-patterns 'boolean-patterns'
            cand --weight 'weight'
            cand --dates-whitelist 'dates-whitelist'
            cand --percentile-list 'percentile-list'
            cand -c 'c'
            cand --cache-threshold 'cache-threshold'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -s 's'
            cand --select 'select'
            cand --round 'round'
            cand --vis-whitespace 'vis-whitespace'
            cand --nulls 'nulls'
            cand --mad 'mad'
            cand --percentiles 'percentiles'
            cand --typesonly 'typesonly'
            cand --infer-dates 'infer-dates'
            cand --quartiles 'quartiles'
            cand --cardinality 'cardinality'
            cand --stats-jsonl 'stats-jsonl'
            cand --infer-boolean 'infer-boolean'
            cand --prefer-dmy 'prefer-dmy'
            cand -E 'E'
            cand --everything 'everything'
            cand --mode 'mode'
            cand --median 'median'
            cand --memcheck 'memcheck'
            cand --force 'force'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;table'= {
            cand -w 'w'
            cand --width 'width'
            cand -c 'c'
            cand --condense 'condense'
            cand -a 'a'
            cand --align 'align'
            cand -p 'p'
            cand --pad 'pad'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -o 'o'
            cand --output 'output'
            cand --memcheck 'memcheck'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;template'= {
            cand --timeout 'timeout'
            cand --ckan-api 'ckan-api'
            cand -j 'j'
            cand --globals-json 'globals-json'
            cand --cache-dir 'cache-dir'
            cand -t 't'
            cand --template-file 'template-file'
            cand --template 'template'
            cand --outfilename 'outfilename'
            cand --customfilter-error 'customfilter-error'
            cand -o 'o'
            cand --output 'output'
            cand --ckan-token 'ckan-token'
            cand --outsubdir-size 'outsubdir-size'
            cand --delimiter 'delimiter'
            cand --jobs 'jobs'
            cand -b 'b'
            cand --batch 'batch'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand --drop 'drop'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -a 'a'
            cand --stats 'stats'
            cand -u 'u'
            cand --dump 'dump'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
            cand datapackage 'datapackage'
            cand ods 'ods'
            cand postgres 'postgres'
            cand sqlite 'sqlite'
            cand xlsx 'xlsx'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;to;datapackage'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand --drop 'drop'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -a 'a'
            cand --stats 'stats'
            cand -u 'u'
            cand --dump 'dump'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;ods'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand --drop 'drop'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -a 'a'
            cand --stats 'stats'
            cand -u 'u'
            cand --dump 'dump'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;postgres'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand --drop 'drop'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -a 'a'
            cand --stats 'stats'
            cand -u 'u'
            cand --dump 'dump'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;sqlite'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand --drop 'drop'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -a 'a'
            cand --stats 'stats'
            cand -u 'u'
            cand --dump 'dump'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;xlsx'= {
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -s 's'
            cand --schema 'schema'
            cand -p 'p'
            cand --separator 'separator'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -c 'c'
            cand --stats-csv 'stats-csv'
            cand -k 'k'
            cand --print-package 'print-package'
            cand -q 'q'
            cand --quiet 'quiet'
            cand -A 'A'
            cand --all-strings 'all-strings'
            cand --drop 'drop'
            cand -e 'e'
            cand --evolve 'evolve'
            cand -a 'a'
            cand --stats 'stats'
            cand -u 'u'
            cand --dump 'dump'
            cand -i 'i'
            cand --pipe 'pipe'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;to;help'= {
            cand datapackage 'datapackage'
            cand ods 'ods'
            cand postgres 'postgres'
            cand sqlite 'sqlite'
            cand xlsx 'xlsx'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;to;help;datapackage'= {
        }
        &'qsv;to;help;ods'= {
        }
        &'qsv;to;help;postgres'= {
        }
        &'qsv;to;help;sqlite'= {
        }
        &'qsv;to;help;xlsx'= {
        }
        &'qsv;to;help;help'= {
        }
        &'qsv;tojsonl'= {
            cand -b 'b'
            cand --batch 'batch'
            cand -o 'o'
            cand --output 'output'
            cand -j 'j'
            cand --jobs 'jobs'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --memcheck 'memcheck'
            cand --no-boolean 'no-boolean'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --trim 'trim'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;transpose'= {
            cand -o 'o'
            cand --output 'output'
            cand -s 's'
            cand --select 'select'
            cand --long 'long'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand -m 'm'
            cand --multipass 'multipass'
            cand --memcheck 'memcheck'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;validate'= {
            cand -b 'b'
            cand --batch 'batch'
            cand --backtrack-limit 'backtrack-limit'
            cand --size-limit 'size-limit'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --dfa-size-limit 'dfa-size-limit'
            cand --valid 'valid'
            cand --cache-dir 'cache-dir'
            cand --email-min-subdomains 'email-min-subdomains'
            cand --valid-output 'valid-output'
            cand --timeout 'timeout'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --ckan-token 'ckan-token'
            cand --invalid 'invalid'
            cand --ckan-api 'ckan-api'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --json 'json'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --fail-fast 'fail-fast'
            cand --fancy-regex 'fancy-regex'
            cand --pretty-json 'pretty-json'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --no-format-validation 'no-format-validation'
            cand --email-display-text 'email-display-text'
            cand --trim 'trim'
            cand --email-required-tld 'email-required-tld'
            cand --email-domain-literal 'email-domain-literal'
            cand -h 'Print help'
            cand --help 'Print help'
            cand schema 'schema'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;validate;schema'= {
            cand -b 'b'
            cand --batch 'batch'
            cand --backtrack-limit 'backtrack-limit'
            cand --size-limit 'size-limit'
            cand -d 'd'
            cand --delimiter 'delimiter'
            cand --dfa-size-limit 'dfa-size-limit'
            cand --valid 'valid'
            cand --cache-dir 'cache-dir'
            cand --email-min-subdomains 'email-min-subdomains'
            cand --valid-output 'valid-output'
            cand --timeout 'timeout'
            cand -j 'j'
            cand --jobs 'jobs'
            cand --ckan-token 'ckan-token'
            cand --invalid 'invalid'
            cand --ckan-api 'ckan-api'
            cand -n 'n'
            cand --no-headers 'no-headers'
            cand --json 'json'
            cand -p 'p'
            cand --progressbar 'progressbar'
            cand --fail-fast 'fail-fast'
            cand --fancy-regex 'fancy-regex'
            cand --pretty-json 'pretty-json'
            cand -q 'q'
            cand --quiet 'quiet'
            cand --no-format-validation 'no-format-validation'
            cand --email-display-text 'email-display-text'
            cand --trim 'trim'
            cand --email-required-tld 'email-required-tld'
            cand --email-domain-literal 'email-domain-literal'
            cand -h 'Print help'
            cand --help 'Print help'
        }
        &'qsv;validate;help'= {
            cand schema 'schema'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;validate;help;schema'= {
        }
        &'qsv;validate;help;help'= {
        }
        &'qsv;help'= {
            cand apply 'apply'
            cand behead 'behead'
            cand cat 'cat'
            cand clipboard 'clipboard'
            cand color 'color'
            cand count 'count'
            cand datefmt 'datefmt'
            cand dedup 'dedup'
            cand describegpt 'describegpt'
            cand diff 'diff'
            cand edit 'edit'
            cand enum 'enum'
            cand excel 'excel'
            cand exclude 'exclude'
            cand explode 'explode'
            cand extdedup 'extdedup'
            cand extsort 'extsort'
            cand fetch 'fetch'
            cand fetchpost 'fetchpost'
            cand fill 'fill'
            cand fixlengths 'fixlengths'
            cand flatten 'flatten'
            cand fmt 'fmt'
            cand foreach 'foreach'
            cand frequency 'frequency'
            cand geocode 'geocode'
            cand geoconvert 'geoconvert'
            cand headers 'headers'
            cand index 'index'
            cand input 'input'
            cand join 'join'
            cand joinp 'joinp'
            cand json 'json'
            cand jsonl 'jsonl'
            cand lens 'lens'
            cand luau 'luau'
            cand moarstats 'moarstats'
            cand partition 'partition'
            cand pivotp 'pivotp'
            cand pragmastat 'pragmastat'
            cand pro 'pro'
            cand prompt 'prompt'
            cand pseudo 'pseudo'
            cand py 'py'
            cand rename 'rename'
            cand replace 'replace'
            cand reverse 'reverse'
            cand safenames 'safenames'
            cand sample 'sample'
            cand schema 'schema'
            cand search 'search'
            cand searchset 'searchset'
            cand select 'select'
            cand slice 'slice'
            cand snappy 'snappy'
            cand sniff 'sniff'
            cand sort 'sort'
            cand sortcheck 'sortcheck'
            cand split 'split'
            cand sqlp 'sqlp'
            cand stats 'stats'
            cand table 'table'
            cand template 'template'
            cand to 'to'
            cand tojsonl 'tojsonl'
            cand transpose 'transpose'
            cand validate 'validate'
            cand help 'Print this message or the help of the given subcommand(s)'
        }
        &'qsv;help;apply'= {
            cand calcconv 'calcconv'
            cand dynfmt 'dynfmt'
            cand emptyreplace 'emptyreplace'
            cand operations 'operations'
        }
        &'qsv;help;apply;calcconv'= {
        }
        &'qsv;help;apply;dynfmt'= {
        }
        &'qsv;help;apply;emptyreplace'= {
        }
        &'qsv;help;apply;operations'= {
        }
        &'qsv;help;behead'= {
        }
        &'qsv;help;cat'= {
            cand columns 'columns'
            cand rows 'rows'
            cand rowskey 'rowskey'
        }
        &'qsv;help;cat;columns'= {
        }
        &'qsv;help;cat;rows'= {
        }
        &'qsv;help;cat;rowskey'= {
        }
        &'qsv;help;clipboard'= {
        }
        &'qsv;help;color'= {
        }
        &'qsv;help;count'= {
        }
        &'qsv;help;datefmt'= {
        }
        &'qsv;help;dedup'= {
        }
        &'qsv;help;describegpt'= {
        }
        &'qsv;help;diff'= {
        }
        &'qsv;help;edit'= {
        }
        &'qsv;help;enum'= {
        }
        &'qsv;help;excel'= {
        }
        &'qsv;help;exclude'= {
        }
        &'qsv;help;explode'= {
        }
        &'qsv;help;extdedup'= {
        }
        &'qsv;help;extsort'= {
        }
        &'qsv;help;fetch'= {
        }
        &'qsv;help;fetchpost'= {
        }
        &'qsv;help;fill'= {
        }
        &'qsv;help;fixlengths'= {
        }
        &'qsv;help;flatten'= {
        }
        &'qsv;help;fmt'= {
        }
        &'qsv;help;foreach'= {
        }
        &'qsv;help;frequency'= {
        }
        &'qsv;help;geocode'= {
            cand countryinfo 'countryinfo'
            cand countryinfonow 'countryinfonow'
            cand index-check 'index-check'
            cand index-load 'index-load'
            cand index-reset 'index-reset'
            cand index-update 'index-update'
            cand iplookup 'iplookup'
            cand iplookupnow 'iplookupnow'
            cand reverse 'reverse'
            cand reversenow 'reversenow'
            cand suggest 'suggest'
            cand suggestnow 'suggestnow'
        }
        &'qsv;help;geocode;countryinfo'= {
        }
        &'qsv;help;geocode;countryinfonow'= {
        }
        &'qsv;help;geocode;index-check'= {
        }
        &'qsv;help;geocode;index-load'= {
        }
        &'qsv;help;geocode;index-reset'= {
        }
        &'qsv;help;geocode;index-update'= {
        }
        &'qsv;help;geocode;iplookup'= {
        }
        &'qsv;help;geocode;iplookupnow'= {
        }
        &'qsv;help;geocode;reverse'= {
        }
        &'qsv;help;geocode;reversenow'= {
        }
        &'qsv;help;geocode;suggest'= {
        }
        &'qsv;help;geocode;suggestnow'= {
        }
        &'qsv;help;geoconvert'= {
        }
        &'qsv;help;headers'= {
        }
        &'qsv;help;index'= {
        }
        &'qsv;help;input'= {
        }
        &'qsv;help;join'= {
        }
        &'qsv;help;joinp'= {
        }
        &'qsv;help;json'= {
        }
        &'qsv;help;jsonl'= {
        }
        &'qsv;help;lens'= {
        }
        &'qsv;help;luau'= {
            cand filter 'filter'
            cand map 'map'
        }
        &'qsv;help;luau;filter'= {
        }
        &'qsv;help;luau;map'= {
        }
        &'qsv;help;moarstats'= {
        }
        &'qsv;help;partition'= {
        }
        &'qsv;help;pivotp'= {
        }
        &'qsv;help;pragmastat'= {
        }
        &'qsv;help;pro'= {
            cand lens 'lens'
            cand workflow 'workflow'
        }
        &'qsv;help;pro;lens'= {
        }
        &'qsv;help;pro;workflow'= {
        }
        &'qsv;help;prompt'= {
        }
        &'qsv;help;pseudo'= {
        }
        &'qsv;help;py'= {
            cand filter 'filter'
            cand map 'map'
        }
        &'qsv;help;py;filter'= {
        }
        &'qsv;help;py;map'= {
        }
        &'qsv;help;rename'= {
        }
        &'qsv;help;replace'= {
        }
        &'qsv;help;reverse'= {
        }
        &'qsv;help;safenames'= {
        }
        &'qsv;help;sample'= {
        }
        &'qsv;help;schema'= {
        }
        &'qsv;help;search'= {
        }
        &'qsv;help;searchset'= {
        }
        &'qsv;help;select'= {
        }
        &'qsv;help;slice'= {
        }
        &'qsv;help;snappy'= {
            cand check 'check'
            cand compress 'compress'
            cand decompress 'decompress'
            cand validate 'validate'
        }
        &'qsv;help;snappy;check'= {
        }
        &'qsv;help;snappy;compress'= {
        }
        &'qsv;help;snappy;decompress'= {
        }
        &'qsv;help;snappy;validate'= {
        }
        &'qsv;help;sniff'= {
        }
        &'qsv;help;sort'= {
        }
        &'qsv;help;sortcheck'= {
        }
        &'qsv;help;split'= {
        }
        &'qsv;help;sqlp'= {
        }
        &'qsv;help;stats'= {
        }
        &'qsv;help;table'= {
        }
        &'qsv;help;template'= {
        }
        &'qsv;help;to'= {
            cand datapackage 'datapackage'
            cand ods 'ods'
            cand postgres 'postgres'
            cand sqlite 'sqlite'
            cand xlsx 'xlsx'
        }
        &'qsv;help;to;datapackage'= {
        }
        &'qsv;help;to;ods'= {
        }
        &'qsv;help;to;postgres'= {
        }
        &'qsv;help;to;sqlite'= {
        }
        &'qsv;help;to;xlsx'= {
        }
        &'qsv;help;tojsonl'= {
        }
        &'qsv;help;transpose'= {
        }
        &'qsv;help;validate'= {
            cand schema 'schema'
        }
        &'qsv;help;validate;schema'= {
        }
        &'qsv;help;help'= {
        }
    ]
    $completions[$command]
}
