# Copyright (c) 2024-2026, NVIDIA CORPORATION & AFFILIATES. ALL RIGHTS RESERVED.
#
# SPDX-License-Identifier: Apache-2.0

import _cython_3_1_2
import enum
from typing import Any, Callable, ClassVar

__pyx_capi__: dict
__test__: dict
check_status: _cython_3_1_2.cython_function_or_method
create_generator: _cython_3_1_2.cython_function_or_method
create_generator_host: _cython_3_1_2.cython_function_or_method
create_poisson_distribution: _cython_3_1_2.cython_function_or_method
destroy_distribution: _cython_3_1_2.cython_function_or_method
destroy_generator: _cython_3_1_2.cython_function_or_method
generate: _cython_3_1_2.cython_function_or_method
generate_binomial: _cython_3_1_2.cython_function_or_method
generate_binomial_method: _cython_3_1_2.cython_function_or_method
generate_log_normal: _cython_3_1_2.cython_function_or_method
generate_log_normal_double: _cython_3_1_2.cython_function_or_method
generate_long_long: _cython_3_1_2.cython_function_or_method
generate_normal: _cython_3_1_2.cython_function_or_method
generate_normal_double: _cython_3_1_2.cython_function_or_method
generate_poisson: _cython_3_1_2.cython_function_or_method
generate_poisson_method: _cython_3_1_2.cython_function_or_method
generate_seeds: _cython_3_1_2.cython_function_or_method
generate_uniform: _cython_3_1_2.cython_function_or_method
generate_uniform_double: _cython_3_1_2.cython_function_or_method
get_direction_vectors32: _cython_3_1_2.cython_function_or_method
get_direction_vectors64: _cython_3_1_2.cython_function_or_method
get_property: _cython_3_1_2.cython_function_or_method
get_scramble_constants32: _cython_3_1_2.cython_function_or_method
get_scramble_constants64: _cython_3_1_2.cython_function_or_method
get_version: _cython_3_1_2.cython_function_or_method
set_generator_offset: _cython_3_1_2.cython_function_or_method
set_generator_ordering: _cython_3_1_2.cython_function_or_method
set_pseudo_random_generator_seed: _cython_3_1_2.cython_function_or_method
set_quasi_random_generator_dimensions: _cython_3_1_2.cython_function_or_method
set_stream: _cython_3_1_2.cython_function_or_method

class DirectionVectorSet(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    DIRECTION_VECTORS_32_JOEKUO6: ClassVar[DirectionVectorSet] = ...
    DIRECTION_VECTORS_64_JOEKUO6: ClassVar[DirectionVectorSet] = ...
    SCRAMBLED_DIRECTION_VECTORS_32_JOEKUO6: ClassVar[DirectionVectorSet] = ...
    SCRAMBLED_DIRECTION_VECTORS_64_JOEKUO6: ClassVar[DirectionVectorSet] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Method(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    METHOD_3RD: ClassVar[Method] = ...
    METHOD_BINARY_SEARCH: ClassVar[Method] = ...
    METHOD_CHOOSE_BEST: ClassVar[Method] = ...
    METHOD_DEFINITION: ClassVar[Method] = ...
    METHOD_DEVICE_API: ClassVar[Method] = ...
    METHOD_DISCRETE_GAUSS: ClassVar[Method] = ...
    METHOD_FAST_REJECTION: ClassVar[Method] = ...
    METHOD_HITR: ClassVar[Method] = ...
    METHOD_ITR: ClassVar[Method] = ...
    METHOD_KNUTH: ClassVar[Method] = ...
    METHOD_M1: ClassVar[Method] = ...
    METHOD_M2: ClassVar[Method] = ...
    METHOD_POISSON: ClassVar[Method] = ...
    METHOD_REJECTION: ClassVar[Method] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Ordering(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    PSEUDO_BEST: ClassVar[Ordering] = ...
    PSEUDO_DEFAULT: ClassVar[Ordering] = ...
    PSEUDO_DYNAMIC: ClassVar[Ordering] = ...
    PSEUDO_LEGACY: ClassVar[Ordering] = ...
    PSEUDO_SEEDED: ClassVar[Ordering] = ...
    QUASI_DEFAULT: ClassVar[Ordering] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class RngType(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    PSEUDO_DEFAULT: ClassVar[RngType] = ...
    PSEUDO_MRG32K3A: ClassVar[RngType] = ...
    PSEUDO_MT19937: ClassVar[RngType] = ...
    PSEUDO_MTGP32: ClassVar[RngType] = ...
    PSEUDO_PHILOX4_32_10: ClassVar[RngType] = ...
    PSEUDO_XORWOW: ClassVar[RngType] = ...
    QUASI_DEFAULT: ClassVar[RngType] = ...
    QUASI_SCRAMBLED_SOBOL32: ClassVar[RngType] = ...
    QUASI_SCRAMBLED_SOBOL64: ClassVar[RngType] = ...
    QUASI_SOBOL32: ClassVar[RngType] = ...
    QUASI_SOBOL64: ClassVar[RngType] = ...
    TEST: ClassVar[RngType] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class Status(enum.IntEnum):
    __new__: ClassVar[Callable] = ...
    ALLOCATION_FAILED: ClassVar[Status] = ...
    ARCH_MISMATCH: ClassVar[Status] = ...
    DOUBLE_PRECISION_REQUIRED: ClassVar[Status] = ...
    INITIALIZATION_FAILED: ClassVar[Status] = ...
    INTERNAL_ERROR: ClassVar[Status] = ...
    LAUNCH_FAILURE: ClassVar[Status] = ...
    LENGTH_NOT_MULTIPLE: ClassVar[Status] = ...
    NOT_INITIALIZED: ClassVar[Status] = ...
    OUT_OF_RANGE: ClassVar[Status] = ...
    PREEXISTING_FAILURE: ClassVar[Status] = ...
    SUCCESS: ClassVar[Status] = ...
    TYPE_ERROR: ClassVar[Status] = ...
    VERSION_MISMATCH: ClassVar[Status] = ...
    _generate_next_value_: ClassVar[Callable] = ...
    _member_map_: ClassVar[dict] = ...
    _member_names_: ClassVar[list] = ...
    _member_type_: ClassVar[type[int]] = ...
    _unhashable_values_: ClassVar[list] = ...
    _use_args_: ClassVar[bool] = ...
    _value2member_map_: ClassVar[dict] = ...
    def __format__(self, *args, **kwargs) -> str: ...

class cuRANDError(Exception):
    def __init__(self, status) -> Any: ...
    def __reduce__(self) -> Any: ...
