/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extractors.DataExtractor;
import com.intellij.database.extractors.ExtractionConfig;
import com.intellij.database.extractors.GridExtractorsUtilCore;
import com.intellij.database.extractors.ObjectFormatter;
import com.intellij.database.extractors.ObjectFormatterMode;
import com.intellij.database.extractors.TranspositionAwareExtractor;
import com.intellij.database.util.Out;
import com.intellij.openapi.util.text.StringUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlValuesExtractor
extends TranspositionAwareExtractor {
    public HtmlValuesExtractor(ObjectFormatter converter) {
        super(converter);
    }

    @NotNull
    public String getDataPrefix() {
        return "<table border=\"1\" style=\"border-collapse:collapse\">";
    }

    @NotNull
    public String getDataSuffix() {
        return "</table>";
    }

    @NotNull
    public String getLinePrefix() {
        return "<tr>";
    }

    @NotNull
    public String getLineSuffix() {
        return "</tr>";
    }

    @NotNull
    public String getValuePrefix() {
        return "<td>";
    }

    @NotNull
    public String getValueSuffix() {
        return "</td>";
    }

    @Override
    public String getColumnName(GridColumn column) {
        return "<th>" + column.getName() + "</th>";
    }

    @Override
    @Nullable
    protected String getValueAsString(@NotNull GridRow row, @NotNull GridColumn column, @NotNull ObjectFormatterMode mode) {
        if (row == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(0);
        }
        if (column == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(1);
        }
        if (mode == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(2);
        }
        return this.getValueAsString(row, column, mode, true);
    }

    @Nullable
    protected String getValueAsString(@NotNull GridRow row, @NotNull GridColumn column, @NotNull ObjectFormatterMode mode, boolean escape) {
        if (row == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(3);
        }
        if (column == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(4);
        }
        if (mode == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(5);
        }
        String repr = super.getValueAsString(row, column, mode);
        return escape ? HtmlValuesExtractor.escapeChars(repr) : repr;
    }

    @Nullable
    public static String escapeChars(@Nullable String s) {
        return s != null ? StringUtil.escapeXmlEntities((String)s.replaceAll("[\t\b\\f]", "")).replaceAll("\\r|\\n|\\r\\n", "<br/>") : null;
    }

    @Override
    @NotNull
    public String getFileExtension() {
        return "html";
    }

    @Override
    public boolean supportsText() {
        return true;
    }

    @Override
    public TranspositionAwareExtractor.TranspositionAwareExtraction startExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, int ... selectedColumns) {
        if (out == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(6);
        }
        if (allColumns == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(7);
        }
        if (query == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(8);
        }
        if (config == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(9);
        }
        return new HtmlExtraction(out, config, allColumns, query, selectedColumns, false);
    }

    public DataExtractor.Extraction spawnChildExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, Boolean isOriginallyTransposed, int ... selectedColumns) {
        if (out == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(10);
        }
        if (allColumns == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(11);
        }
        if (query == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(12);
        }
        if (config == null) {
            HtmlValuesExtractor.$$$reportNull$$$0(13);
        }
        return new HtmlExtraction(out, config, allColumns, query, selectedColumns, isOriginallyTransposed);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allColumns";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "query";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/extractors/HtmlValuesExtractor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getValueAsString";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "startExtraction";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "spawnChildExtraction";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    protected class HtmlExtraction
    extends TranspositionAwareExtractor.TranspositionAwareExtraction {
        private final boolean myIsTransposedMode;

        public HtmlExtraction(@NotNull Out out, ExtractionConfig config, List<? extends GridColumn> allColumns, String query, int[] selectedColumnIndices, Boolean isTransposedMode) {
            if (config == null) {
                HtmlExtraction.$$$reportNull$$$0(0);
            }
            super(out, config, allColumns, query, selectedColumnIndices, HtmlValuesExtractor.this);
            this.myIsTransposedMode = isTransposedMode;
        }

        @Override
        protected DataExtractor.Extraction spawnChildExtraction(@NotNull Out out, @NotNull List<? extends GridColumn> allColumns, @NotNull String query, @NotNull ExtractionConfig config, Boolean isOriginallyTransposed, int ... selectedColumns) {
            if (out == null) {
                HtmlExtraction.$$$reportNull$$$0(1);
            }
            if (allColumns == null) {
                HtmlExtraction.$$$reportNull$$$0(2);
            }
            if (query == null) {
                HtmlExtraction.$$$reportNull$$$0(3);
            }
            if (config == null) {
                HtmlExtraction.$$$reportNull$$$0(4);
            }
            return HtmlValuesExtractor.this.spawnChildExtraction(out, allColumns, query, config, isOriginallyTransposed, selectedColumns);
        }

        protected String getHeader() {
            return "<!DOCTYPE html>\n<html>\n<head>\n  <title></title>\n</head>\n<body>\n" + HtmlValuesExtractor.this.getDataPrefix() + "\n";
        }

        protected String getFooter() {
            return "\n</body>\n</html>";
        }

        @Override
        protected void doAppendData(List<? extends GridRow> rows) {
            Int2ObjectMap columnsMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping(this.myAllColumns);
            boolean first = true;
            for (GridRow gridRow : rows) {
                if (!first) {
                    this.myOut.appendText(HtmlValuesExtractor.this.getLineSeparator());
                } else {
                    first = false;
                }
                this.myOut.appendText(HtmlValuesExtractor.this.getLinePrefix());
                if (this.myIsTransposedMode) {
                    this.myOut.appendText(HtmlValuesExtractor.this.getValuePrefix()).appendText(HtmlValuesExtractor.this.getValueLiteral(this.getRowNumber(gridRow), null, null)).appendText(HtmlValuesExtractor.this.getValueSuffix());
                }
                for (int selectedColumn : GridExtractorsUtilCore.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices)) {
                    GridColumn column = (GridColumn)columnsMap.get(selectedColumn);
                    if (column == null) continue;
                    String value = HtmlValuesExtractor.this.getValueLiteral(gridRow, column, ObjectFormatterMode.DEFAULT);
                    this.myOut.appendText(HtmlValuesExtractor.this.getValuePrefix()).appendText(value).appendText(HtmlValuesExtractor.this.getValueSuffix());
                }
                this.myOut.appendText(HtmlValuesExtractor.this.getLineSuffix());
            }
        }

        @Override
        protected void doAppendHeader(boolean appendNewLine) {
            this.myOut.appendText(this.getHeader());
            int[] selectedColumns = GridExtractorsUtilCore.getNonEmptySelection(this.myAllColumns, this.mySelectedColumnIndices);
            if (selectedColumns.length == 0) {
                return;
            }
            String columnName = this.myIsTransposedMode ? HtmlValuesExtractor.this.getColumnName(this.getRowNumbersColumn()) : "";
            this.myOut.appendText(HtmlValuesExtractor.this.getLinePrefix()).appendText(columnName);
            Int2ObjectMap columnsMap = GridExtractorsUtilCore.getColumnNumsToColumnsMapping(this.myAllColumns);
            for (int selectedColumn : selectedColumns) {
                GridColumn column = (GridColumn)columnsMap.get(selectedColumn);
                if (column == null) continue;
                this.myOut.appendText(HtmlValuesExtractor.this.getColumnName(column));
            }
            this.myOut.appendText(HtmlValuesExtractor.this.getLineSuffix());
            if (appendNewLine) {
                this.myOut.appendText(HtmlValuesExtractor.this.getLineSeparator());
            }
        }

        @Override
        protected void doAppendFooter() {
            this.myOut.appendText(HtmlValuesExtractor.this.getDataSuffix()).appendText(this.getFooter());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "config";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "out";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "allColumns";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "query";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/extractors/HtmlValuesExtractor$HtmlExtraction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "spawnChildExtraction";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

