/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.yaml.parser;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.yaml.parser.Monomorph;
import net.sourceforge.plantuml.yaml.parser.MonomorphType;

public class YamlBuilder {
    private final List<Monomorph> stack = new ArrayList<Monomorph>();

    public YamlBuilder() {
        this.stack.add(new Monomorph());
    }

    public void increaseIndentation() {
    }

    public void decreaseIndentation() {
        this.stack.remove(this.stack.size() - 1);
        if (this.getLast().getType() == MonomorphType.LIST) {
            this.stack.remove(this.stack.size() - 1);
        }
    }

    public Monomorph getResult() {
        return this.stack.get(0);
    }

    private Monomorph getLast() {
        return this.stack.get(this.stack.size() - 1);
    }

    public void onListItemPlainDash() {
        if (this.isArrayAlreadyThere()) {
            this.stack.remove(this.stack.size() - 1);
        }
        Monomorph newElement = new Monomorph();
        this.getLast().addInList(newElement);
        this.stack.add(newElement);
    }

    private boolean isArrayAlreadyThere() {
        if (this.stack.size() < 2) {
            return false;
        }
        Monomorph potentialList = this.stack.get(this.stack.size() - 2);
        if (potentialList.getType() != MonomorphType.LIST) {
            return false;
        }
        return potentialList.getElementAt(potentialList.size() - 1) == this.stack.get(this.stack.size() - 1);
    }

    public void onKeyAndValue(String key, String value) {
        this.getLast().putInMap(key, Monomorph.scalar(value));
    }

    public void onKeyAndFlowSequence(String key, List<String> list) {
        this.getLast().putInMap(key, Monomorph.list(list));
    }

    public void onOnlyKey(String key) {
        Monomorph newElement = new Monomorph();
        this.getLast().putInMap(key, newElement);
        this.stack.add(newElement);
    }

    public String toString() {
        return this.stack.toString();
    }

    public void onListItemOnlyKey(String key) {
        if (this.isArrayAlreadyThere()) {
            this.stack.remove(this.stack.size() - 1);
        }
        Monomorph newElement = new Monomorph();
        this.getLast().addInList(newElement);
        this.stack.add(newElement);
        Monomorph newElement2 = new Monomorph();
        this.getLast().putInMap(key, newElement2);
        this.stack.add(newElement2);
    }

    public void onListItemOnlyValue(String value) {
        if (this.isArrayAlreadyThere()) {
            this.stack.remove(this.stack.size() - 1);
        }
        this.getLast().addInList(Monomorph.scalar(value));
    }

    public void onListItemKeyAndValue(String key, String value) {
        if (this.isArrayAlreadyThere()) {
            this.stack.remove(this.stack.size() - 1);
        }
        Monomorph newElement = new Monomorph();
        this.getLast().addInList(newElement);
        this.stack.add(newElement);
        this.getLast().putInMap(key, Monomorph.scalar(value));
    }

    public void onListItemKeyAndFlowSequence(String key, List<String> values) {
        if (this.isArrayAlreadyThere()) {
            this.stack.remove(this.stack.size() - 1);
        }
        Monomorph newElement = new Monomorph();
        this.getLast().addInList(newElement);
        this.stack.add(newElement);
        this.getLast().putInMap(key, Monomorph.list(values));
    }
}

