/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FilteredDocIdSetIterator;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TotalHits;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BitSetIterator;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.FixedBitSet;
import org.opensearch.common.StopWatch;
import org.opensearch.common.lucene.Lucene;
import org.opensearch.knn.common.FieldInfoExtractor;
import org.opensearch.knn.common.KNNConstants;
import org.opensearch.knn.index.KNNSettings;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.codec.util.KNNCodecUtil;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.quantizationservice.QuantizationService;
import org.opensearch.knn.index.query.ExactSearcher;
import org.opensearch.knn.index.query.KNNQuery;
import org.opensearch.knn.index.query.KNNQueryResult;
import org.opensearch.knn.index.query.KNNScorer;
import org.opensearch.knn.index.query.PerLeafResult;
import org.opensearch.knn.index.query.SegmentLevelQuantizationInfo;
import org.opensearch.knn.index.query.SegmentLevelQuantizationUtil;
import org.opensearch.knn.index.query.explain.KnnExplanation;
import org.opensearch.knn.indices.ModelDao;
import org.opensearch.knn.indices.ModelMetadata;
import org.opensearch.knn.indices.ModelUtil;
import org.opensearch.knn.plugin.stats.KNNCounter;
import org.opensearch.knn.profile.StopWatchUtils;

public abstract class KNNWeight
extends Weight {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNWeight.class);
    protected static final TopDocs EMPTY_TOPDOCS = new TopDocs(new TotalHits(0L, TotalHits.Relation.EQUAL_TO), new ScoreDoc[0]);
    private static ModelDao modelDao;
    private static ExactSearcher DEFAULT_EXACT_SEARCHER;
    protected final KNNQuery knnQuery;
    private final float boost;
    private final Weight filterWeight;
    private final ExactSearcher exactSearcher;
    protected final QuantizationService quantizationService;
    private final KnnExplanation knnExplanation;

    public KNNWeight(KNNQuery query, float boost) {
        this(query, boost, null);
    }

    public KNNWeight(KNNQuery query, float boost, Weight filterWeight) {
        super((Query)query);
        assert (query != null) : "query must not be null";
        this.knnQuery = query;
        this.boost = boost;
        this.filterWeight = filterWeight;
        this.exactSearcher = DEFAULT_EXACT_SEARCHER;
        this.quantizationService = QuantizationService.getInstance();
        this.knnExplanation = new KnnExplanation();
    }

    public static void initialize(ModelDao modelDao) {
        KNNWeight.initialize(modelDao, new ExactSearcher(modelDao));
    }

    @VisibleForTesting
    static void initialize(ModelDao modelDao, ExactSearcher exactSearcher) {
        KNNWeight.modelDao = modelDao;
        DEFAULT_EXACT_SEARCHER = exactSearcher;
    }

    @VisibleForTesting
    KnnExplanation getKnnExplanation() {
        return this.knnExplanation;
    }

    public Explanation explain(LeafReaderContext context, int doc) {
        return this.explain(context, doc, 0.0f);
    }

    public Explanation explain(LeafReaderContext context, int doc, float score) {
        this.knnQuery.setExplain(true);
        try {
            Scorer knnScorer = this.getOrCreateKnnScorer(context);
            if (score == 0.0f) {
                score = this.getKnnScore(knnScorer, doc);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error while explaining KNN score for doc [%d], score [%f]", doc, Float.valueOf(score)), e);
        }
        String highLevelExplanation = this.getHighLevelExplanation();
        StringBuilder leafLevelExplanation = this.getLeafLevelExplanation(context);
        SegmentReader reader = Lucene.segmentReader((LeafReader)context.reader());
        FieldInfo fieldInfo = FieldInfoExtractor.getFieldInfo((LeafReader)reader, this.knnQuery.getField());
        if (fieldInfo == null) {
            return Explanation.match((Number)Float.valueOf(score), (String)highLevelExplanation, (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(score), (String)leafLevelExplanation.toString(), (Explanation[])new Explanation[0])});
        }
        SpaceType spaceType = FieldInfoExtractor.getSpaceType(modelDao, fieldInfo);
        leafLevelExplanation.append(", spaceType = ").append(spaceType.getValue());
        Float rawScore = this.knnExplanation.getRawScore(doc);
        Explanation rawScoreDetail = null;
        if (rawScore != null && this.knnQuery.getRescoreContext() == null) {
            leafLevelExplanation.append(" where score is computed as ").append(spaceType.explainScoreTranslation(rawScore.floatValue())).append(" from:");
            String detailSuffix = this.knnQuery.isMemoryOptimizedSearch() ? " memory optimized searching logic" : " library";
            rawScoreDetail = Explanation.match((Number)rawScore, (String)("rawScore, returned from " + String.valueOf(FieldInfoExtractor.extractKNNEngine(fieldInfo)) + detailSuffix), (Explanation[])new Explanation[0]);
        }
        return rawScoreDetail != null ? Explanation.match((Number)Float.valueOf(score), (String)highLevelExplanation, (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(score), (String)leafLevelExplanation.toString(), (Explanation[])new Explanation[]{rawScoreDetail})}) : Explanation.match((Number)Float.valueOf(score), (String)highLevelExplanation, (Explanation[])new Explanation[]{Explanation.match((Number)Float.valueOf(score), (String)leafLevelExplanation.toString(), (Explanation[])new Explanation[0])});
    }

    private StringBuilder getLeafLevelExplanation(LeafReaderContext context) {
        Integer annResult;
        int filterThresholdValue = KNNSettings.getFilteredExactSearchThreshold(this.knnQuery.getIndexName());
        int cardinality = this.knnExplanation.getCardinality();
        StringBuilder sb = new StringBuilder("the type of knn search executed at leaf was ");
        if (this.filterWeight != null) {
            if (this.isFilterIdCountLessThanK(cardinality)) {
                sb.append("Exact").append(" since filteredIds = ").append(cardinality).append(" is less than or equal to K = ").append(this.knnQuery.getK());
            } else if (this.isExactSearchThresholdSettingSet(filterThresholdValue) && filterThresholdValue >= cardinality) {
                sb.append("Exact").append(" since filtered threshold value = ").append(filterThresholdValue).append(" is greater than or equal to estimated distance computations = ").append(cardinality);
            } else if (!this.isExactSearchThresholdSettingSet(filterThresholdValue) && this.isMaxDistCompGreaterThanEstimatedDistComp(cardinality)) {
                sb.append("Exact").append(" since max distance computation = ").append(KNNConstants.MAX_DISTANCE_COMPUTATIONS).append(" is greater than or equal to estimated distance computations = ").append((long)cardinality * (long)this.knnQuery.getQueryDimension());
            }
        }
        if ((annResult = this.knnExplanation.getAnnResult(context.id())) != null && annResult == 0 && this.isMissingNativeEngineFiles(context)) {
            sb.append("Exact").append(" since no native engine files are available");
        }
        if (annResult != null && this.isFilteredExactSearchRequireAfterANNSearch(cardinality, annResult)) {
            sb.append("Exact").append(" since the number of documents returned are less than K = ").append(this.knnQuery.getK()).append(" and there are more than K filtered Ids = ").append(cardinality);
        }
        if (annResult != null && annResult > 0 && !this.isFilteredExactSearchRequireAfterANNSearch(cardinality, annResult)) {
            sb.append("Approximate-NN");
        }
        sb.append(" with vectorDataType = ").append((Object)this.knnQuery.getVectorDataType());
        return sb;
    }

    private String getHighLevelExplanation() {
        StringBuilder sb = new StringBuilder("the type of knn search executed was ");
        if (this.knnQuery.getRescoreContext() != null) {
            sb.append(this.buildDiskBasedSearchExplanation());
        } else if (this.knnQuery.getRadius() != null) {
            sb.append("Radial").append(" with the radius of ").append(this.knnQuery.getRadius());
        } else {
            sb.append("Approximate-NN");
        }
        return sb.toString();
    }

    private String buildDiskBasedSearchExplanation() {
        StringBuilder sb = new StringBuilder("Disk-based");
        boolean isShardLevelRescoringDisabled = KNNSettings.isShardLevelRescoringDisabledForDiskBasedVector(this.knnQuery.getIndexName());
        if (!this.knnQuery.getRescoreContext().isRescoreEnabled()) {
            isShardLevelRescoringDisabled = true;
        }
        int dimension = this.knnQuery.getQueryVector().length;
        int firstPassK = this.knnQuery.getRescoreContext().getFirstPassK(this.knnQuery.getK(), isShardLevelRescoringDisabled, dimension);
        sb.append(" and the first pass k was ").append(firstPassK).append(" with vector dimension of ").append(dimension).append(", over sampling factor of ").append(this.knnQuery.getRescoreContext().getOversampleFactor());
        if (isShardLevelRescoringDisabled) {
            sb.append(", shard level rescoring disabled");
        } else {
            sb.append(", shard level rescoring enabled");
        }
        return sb.toString();
    }

    private Scorer getOrCreateKnnScorer(LeafReaderContext context) throws IOException {
        Scorer scorer = this.knnExplanation.getKnnScorer(context);
        if (scorer == null) {
            scorer = (KNNScorer)this.scorer(context);
            this.knnExplanation.addKnnScorer(context, scorer);
        }
        return scorer;
    }

    private float getKnnScore(Scorer knnScorer, int doc) throws IOException {
        return knnScorer.iterator().advance(doc) == doc ? knnScorer.score() : 0.0f;
    }

    public ScorerSupplier scorerSupplier(final LeafReaderContext context) {
        return new ScorerSupplier(){
            long cost = -1L;

            public Scorer get(long leadCost) throws IOException {
                TopDocs topDocs = KNNWeight.this.searchLeaf(context, Optional.ofNullable(KNNWeight.this.knnQuery.getK()).orElse(0)).getResult();
                this.cost = topDocs.scoreDocs.length;
                if (this.cost == 0L) {
                    return KNNScorer.emptyScorer();
                }
                return new KNNScorer(topDocs, KNNWeight.this.boost);
            }

            public long cost() {
                return this.cost == -1L ? (long)Optional.ofNullable(KNNWeight.this.knnQuery.getK()).orElse(0).intValue() : this.cost;
            }
        };
    }

    public PerLeafResult searchLeaf(LeafReaderContext context, int k) throws IOException {
        SegmentReader reader = Lucene.segmentReader((LeafReader)context.reader());
        String segmentName = reader.getSegmentName();
        StopWatch stopWatch = StopWatchUtils.startStopWatch(log);
        BitSet filterBitSet = this.getFilteredDocsBitSet(context);
        StopWatchUtils.stopStopWatchAndLog(log, stopWatch, "FilterBitSet creation", this.knnQuery.getShardId(), segmentName, this.knnQuery.getField());
        int filterCardinality = filterBitSet.cardinality();
        if (this.filterWeight != null && filterCardinality == 0) {
            return PerLeafResult.EMPTY_RESULT;
        }
        if (this.knnQuery.isExplain()) {
            this.knnExplanation.setCardinality(filterCardinality);
        }
        if (this.isFilteredExactSearchPreferred(filterCardinality)) {
            TopDocs result = this.doExactSearch(context, (DocIdSetIterator)new BitSetIterator(filterBitSet, (long)filterCardinality), filterCardinality, k);
            return new PerLeafResult(this.filterWeight == null ? null : filterBitSet, filterCardinality, result, PerLeafResult.SearchMode.EXACT_SEARCH);
        }
        StopWatch annStopWatch = StopWatchUtils.startStopWatch(log);
        TopDocs topDocs = this.approximateSearch(context, filterBitSet, filterCardinality, k);
        StopWatchUtils.stopStopWatchAndLog(log, annStopWatch, "ANN search", this.knnQuery.getShardId(), segmentName, this.knnQuery.getField());
        if (this.knnQuery.isExplain()) {
            this.knnExplanation.addLeafResult(context.id(), topDocs.scoreDocs.length);
        }
        if (this.isExactSearchRequire(context, filterCardinality, topDocs.scoreDocs.length)) {
            BitSetIterator docs = this.filterWeight != null ? new BitSetIterator(filterBitSet, (long)filterCardinality) : null;
            TopDocs result = this.doExactSearch(context, (DocIdSetIterator)docs, filterCardinality, k);
            return new PerLeafResult(this.filterWeight == null ? null : filterBitSet, filterCardinality, result, PerLeafResult.SearchMode.EXACT_SEARCH);
        }
        return new PerLeafResult(this.filterWeight == null ? null : filterBitSet, filterCardinality, topDocs, PerLeafResult.SearchMode.APPROXIMATE_SEARCH);
    }

    protected BitSet getFilteredDocsBitSet(LeafReaderContext ctx) throws IOException {
        if (this.filterWeight == null) {
            return new FixedBitSet(0);
        }
        Bits liveDocs = ctx.reader().getLiveDocs();
        int maxDoc = ctx.reader().maxDoc();
        Scorer scorer = this.filterWeight.scorer(ctx);
        if (scorer == null) {
            return new FixedBitSet(0);
        }
        return this.createBitSet(scorer.iterator(), liveDocs, maxDoc);
    }

    private BitSet createBitSet(DocIdSetIterator filteredDocIdsIterator, final Bits liveDocs, int maxDoc) throws IOException {
        if (liveDocs == null && filteredDocIdsIterator instanceof BitSetIterator) {
            return ((BitSetIterator)filteredDocIdsIterator).getBitSet();
        }
        FilteredDocIdSetIterator filterIterator = new FilteredDocIdSetIterator(this, filteredDocIdsIterator){

            protected boolean match(int doc) {
                return liveDocs == null || liveDocs.get(doc);
            }
        };
        return BitSet.of((DocIdSetIterator)filterIterator, (int)maxDoc);
    }

    private TopDocs doExactSearch(LeafReaderContext context, DocIdSetIterator acceptedDocs, long numberOfAcceptedDocs, int k) throws IOException {
        ExactSearcher.ExactSearcherContext.ExactSearcherContextBuilder exactSearcherContextBuilder = ExactSearcher.ExactSearcherContext.builder().parentsFilter(this.knnQuery.getParentsFilter()).k(k).useQuantizedVectorsForSearch(true).field(this.knnQuery.getField()).radius(this.knnQuery.getRadius()).matchedDocsIterator(acceptedDocs).numberOfMatchedDocs(numberOfAcceptedDocs).floatQueryVector(this.knnQuery.getQueryVector()).byteQueryVector(this.knnQuery.getByteQueryVector()).isMemoryOptimizedSearchEnabled(this.knnQuery.isMemoryOptimizedSearch());
        if (this.knnQuery.getContext() != null) {
            exactSearcherContextBuilder.maxResultWindow(this.knnQuery.getContext().getMaxResultWindow());
        }
        return this.exactSearch(context, exactSearcherContextBuilder.build());
    }

    public TopDocs approximateSearch(LeafReaderContext context, BitSet filterIdsBitSet, int filterCardinality, int k) throws IOException {
        VectorDataType vectorDataType;
        SpaceType spaceType;
        KNNEngine knnEngine;
        SegmentReader reader = Lucene.segmentReader((LeafReader)context.reader());
        FieldInfo fieldInfo = FieldInfoExtractor.getFieldInfo((LeafReader)reader, this.knnQuery.getField());
        if (fieldInfo == null) {
            log.debug("[KNN] Field info not found for {}:{}", (Object)this.knnQuery.getField(), (Object)reader.getSegmentName());
            return EMPTY_TOPDOCS;
        }
        String modelId = fieldInfo.getAttribute("model_id");
        if (modelId != null) {
            ModelMetadata modelMetadata = modelDao.getMetadata(modelId);
            if (!ModelUtil.isModelCreated(modelMetadata)) {
                throw new RuntimeException("Model \"" + modelId + "\" is not created.");
            }
            knnEngine = modelMetadata.getKnnEngine();
            spaceType = modelMetadata.getSpaceType();
            vectorDataType = modelMetadata.getVectorDataType();
        } else {
            String engineName = fieldInfo.attributes().getOrDefault("engine", KNNEngine.DEFAULT.getName());
            knnEngine = KNNEngine.getEngine(engineName);
            String spaceTypeName = fieldInfo.attributes().getOrDefault("spaceType", SpaceType.L2.getValue());
            spaceType = SpaceType.getSpace(spaceTypeName);
            vectorDataType = VectorDataType.get(fieldInfo.attributes().getOrDefault("data_type", VectorDataType.FLOAT.getValue()));
        }
        SegmentLevelQuantizationInfo segmentLevelQuantizationInfo = SegmentLevelQuantizationInfo.build((LeafReader)reader, fieldInfo, this.knnQuery.getField());
        List<String> engineFiles = KNNCodecUtil.getEngineFiles(knnEngine.getExtension(), this.knnQuery.getField(), reader.getSegmentInfo().info);
        if (engineFiles.isEmpty()) {
            log.debug("[KNN] No native engine files found for field {} for segment {}", (Object)this.knnQuery.getField(), (Object)reader.getSegmentName());
            return EMPTY_TOPDOCS;
        }
        byte[] quantizedVector = this.maybeQuantizeVector(segmentLevelQuantizationInfo);
        float[] transformedVector = this.maybeTransformVector(segmentLevelQuantizationInfo, spaceType);
        BitSet annFilter = filterCardinality == context.reader().maxDoc() ? null : filterIdsBitSet;
        KNNCounter.GRAPH_QUERY_REQUESTS.increment();
        TopDocs results = this.doANNSearch(context, reader, fieldInfo, spaceType, knnEngine, vectorDataType, quantizedVector, transformedVector, modelId, annFilter, filterCardinality, k);
        if (results.scoreDocs.length == 0) {
            log.debug("[KNN] Query yielded 0 results");
            return EMPTY_TOPDOCS;
        }
        return results;
    }

    protected abstract TopDocs doANNSearch(LeafReaderContext var1, SegmentReader var2, FieldInfo var3, SpaceType var4, KNNEngine var5, VectorDataType var6, byte[] var7, float[] var8, String var9, BitSet var10, int var11, int var12) throws IOException;

    protected void addExplainIfRequired(KNNQueryResult[] results, KNNEngine knnEngine, SpaceType spaceType) {
        if (this.knnQuery.isExplain()) {
            Arrays.stream(results).forEach(result -> {
                if (KNNEngine.FAISS.getName().equals(knnEngine.getName()) && SpaceType.INNER_PRODUCT.equals((Object)spaceType)) {
                    this.knnExplanation.addRawScore(result.getId(), -1.0f * result.getScore());
                } else {
                    this.knnExplanation.addRawScore(result.getId(), result.getScore());
                }
            });
        }
    }

    protected void addExplainIfRequired(TopDocs results, KNNEngine knnEngine, SpaceType spaceType) {
        if (this.knnQuery.isExplain()) {
            Arrays.stream(results.scoreDocs).forEach(result -> {
                if (KNNEngine.FAISS.getName().equals(knnEngine.getName()) && SpaceType.INNER_PRODUCT.equals((Object)spaceType)) {
                    this.knnExplanation.addRawScore(result.doc, -1.0f * result.score);
                } else {
                    this.knnExplanation.addRawScore(result.doc, result.score);
                }
            });
        }
    }

    public TopDocs exactSearch(LeafReaderContext leafReaderContext, ExactSearcher.ExactSearcherContext exactSearcherContext) throws IOException {
        StopWatch stopWatch = StopWatchUtils.startStopWatch(log);
        TopDocs exactSearchResults = this.exactSearcher.searchLeaf(leafReaderContext, exactSearcherContext);
        SegmentReader reader = Lucene.segmentReader((LeafReader)leafReaderContext.reader());
        StopWatchUtils.stopStopWatchAndLog(log, stopWatch, "Exact search", this.knnQuery.getShardId(), reader.getSegmentName(), this.knnQuery.getField());
        return exactSearchResults;
    }

    public boolean isCacheable(LeafReaderContext context) {
        return true;
    }

    public static float normalizeScore(float score) {
        if (score >= 0.0f) {
            return 1.0f / (1.0f + score);
        }
        return -score + 1.0f;
    }

    private boolean isFilteredExactSearchPreferred(int filterIdsCount) {
        if (this.filterWeight == null) {
            return false;
        }
        log.debug("Info for doing exact search filterIdsLength : {}, Threshold value: {}", (Object)filterIdsCount, (Object)KNNSettings.getFilteredExactSearchThreshold(this.knnQuery.getIndexName()));
        int filterThresholdValue = KNNSettings.getFilteredExactSearchThreshold(this.knnQuery.getIndexName());
        if (this.isFilterIdCountLessThanK(filterIdsCount)) {
            return true;
        }
        if (this.isExactSearchThresholdSettingSet(filterThresholdValue)) {
            return filterThresholdValue >= filterIdsCount;
        }
        return this.isMaxDistCompGreaterThanEstimatedDistComp(filterIdsCount);
    }

    private boolean isMaxDistCompGreaterThanEstimatedDistComp(int filterDocsCardinality) {
        long estimatedDistanceComputations = (long)filterDocsCardinality * (long)this.knnQuery.getQueryDimension();
        return (long)KNNConstants.MAX_DISTANCE_COMPUTATIONS >= estimatedDistanceComputations;
    }

    private boolean isFilterIdCountLessThanK(int filterIdsCount) {
        return this.knnQuery.getRadius() == null && filterIdsCount <= this.knnQuery.getK();
    }

    private boolean isExactSearchThresholdSettingSet(int filterThresholdValue) {
        return filterThresholdValue != KNNSettings.ADVANCED_FILTERED_EXACT_SEARCH_THRESHOLD_DEFAULT_VALUE;
    }

    private boolean isExactSearchRequire(LeafReaderContext context, int filterIdsCount, int annResultCount) {
        if (annResultCount == 0 && this.isMissingNativeEngineFiles(context)) {
            log.debug("Perform exact search after approximate search since no native engine files are available");
            return true;
        }
        if (this.isFilteredExactSearchRequireAfterANNSearch(filterIdsCount, annResultCount)) {
            log.debug("Doing ExactSearch after doing ANNSearch as the number of documents returned are less than K, even when we have more than K filtered Ids. K: {}, ANNResults: {}, filteredIdCount: {}", (Object)this.knnQuery.getK(), (Object)annResultCount, (Object)filterIdsCount);
            return true;
        }
        return false;
    }

    private boolean isFilteredExactSearchRequireAfterANNSearch(int filterIdsCount, int annResultCount) {
        return this.filterWeight != null && filterIdsCount >= this.knnQuery.getK() && this.knnQuery.getK() > annResultCount;
    }

    private boolean isMissingNativeEngineFiles(LeafReaderContext context) {
        SegmentReader reader = Lucene.segmentReader((LeafReader)context.reader());
        FieldInfo fieldInfo = FieldInfoExtractor.getFieldInfo((LeafReader)reader, this.knnQuery.getField());
        if (fieldInfo == null) {
            return false;
        }
        KNNEngine knnEngine = FieldInfoExtractor.extractKNNEngine(fieldInfo);
        List<String> engineFiles = KNNCodecUtil.getEngineFiles(knnEngine.getExtension(), this.knnQuery.getField(), reader.getSegmentInfo().info);
        return engineFiles.isEmpty();
    }

    protected int[] getParentIdsArray(LeafReaderContext context) throws IOException {
        if (this.knnQuery.getParentsFilter() == null) {
            return null;
        }
        return KNNWeight.bitSetToIntArray(this.knnQuery.getParentsFilter().getBitSet(context));
    }

    private byte[] maybeQuantizeVector(SegmentLevelQuantizationInfo segmentLevelQuantizationInfo) {
        if (SegmentLevelQuantizationUtil.isAdcEnabled(segmentLevelQuantizationInfo)) {
            return null;
        }
        return SegmentLevelQuantizationUtil.quantizeVector(this.knnQuery.getQueryVector(), segmentLevelQuantizationInfo);
    }

    private float[] maybeTransformVector(SegmentLevelQuantizationInfo segmentLevelQuantizationInfo, SpaceType spaceType) {
        if (SegmentLevelQuantizationUtil.isAdcEnabled(segmentLevelQuantizationInfo)) {
            float[] transformedVector = (float[])this.knnQuery.getQueryVector().clone();
            SegmentLevelQuantizationUtil.transformVectorWithADC(transformedVector, segmentLevelQuantizationInfo, spaceType);
            return transformedVector;
        }
        return null;
    }

    private static int[] bitSetToIntArray(BitSet bitSet) {
        int cardinality = bitSet.cardinality();
        int[] intArray = new int[cardinality];
        BitSetIterator bitSetIterator = new BitSetIterator(bitSet, (long)cardinality);
        int index = 0;
        int docId = bitSetIterator.nextDoc();
        while (docId != Integer.MAX_VALUE) {
            assert (index < intArray.length);
            intArray[index++] = docId;
            docId = bitSetIterator.nextDoc();
        }
        return intArray;
    }

    @Generated
    public Weight getFilterWeight() {
        return this.filterWeight;
    }
}

