"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.setAsyncSessionId = exports.getAsyncSessionId = void 0;
var _constants = require("../constants");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const setAsyncSessionId = (dataSource, value) => {
  if (value !== null) {
    sessionStorage.setItem(`${_constants.ASYNC_QUERY_SESSION_ID}_${dataSource}`, value);
  }
};
exports.setAsyncSessionId = setAsyncSessionId;
const getAsyncSessionId = dataSource => {
  return sessionStorage.getItem(`${_constants.ASYNC_QUERY_SESSION_ID}_${dataSource}`);
};
exports.getAsyncSessionId = getAsyncSessionId;