/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;

public interface SingleUseObjectKeyModel {
    public String getUserId();

    public String getActionId();

    public Long getExp();

    @Deprecated
    @JsonIgnore
    default public int getExpiration() {
        return this.getExp().intValue();
    }

    public UUID getActionVerificationNonce();

    default public String serializeKey() {
        String userId = this.getUserId();
        String encodedUserId = userId == null ? "" : Base64.getEncoder().encodeToString(userId.getBytes(StandardCharsets.UTF_8));
        return String.format("%s.%d.%s.%s", encodedUserId, this.getExp(), this.getActionVerificationNonce(), this.getActionId());
    }
}

