/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialoffer;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.beans.Transient;
import java.util.Optional;
import org.keycloak.common.util.Base64Url;
import org.keycloak.common.util.Time;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.OID4VCAuthorizationDetailsResponse;
import org.keycloak.protocol.oid4vc.model.CredentialsOffer;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedCode;
import org.keycloak.protocol.oid4vc.model.PreAuthorizedGrant;
import org.keycloak.provider.Provider;
import org.keycloak.saml.RandomSecret;

public interface CredentialOfferStorage
extends Provider {
    public void putOfferState(KeycloakSession var1, CredentialOfferState var2);

    public CredentialOfferState findOfferStateByNonce(KeycloakSession var1, String var2);

    public CredentialOfferState findOfferStateByCode(KeycloakSession var1, String var2);

    public CredentialOfferState findOfferStateByCredentialId(KeycloakSession var1, String var2);

    public void replaceOfferState(KeycloakSession var1, CredentialOfferState var2);

    public void removeOfferState(KeycloakSession var1, CredentialOfferState var2);

    default public void close() {
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class CredentialOfferState {
        private CredentialsOffer credentialsOffer;
        private String clientId;
        private String userId;
        private String nonce;
        private int expiration;
        private OID4VCAuthorizationDetailsResponse authorizationDetails;

        public CredentialOfferState(CredentialsOffer credOffer, String clientId, String userId, int expiration) {
            this.credentialsOffer = credOffer;
            this.clientId = clientId;
            this.userId = userId;
            this.expiration = expiration;
            this.nonce = Base64Url.encode((byte[])RandomSecret.createRandomSecret((int)64));
        }

        CredentialOfferState() {
        }

        @Transient
        public Optional<String> getPreAuthorizedCode() {
            return Optional.ofNullable(this.credentialsOffer.getGrants()).map(PreAuthorizedGrant::getPreAuthorizedCode).map(PreAuthorizedCode::getPreAuthorizedCode);
        }

        @Transient
        public boolean isExpired() {
            int currentTime = Time.currentTime();
            return currentTime > this.expiration;
        }

        public CredentialsOffer getCredentialsOffer() {
            return this.credentialsOffer;
        }

        public String getClientId() {
            return this.clientId;
        }

        public String getUserId() {
            return this.userId;
        }

        public String getNonce() {
            return this.nonce;
        }

        public int getExpiration() {
            return this.expiration;
        }

        public OID4VCAuthorizationDetailsResponse getAuthorizationDetails() {
            return this.authorizationDetails;
        }

        public void setAuthorizationDetails(OID4VCAuthorizationDetailsResponse authorizationDetails) {
            this.authorizationDetails = authorizationDetails;
        }

        void setCredentialsOffer(CredentialsOffer credentialsOffer) {
            this.credentialsOffer = credentialsOffer;
        }

        void setClientId(String clientId) {
            this.clientId = clientId;
        }

        void setUserId(String userId) {
            this.userId = userId;
        }

        void setNonce(String nonce) {
            this.nonce = nonce;
        }

        void setExpiration(int expiration) {
            this.expiration = expiration;
        }
    }
}

