/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.monitor.spi;

import org.hibernate.Incubating;
import org.hibernate.LockMode;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.access.CachedDomainDataAccess;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.event.monitor.spi.DiagnosticEvent;
import org.hibernate.event.spi.AutoFlushEvent;
import org.hibernate.event.spi.FlushEvent;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.JavaServiceLoadable;

@JavaServiceLoadable
@Incubating
public interface EventMonitor {
    public DiagnosticEvent beginSessionOpenEvent();

    public void completeSessionOpenEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2);

    public DiagnosticEvent beginSessionClosedEvent();

    public void completeSessionClosedEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2);

    public DiagnosticEvent beginJdbcConnectionAcquisitionEvent();

    public void completeJdbcConnectionAcquisitionEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, Object var3);

    public DiagnosticEvent beginJdbcConnectionReleaseEvent();

    public void completeJdbcConnectionReleaseEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, Object var3);

    public DiagnosticEvent beginJdbcPreparedStatementCreationEvent();

    public void completeJdbcPreparedStatementCreationEvent(DiagnosticEvent var1, String var2);

    public DiagnosticEvent beginJdbcPreparedStatementExecutionEvent();

    public void completeJdbcPreparedStatementExecutionEvent(DiagnosticEvent var1, String var2);

    public DiagnosticEvent beginJdbcBatchExecutionEvent();

    public void completeJdbcBatchExecutionEvent(DiagnosticEvent var1, String var2);

    public DiagnosticEvent beginCachePutEvent();

    public void completeCachePutEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, Region var3, boolean var4, CacheActionDescription var5);

    public void completeCachePutEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, CachedDomainDataAccess var3, EntityPersister var4, boolean var5, CacheActionDescription var6);

    public void completeCachePutEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, CachedDomainDataAccess var3, EntityPersister var4, boolean var5, boolean var6, CacheActionDescription var7);

    public void completeCachePutEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, CachedDomainDataAccess var3, CollectionPersister var4, boolean var5, CacheActionDescription var6);

    public DiagnosticEvent beginCacheGetEvent();

    public void completeCacheGetEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, Region var3, boolean var4);

    public void completeCacheGetEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, Region var3, EntityPersister var4, boolean var5, boolean var6);

    public void completeCacheGetEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, Region var3, CollectionPersister var4, boolean var5);

    public DiagnosticEvent beginFlushEvent();

    public void completeFlushEvent(DiagnosticEvent var1, FlushEvent var2);

    public void completeFlushEvent(DiagnosticEvent var1, FlushEvent var2, boolean var3);

    public DiagnosticEvent beginPartialFlushEvent();

    public void completePartialFlushEvent(DiagnosticEvent var1, AutoFlushEvent var2);

    public DiagnosticEvent beginDirtyCalculationEvent();

    public void completeDirtyCalculationEvent(DiagnosticEvent var1, SharedSessionContractImplementor var2, EntityPersister var3, EntityEntry var4, int[] var5);

    public DiagnosticEvent beginPrePartialFlush();

    public void completePrePartialFlush(DiagnosticEvent var1, SharedSessionContractImplementor var2);

    public DiagnosticEvent beginEntityInsertEvent();

    public void completeEntityInsertEvent(DiagnosticEvent var1, Object var2, String var3, boolean var4, SharedSessionContractImplementor var5);

    public DiagnosticEvent beginEntityUpdateEvent();

    public void completeEntityUpdateEvent(DiagnosticEvent var1, Object var2, String var3, boolean var4, SharedSessionContractImplementor var5);

    public DiagnosticEvent beginEntityUpsertEvent();

    public void completeEntityUpsertEvent(DiagnosticEvent var1, Object var2, String var3, boolean var4, SharedSessionContractImplementor var5);

    public DiagnosticEvent beginEntityDeleteEvent();

    public void completeEntityDeleteEvent(DiagnosticEvent var1, Object var2, String var3, boolean var4, SharedSessionContractImplementor var5);

    public DiagnosticEvent beginEntityLockEvent();

    public void completeEntityLockEvent(DiagnosticEvent var1, Object var2, String var3, LockMode var4, boolean var5, SharedSessionContractImplementor var6);

    public DiagnosticEvent beginCollectionRecreateEvent();

    public void completeCollectionRecreateEvent(DiagnosticEvent var1, Object var2, String var3, boolean var4, SharedSessionContractImplementor var5);

    public DiagnosticEvent beginCollectionUpdateEvent();

    public void completeCollectionUpdateEvent(DiagnosticEvent var1, Object var2, String var3, boolean var4, SharedSessionContractImplementor var5);

    public DiagnosticEvent beginCollectionRemoveEvent();

    public void completeCollectionRemoveEvent(DiagnosticEvent var1, Object var2, String var3, boolean var4, SharedSessionContractImplementor var5);

    public static enum CacheActionDescription {
        ENTITY_INSERT("Entity Insert"),
        ENTITY_AFTER_INSERT("Entity After Insert"),
        ENTITY_UPDATE("Entity Update"),
        ENTITY_LOAD("Entity Load"),
        ENTITY_AFTER_UPDATE("Entity After Update"),
        TIMESTAMP_PRE_INVALIDATE("Timestamp Pre Invalidate"),
        TIMESTAMP_INVALIDATE("Timestamp Invalidate"),
        COLLECTION_INSERT("Collection Insert"),
        QUERY_RESULT("Query Result");

        private final String text;

        private CacheActionDescription(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        public String getText() {
            return this.text;
        }
    }
}

