/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import sun.jvm.hotspot.oops.Symbol;
import sun.jvm.hotspot.runtime.BasicType;
import sun.jvm.hotspot.utilities.Assert;

public class FieldType {
    private Symbol signature;
    private char first;

    public FieldType(Symbol signature) {
        this.signature = signature;
        this.first = (char)signature.getByteAt(0L);
        if (Assert.ASSERTS_ENABLED) {
            switch (this.first) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'L': 
                case 'S': 
                case 'Z': 
                case '[': {
                    break;
                }
                default: {
                    Assert.that(false, "Unknown char in field signature \"" + signature.asString() + "\": " + this.first);
                }
            }
        }
    }

    public boolean isOop() {
        return this.isObject() || this.isArray();
    }

    public boolean isByte() {
        return this.first == 'B';
    }

    public boolean isChar() {
        return this.first == 'C';
    }

    public boolean isDouble() {
        return this.first == 'D';
    }

    public boolean isFloat() {
        return this.first == 'F';
    }

    public boolean isInt() {
        return this.first == 'I';
    }

    public boolean isLong() {
        return this.first == 'J';
    }

    public boolean isShort() {
        return this.first == 'S';
    }

    public boolean isBoolean() {
        return this.first == 'Z';
    }

    public boolean isObject() {
        return this.first == 'L';
    }

    public boolean isArray() {
        return this.first == '[';
    }

    public Symbol getSignature() {
        return this.signature;
    }

    public ArrayInfo getArrayInfo() {
        int index = 1;
        int dim = 1;
        index = this.skipOptionalSize(this.signature, index);
        while (this.signature.getByteAt(index) == 91) {
            ++dim;
            this.skipOptionalSize(this.signature, ++index);
        }
        int elementType = BasicType.charToType((char)this.signature.getByteAt(index));
        return new ArrayInfo(dim, elementType);
    }

    private int skipOptionalSize(Symbol sig, int index) {
        byte c = sig.getByteAt(index);
        while (c >= 48 && c <= 57) {
            c = sig.getByteAt(++index);
        }
        return index;
    }

    public static class ArrayInfo {
        private int dimension;
        private int elementBasicType;

        public ArrayInfo(int dimension, int elementBasicType) {
            this.dimension = dimension;
            this.elementBasicType = elementBasicType;
        }

        public int dimension() {
            return this.dimension;
        }

        public int elementBasicType() {
            return this.elementBasicType;
        }
    }
}

