/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import java.io.File;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.publish.ImmutablePublishArtifact;
import org.gradle.internal.component.local.model.PublishArtifactLocalArtifactMetadata;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class PublishArtifactLocalArtifactMetadataSerializer
implements Serializer<PublishArtifactLocalArtifactMetadata> {
    private final ComponentIdentifierSerializer componentIdentifierSerializer;

    public PublishArtifactLocalArtifactMetadataSerializer(ComponentIdentifierSerializer componentIdentifierSerializer) {
        this.componentIdentifierSerializer = componentIdentifierSerializer;
    }

    public PublishArtifactLocalArtifactMetadata read(Decoder decoder) throws Exception {
        ComponentIdentifier identifier = this.componentIdentifierSerializer.read(decoder);
        String artifactName = decoder.readString();
        String artifactExtension = decoder.readString();
        String artifactType = decoder.readString();
        String artifactClassifier = decoder.readNullableString();
        File artifactFile = new File(decoder.readString());
        return new PublishArtifactLocalArtifactMetadata(identifier, (PublishArtifact)new ImmutablePublishArtifact(artifactName, artifactExtension, artifactType, artifactClassifier, artifactFile));
    }

    public void write(Encoder encoder, PublishArtifactLocalArtifactMetadata value) throws Exception {
        this.componentIdentifierSerializer.write(encoder, value.getComponentIdentifier());
        PublishArtifact publishArtifact = value.getPublishArtifact();
        encoder.writeString((CharSequence)publishArtifact.getName());
        encoder.writeString((CharSequence)publishArtifact.getType());
        encoder.writeString((CharSequence)publishArtifact.getExtension());
        encoder.writeNullableString((CharSequence)publishArtifact.getClassifier());
        encoder.writeString((CharSequence)publishArtifact.getFile().getCanonicalPath());
    }
}

